/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.decorators;

import de.tobject.findbugs.builder.ResourceUtils;
import de.tobject.findbugs.builder.WorkItem;
import de.tobject.findbugs.util.Util;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;

public class ResourceBugCountDecorator
implements ILabelDecorator {
    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        WorkItem item = ResourceUtils.getWorkItem(element);
        if (item == null) {
            IWorkingSet workingSet = Util.getAdapter(IWorkingSet.class, element);
            if (workingSet != null) {
                return ResourceBugCountDecorator.decorateText(text, workingSet);
            }
            return text;
        }
        return ResourceBugCountDecorator.decorateText(text, item.getMarkerCount(false));
    }

    private static String decorateText(String text, int markerCount) {
        if (markerCount == 0) {
            return text;
        }
        return text + " (" + markerCount + ")";
    }

    private static String decorateText(String text, IWorkingSet workingSet) {
        Set<WorkItem> resources = ResourceUtils.getResources(workingSet);
        int markerCount = 0;
        for (WorkItem workItem : resources) {
            markerCount += workItem.getMarkerCount(true);
        }
        return ResourceBugCountDecorator.decorateText(text, markerCount);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

