/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.ResourceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.JREContainer;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.site.PDEState;
import org.eclipse.pde.internal.core.ClasspathUtilCore;

public class PDEClassPathGenerator {
    public static String[] computeClassPath(IJavaProject javaProject) {
        Set<String> classPath = Collections.EMPTY_SET;
        HashSet<IProject> projectOnCp = new HashSet<IProject>();
        projectOnCp.add(javaProject.getProject());
        try {
            classPath = PDEClassPathGenerator.createPluginClassPath(javaProject, projectOnCp);
        }
        catch (NoClassDefFoundError ce) {
            classPath = PDEClassPathGenerator.createJavaClasspath(javaProject, projectOnCp);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not compute aux. classpath for project " + javaProject);
            return new String[0];
        }
        return classPath.toArray(new String[classPath.size()]);
    }

    private static Set<String> createJavaClasspath(IJavaProject javaProject, Set<IProject> projectOnCp) {
        LinkedHashSet<String> classPath = new LinkedHashSet<String>();
        try {
            IClasspathEntry[] rawClasspath;
            String[] defaultClassPath;
            for (String classpathEntry : defaultClassPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject)) {
                Path path = new Path(classpathEntry);
                if (!PDEClassPathGenerator.isValidPath((IPath)path)) continue;
                classPath.add(path.toOSString());
            }
            block3: for (IClasspathEntry entry : rawClasspath = javaProject.getRawClasspath()) {
                IPath path;
                IClasspathEntry[] classpathEntries;
                IClasspathContainer classpathContainer;
                if (entry.getEntryKind() != 5 || (classpathContainer = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject)) == null) continue;
                if (classpathContainer instanceof JREContainer) {
                    for (IClasspathEntry iClasspathEntry : classpathEntries = classpathContainer.getClasspathEntries()) {
                        path = iClasspathEntry.getPath();
                        if (!PDEClassPathGenerator.isValidPath(path) || !"rt.jar".equals(path.lastSegment())) continue;
                        classPath.add(path.toOSString());
                        continue block3;
                    }
                    continue;
                }
                for (IClasspathEntry classpathEntry : classpathEntries = classpathContainer.getClasspathEntries()) {
                    path = classpathEntry.getPath();
                    if (classpathEntry.getEntryKind() == 1 && PDEClassPathGenerator.isValidPath(path)) {
                        classPath.add(path.toOSString());
                        continue;
                    }
                    PDEClassPathGenerator.resolveInWorkspace(classpathEntry, classPath, projectOnCp);
                }
            }
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not compute aux. classpath for project " + javaProject);
        }
        return classPath;
    }

    private static void resolveInWorkspace(IClasspathEntry classpathEntry, Set<String> classPath, Set<IProject> projectOnCp) {
        int entryKind = classpathEntry.getEntryKind();
        switch (entryKind) {
            case 2: {
                Set<String> cp = PDEClassPathGenerator.resolveProjectClassPath(classpathEntry.getPath(), projectOnCp);
                classPath.addAll(cp);
                break;
            }
            case 4: {
                classpathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntry);
                if (classpathEntry == null) {
                    return;
                }
            }
            case 1: {
                String lib = PDEClassPathGenerator.resolveLibrary(classpathEntry.getPath());
                if (lib == null) break;
                classPath.add(lib);
                break;
            }
            case 3: {
                break;
            }
        }
    }

    @CheckForNull
    private static String resolveLibrary(IPath path) {
        if (path == null || path.segmentCount() != 1) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource == null || !resource.isAccessible()) {
            return null;
        }
        IPath location = resource.getLocation();
        return location == null ? null : location.toOSString();
    }

    private static Set<String> resolveProjectClassPath(IPath path, Set<IProject> projectOnCp) {
        if (path == null || path.segmentCount() != 1) {
            return Collections.emptySet();
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
        if (project == null || projectOnCp.contains(project)) {
            return Collections.emptySet();
        }
        projectOnCp.add(project);
        IJavaProject javaProject2 = JavaCore.create((IProject)project);
        if (javaProject2 != null) {
            return PDEClassPathGenerator.createJavaClasspath(javaProject2, projectOnCp);
        }
        return Collections.emptySet();
    }

    private static boolean isValidPath(IPath path) {
        return path != null && path.segmentCount() > 1 && path.toFile().exists();
    }

    private static Collection<String> createPluginClassPath(IJavaProject javaProject, Set<IProject> projectOnCp) throws CoreException {
        String defaultOutput;
        Set<String> javaClassPath = PDEClassPathGenerator.createJavaClasspath(javaProject, projectOnCp);
        IPluginModelBase model = PluginRegistry.findModel((IProject)javaProject.getProject());
        if (model == null || model.getPluginBase().getId() == null) {
            return javaClassPath;
        }
        ArrayList<String> pdeClassPath = new ArrayList<String>();
        pdeClassPath.addAll(javaClassPath);
        BundleDescription target = model.getBundleDescription();
        HashSet<BundleDescription> bundles = new HashSet<BundleDescription>();
        if (target != null) {
            PDEClassPathGenerator.addDependentBundles(target, bundles);
        }
        IPath defaultOutputLocation = ResourceUtils.relativeToAbsolute(javaProject.getOutputLocation());
        for (BundleDescription bd : bundles) {
            PDEClassPathGenerator.appendBundleToClasspath(bd, pdeClassPath, defaultOutputLocation);
        }
        if (defaultOutputLocation != null && pdeClassPath.indexOf(defaultOutput = defaultOutputLocation.toOSString()) > 0) {
            pdeClassPath.remove(defaultOutput);
            pdeClassPath.add(0, defaultOutput);
        }
        return pdeClassPath;
    }

    private static void appendBundleToClasspath(BundleDescription bd, List<String> pdeClassPath, IPath defaultOutputLocation) {
        IPluginModelBase model = PluginRegistry.findModel((BundleDescription)bd);
        if (model == null) {
            return;
        }
        ArrayList classpathEntries = new ArrayList();
        ClasspathUtilCore.addLibraries((IPluginModelBase)model, classpathEntries);
        for (IClasspathEntry cpe : classpathEntries) {
            String bundleLocation;
            String locationStr;
            IPath location = cpe.getEntryKind() == 3 ? ResourceUtils.getOutputLocation(cpe, defaultOutputLocation) : cpe.getPath();
            if (location == null || pdeClassPath.contains(locationStr = location.toOSString()) || (bundleLocation = bd.getLocation()) != null && !"jar".equals(location.getFileExtension()) && new File(bundleLocation).isDirectory() && bd.getSymbolicName().equals(location.lastSegment())) continue;
            if (!location.isAbsolute()) {
                location = ResourceUtils.relativeToAbsolute(location);
            }
            if (!PDEClassPathGenerator.isValidPath(location) || pdeClassPath.contains(locationStr = location.toOSString())) continue;
            pdeClassPath.add(locationStr);
        }
    }

    private static void addDependentBundles(BundleDescription bd, Set<BundleDescription> bundles) {
        BundleDescription[] bundles2;
        for (BundleDescription bundleDescription : bundles2 = PDEState.getDependentBundlesWithFragments((BundleDescription)bd)) {
            if (bundleDescription == null || bundles.contains(bundleDescription)) continue;
            bundles.add(bundleDescription);
            PDEClassPathGenerator.addDependentBundles(bundleDescription, bundles);
        }
    }
}

