/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindBugsJob;
import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.builder.ResourceUtils;
import de.tobject.findbugs.builder.WorkItem;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.plugin.eclipse.util.MutexSchedulingRule;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class FindBugsAction
implements IObjectActionDelegate {
    protected ISelection selection;
    protected boolean usedInEditor;
    private IWorkbenchPart targetPart;
    private static boolean dialogAlreadyShown;

    public final void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public static boolean isFindBugsPerspectiveActive(IWorkbenchPart part) {
        IPerspectiveDescriptor perspective = FindBugsAction.getWindow(part).getActivePage().getPerspective();
        return perspective != null && "de.tobject.findbugs.FindBugsPerspective".equals(perspective.getId());
    }

    public final void selectionChanged(IAction action, ISelection newSelection) {
        if (!this.usedInEditor) {
            this.selection = newSelection;
        }
    }

    public void run(IAction action) {
        boolean confirm;
        if (this.selection == null || this.selection.isEmpty()) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        if (!description.isAutoBuilding() && this.getClass().equals(FindBugsAction.class) && !(confirm = MessageDialog.openConfirm(null, (String)"Project -> 'Build Automatically' disabled", (String)"You are going to run FindBugs analysis on a not compiled or partially compiled project.\n\nTo get reliable analysis results, you should make sure that project is compiled first.\n\nContinue with FindBugs analysis?"))) {
            return;
        }
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)this.selection;
            dialogAlreadyShown = false;
            Map<IProject, List<WorkItem>> projectMap = ResourceUtils.getResourcesPerProject(sSelection);
            for (Map.Entry<IProject, List<WorkItem>> e : projectMap.entrySet()) {
                this.work(this.targetPart, (IResource)e.getKey(), e.getValue());
            }
            this.targetPart = null;
            this.selection = null;
        }
    }

    protected IDialogSettings getDialogSettings() {
        String settingsId;
        IDialogSettings settings = FindbugsPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(settingsId = this.getDialogSettingsId());
        if (section == null) {
            section = settings.addNewSection(settingsId);
        }
        return section;
    }

    protected final IProject getProject(IStructuredSelection structuredSelection) {
        Object element = structuredSelection.getFirstElement();
        IResource resource = ResourceUtils.getResource(element);
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        return project;
    }

    protected String getDialogSettingsId() {
        return "findBugsAction";
    }

    protected void work(IWorkbenchPart part, IResource resource, List<WorkItem> resources) {
        StartedFromViewJob runFindBugs = new StartedFromViewJob("Finding bugs in " + resource.getName() + "...", resource, resources, part);
        runFindBugs.scheduleInteractive();
    }

    protected static void refreshViewer(IWorkbenchPart targetPart, final List<WorkItem> resources) {
        if (targetPart == null) {
            return;
        }
        ISelectionProvider selProvider = (ISelectionProvider)targetPart.getAdapter(ISelectionProvider.class);
        if (!(selProvider instanceof TreeViewer)) {
            return;
        }
        final TreeViewer viewer = (TreeViewer)selProvider;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (viewer.getControl().isDisposed()) {
                    return;
                }
                for (WorkItem workItem : resources) {
                    if (!(workItem.getMarkerTarget() instanceof IProject)) continue;
                    viewer.refresh((Object)workItem.getCorespondingJavaElement(), true);
                }
            }
        });
    }

    protected static void askUserToSwitch(IWorkbenchPart part, int warningsNumber) {
        IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
        String message = "FindBugs analysis finished, " + warningsNumber + " warnings found.\n\nSwitch to the FindBugs perspective?";
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion(null, (String)"FindBugs analysis finished", (String)message, (String)"Remember the choice and do not ask me in the future", (boolean)false, (IPreferenceStore)store, (String)"askAboutPerspectiveSwitch");
        boolean remember = dialog.getToggleState();
        int returnCode = dialog.getReturnCode();
        if (returnCode == 2) {
            if (remember) {
                store.setValue("switchPerspectiveAfterAnalysis", true);
            }
            FindBugsAction.switchPerspective(part);
        } else if (returnCode == 3 && remember) {
            store.setValue("switchPerspectiveAfterAnalysis", false);
        }
    }

    protected static IWorkbenchWindow getWindow(IWorkbenchPart part) {
        IWorkbenchPartSite currentSite = part != null ? part.getSite() : null;
        IWorkbenchWindow window = currentSite != null ? currentSite.getWorkbenchWindow() : FindbugsPlugin.getActiveWorkbenchWindow();
        return window;
    }

    protected static void switchPerspective(IWorkbenchPart part) {
        IWorkbenchWindow window = FindBugsAction.getWindow(part);
        IWorkbenchPage page = window.getActivePage();
        Object input = page != null ? page.getInput() : ResourcesPlugin.getWorkspace().getRoot();
        try {
            PlatformUI.getWorkbench().showPerspective("de.tobject.findbugs.FindBugsPerspective", window, input);
        }
        catch (WorkbenchException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to open FindBugs Perspective");
        }
    }

    private static final class StartedFromViewJob
    extends FindBugsJob {
        private final List<WorkItem> resources;
        private final IResource resource;
        private final IWorkbenchPart targetPart;

        private StartedFromViewJob(String name, IResource resource, List<WorkItem> resources, IWorkbenchPart targetPart) {
            super(name, resource);
            this.resources = resources;
            this.resource = resource;
            this.targetPart = targetPart;
        }

        @Override
        protected boolean supportsMulticore() {
            return MutexSchedulingRule.MULTICORE;
        }

        @Override
        protected void runWithProgress(IProgressMonitor monitor) throws CoreException {
            FindBugsWorker worker = new FindBugsWorker(this.resource, monitor);
            worker.work(this.resources);
            FindBugsAction.refreshViewer(this.targetPart, this.resources);
            this.checkPerspective();
        }

        private void checkPerspective() {
            if (FindBugsAction.isFindBugsPerspectiveActive(this.targetPart)) {
                return;
            }
            final IMarker[] allMarkers = MarkerUtil.getAllMarkers(this.resource);
            if (allMarkers.length == 0) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (FindBugsAction.isFindBugsPerspectiveActive(StartedFromViewJob.this.targetPart)) {
                        return;
                    }
                    IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
                    boolean ask = store.getBoolean("askAboutPerspectiveSwitch");
                    if (ask && !dialogAlreadyShown) {
                        dialogAlreadyShown = true;
                        FindBugsAction.askUserToSwitch(StartedFromViewJob.this.targetPart, allMarkers.length);
                    } else if (store.getBoolean("switchPerspectiveAfterAnalysis")) {
                        FindBugsAction.switchPerspective(StartedFromViewJob.this.targetPart);
                    }
                }
            });
        }
    }
}

