/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.preferences.FindBugsConstants;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.BugGroup;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class FilterPatternAction
implements IObjectActionDelegate {
    private CommonNavigator navigator;
    private Object data;
    private boolean useSpecificPattern;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof CommonNavigator) {
            this.navigator = (CommonNavigator)targetPart;
            this.useSpecificPattern = action.getId().startsWith("de.tobject.findbugs.filterSpecificPattern");
        }
    }

    public void run(IAction action) {
        Set<String> sortedIds = FindbugsPlugin.getFilteredIds();
        String patternType = this.getPatternOrPatternType();
        if (patternType != null) {
            if (!sortedIds.contains(patternType)) {
                sortedIds.add(patternType);
            } else {
                sortedIds.remove(patternType);
            }
        }
        String ids = FindBugsConstants.encodeIds(sortedIds);
        IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
        store.setValue("lastUsedExportFilter", ids);
        BugContentProvider provider = BugContentProvider.getProvider(this.navigator.getNavigatorContentService());
        if (!provider.isBugFilterActive()) {
            MessageDialog.openWarning(null, (String)"Toggle Filter", (String)"Filtering by pattern or type id is currently not enabled!\nTo enable it, please select \"Toggle Filters...->Bugs by Id\" filter!");
        }
        provider.refreshFilters();
        CommonViewer viewer = this.navigator.getCommonViewer();
        Object[] expandedElements = viewer.getExpandedElements();
        viewer.refresh(true);
        viewer.setExpandedElements(expandedElements);
        this.data = null;
    }

    private String getPatternOrPatternType() {
        if (this.data instanceof IMarker) {
            BugInstance bug = MarkerUtil.findBugInstanceForMarker((IMarker)this.data);
            if (bug == null) {
                return null;
            }
            if (this.useSpecificPattern) {
                return bug.getType();
            }
            return bug.getAbbrev();
        }
        if (this.data instanceof BugPattern) {
            BugPattern pattern = (BugPattern)this.data;
            if (this.useSpecificPattern) {
                return pattern.getType();
            }
            return pattern.getAbbrev();
        }
        if (this.data instanceof BugCode) {
            return ((BugCode)this.data).getAbbrev();
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            this.data = null;
            action.setEnabled(false);
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            this.data = null;
            action.setEnabled(false);
            return;
        }
        Object firstElement = ss.getFirstElement();
        if (firstElement instanceof IMarker) {
            this.data = firstElement;
            action.setEnabled(true);
            return;
        }
        if (!(firstElement instanceof BugGroup)) {
            this.data = null;
            action.setEnabled(false);
            return;
        }
        this.data = ((BugGroup)firstElement).getData();
        action.setEnabled(this.data != null);
    }
}

