/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs;

import de.tobject.findbugs.DetectorsExtensionHelper;
import de.tobject.findbugs.EclipseGuiCallback;
import de.tobject.findbugs.FindbugsSaveParticipant;
import de.tobject.findbugs.builder.FindBugsBuilder;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.io.FileOutput;
import de.tobject.findbugs.io.IO;
import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.nature.FindBugsNature;
import de.tobject.findbugs.preferences.FindBugsConstants;
import de.tobject.findbugs.preferences.FindBugsPreferenceInitializer;
import de.tobject.findbugs.properties.DetectorValidator;
import de.tobject.findbugs.reporter.Reporter;
import de.tobject.findbugs.view.IMarkerSelectionHandler;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolutionAssociations;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolutionLoader;
import edu.umd.cs.findbugs.plugins.DuplicatePluginIdException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import org.dom4j.DocumentException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FindbugsPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "edu.umd.cs.findbugs.plugin.eclipse";
    private static final String DEFAULT_CLOUD_ID = "edu.umd.cs.findbugs.cloud.doNothingCloud";
    public static final String ICON_PATH = "icons/";
    public static final String ICON_DEFAULT = "buggy-tiny-gray.png";
    private static final IPath WORKSPACE_PREFS_PATH = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).append(".settings").append("edu.umd.cs.findbugs.plugin.eclipse.prefs");
    public static final IPath DEFAULT_PREFS_PATH = new Path(".settings").append("edu.umd.cs.findbugs.core.prefs");
    public static final IPath DEPRECATED_PREFS_PATH = new Path(".fbprefs");
    public static final String DETAILS_VIEW_ID = "de.tobject.findbugs.view.buginfoview";
    public static final String USER_ANNOTATIONS_VIEW_ID = "de.tobject.findbugs.view.userannotationsview";
    public static final String TREE_VIEW_ID = "de.tobject.findbugs.view.bugtreeview";
    public static final String BUG_CONTENT_PROVIDER_ID = "de.tobject.findbugs.view.explorer.BugContentProvider";
    private final Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>(13);
    public static boolean DEBUG;
    public static final String BUILDER_ID = "edu.umd.cs.findbugs.plugin.eclipse.findbugsBuilder";
    public static final String NATURE_ID = "edu.umd.cs.findbugs.plugin.eclipse.findbugsNature";
    private static final String PLUGIN_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug";
    private static final String BUILDER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/builder";
    private static final String NATURE_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/nature";
    private static final String REPORTER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/reporter";
    private static final String CONTENT_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/content";
    private static final String PROFILER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/profiler";
    public static final QualifiedName SESSION_PROPERTY_BUG_COLLECTION;
    public static final QualifiedName SESSION_PROPERTY_BUG_COLLECTION_DIRTY;
    public static final QualifiedName SESSION_PROPERTY_USERPREFS;
    public static final QualifiedName SESSION_PROPERTY_SETTINGS_ON;
    public static final String LIST_DELIMITER = ";";
    private static FindbugsPlugin plugin;
    private static boolean customDetectorsInitialized;
    private ResourceBundle resourceBundle;
    private BugResolutionAssociations bugResolutions;
    private boolean bugResolutionsLoaded;

    public FindbugsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Version.registerApplication("FindBugs-Eclipse", Version.RELEASE);
        this.configurePluginDebugOptions();
        try {
            this.resourceBundle = ResourceBundle.getBundle("de.tobject.findbugs.messages");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        if (System.getProperty("findbugs.home") == null) {
            String findBugsHome = FindbugsPlugin.getFindBugsEnginePluginLocation();
            if (DEBUG) {
                this.logInfo("FindBugs home is: " + findBugsHome);
            }
            System.setProperty("findbugs.home", findBugsHome);
        }
        if (System.getProperty("findbugs.cloud.default") == null) {
            String defCloud = DEFAULT_CLOUD_ID;
            if (DEBUG) {
                this.logInfo("Using default cloud: " + defCloud);
            }
            System.setProperty("findbugs.cloud.default", defCloud);
        }
        FindBugs.setNoMains();
        SystemProperties.setProperty("findbugs.sf.comment", "true");
        FindbugsSaveParticipant saveParticipant = new FindbugsSaveParticipant();
        ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, (ISaveParticipant)saveParticipant);
    }

    public static void dumpClassLoader(Class<?> c) {
        System.out.printf("Class loaders for %s:%n", c.getName());
        for (ClassLoader loader = c.getClassLoader(); loader != null; loader = loader.getParent()) {
            System.out.printf("  %s %s%n", loader.toString(), loader.getClass().getSimpleName());
        }
    }

    public static synchronized void applyCustomDetectors(boolean force) {
        String pluginId;
        if (customDetectorsInitialized && !force) {
            return;
        }
        customDetectorsInitialized = true;
        DetectorValidator validator = new DetectorValidator();
        TreeSet<String> detectorPaths = new TreeSet<String>();
        SortedMap<String, String> contributedDetectors = DetectorsExtensionHelper.getContributedDetectors();
        UserPreferences corePreferences = FindbugsPlugin.getCorePreferences(null, force);
        detectorPaths.addAll(corePreferences.getCustomPlugins(true));
        if (DEBUG) {
            FindbugsPlugin.dumpClassLoader(FindbugsPlugin.class);
            FindbugsPlugin.dumpClassLoader(Plugin.class);
            System.out.println("applyCustomDetectors - going to add " + detectorPaths.size() + " plugin urls...");
            for (String url : detectorPaths) {
                System.out.println("\t" + url);
            }
        }
        Set<String> disabledPlugins = corePreferences.getCustomPlugins(false);
        Map<URI, Plugin> allPlugins = Plugin.getAllPluginsMap();
        for (Map.Entry<URI, Plugin> entry : allPlugins.entrySet()) {
            Plugin plugin = entry.getValue();
            pluginId = plugin.getPluginId();
            if (contributedDetectors.containsKey(pluginId)) {
                contributedDetectors.remove(pluginId);
                detectorPaths.remove(pluginId);
            }
            if (plugin.isCorePlugin() || plugin.isInitialPlugin() || !disabledPlugins.contains(entry.getKey().getPath()) && !disabledPlugins.contains(pluginId)) continue;
            plugin.setGloballyEnabled(false);
            Plugin.removeCustomPlugin(plugin);
            if (!DEBUG) continue;
            System.out.println("Removed plugin: " + plugin + " loaded from " + entry.getKey());
        }
        HashSet<Plugin> enabled = new HashSet<Plugin>();
        for (Map.Entry<String, String> entry : contributedDetectors.entrySet()) {
            pluginId = entry.getKey();
            String pluginPath = entry.getValue();
            URI uri = new File(pluginPath).toURI();
            if (disabledPlugins.contains(pluginId) || disabledPlugins.contains(pluginPath) || allPlugins.containsKey(uri)) continue;
            FindbugsPlugin.addCustomPlugin(enabled, uri);
        }
        for (String string : detectorPaths) {
            String string2;
            URI uri;
            if (new Path(string).segmentCount() == 1 || allPlugins.containsKey(uri = new File(string2 = FindBugsWorker.getFilterPath(string, null).toOSString()).toURI())) continue;
            DetectorValidator.ValidationStatus status = validator.validate(string2);
            if (status.isOK()) {
                FindbugsPlugin.addCustomPlugin(enabled, uri);
                continue;
            }
            FindbugsPlugin.getDefault().getLog().log((IStatus)status);
        }
        if (DEBUG) {
            System.out.println("applyCustomDetectors - there was " + detectorPaths.size() + " extra FB plugin urls with " + enabled.size() + " valid FB plugins and " + allPlugins.size() + " total plugins registered by FB.");
            for (Map.Entry<Object, Object> entry : allPlugins.entrySet()) {
                Plugin fbPlugin = (Plugin)entry.getValue();
                if (fbPlugin.isGloballyEnabled()) {
                    System.out.println("IS  enabled:\t" + fbPlugin.getPluginId());
                    continue;
                }
                System.out.println("NOT enabled:\t" + fbPlugin.getPluginId());
            }
        }
    }

    protected static void addCustomPlugin(HashSet<Plugin> enabled, URI uri) {
        try {
            Plugin fbPlugin = Plugin.addCustomPlugin(uri, FindbugsPlugin.class.getClassLoader());
            if (fbPlugin != null) {
                fbPlugin.setGloballyEnabled(true);
                enabled.add(fbPlugin);
            }
        }
        catch (PluginException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to load plugin for custom detector: " + uri);
        }
        catch (DuplicatePluginIdException e) {
            FindbugsPlugin.getDefault().logException(e, e.getPluginId() + " already loaded from " + e.getPreviouslyLoadedFrom() + ", ignoring: " + uri);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        String iconName;
        for (FindBugsMarker.MarkerRank markerRank : FindBugsMarker.MarkerRank.values()) {
            iconName = markerRank.iconName();
            this.registerIcon(reg, iconName);
        }
        for (Enum enum_ : FindBugsMarker.MarkerConfidence.values()) {
            iconName = ((FindBugsMarker.MarkerConfidence)enum_).iconName();
            this.registerIcon(reg, iconName);
        }
        this.registerIcon(reg, ICON_DEFAULT);
    }

    private void registerIcon(ImageRegistry reg, String iconName) {
        ImageDescriptor descriptor = this.getImageDescriptor(iconName);
        if (descriptor != null) {
            reg.put(iconName, descriptor);
        }
    }

    public static FindbugsPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (Display.getCurrent() != null) {
            return FindbugsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        }
        final IWorkbenchWindow[] window = new IWorkbenchWindow[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                window[0] = FindbugsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            }
        });
        return window[0];
    }

    public static Shell getShell() {
        IWorkbenchWindow window = FindbugsPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = FindbugsPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void configurePluginDebugOptions() {
        if (this.isDebugging()) {
            String option = Platform.getDebugOption((String)PLUGIN_DEBUG);
            DEBUG = Boolean.valueOf(option);
            option = Platform.getDebugOption((String)BUILDER_DEBUG);
            FindBugsWorker.DEBUG = FindBugsBuilder.DEBUG = Boolean.valueOf(option).booleanValue();
            option = Platform.getDebugOption((String)NATURE_DEBUG);
            FindBugsNature.DEBUG = Boolean.valueOf(option);
            option = Platform.getDebugOption((String)REPORTER_DEBUG);
            Reporter.DEBUG = Boolean.valueOf(option);
            option = Platform.getDebugOption((String)CONTENT_DEBUG);
            BugContentProvider.DEBUG = Boolean.valueOf(option);
            option = Platform.getDebugOption((String)PROFILER_DEBUG);
            if (Boolean.valueOf(option).booleanValue()) {
                System.setProperty("profiler.report", "true");
            }
        }
    }

    public static String getFindBugsEnginePluginLocation() {
        URL u = plugin.getBundle().getEntry("/");
        try {
            URL bundleRoot = FileLocator.resolve((URL)u);
            String path = bundleRoot.getPath();
            if (FindBugsBuilder.DEBUG) {
                System.out.println("Pluginpath: " + path);
            }
            if (path.endsWith("/eclipsePlugin/")) {
                File f = new File(path);
                f = f.getParentFile();
                f = new File(f, "findbugs");
                path = f.getPath() + "/";
            }
            return path;
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "IO Exception locating engine plugin");
            return null;
        }
    }

    public String getMessage(String key) {
        return FindbugsPlugin.getResourceString(key);
    }

    public void logException(Throwable e, String message) {
        this.logMessage(4, message, e);
    }

    public void logError(String message) {
        this.logMessage(4, message, null);
    }

    public void logWarning(String message) {
        this.logMessage(2, message, null);
    }

    public void logInfo(String message) {
        this.logMessage(1, message, null);
    }

    public void logMessage(int severity, String message, Throwable e) {
        if (DEBUG) {
            String what = severity == 4 ? (e != null ? "Exception" : "Error") : "Warning";
            System.out.println(what + " in FindBugs plugin: " + message);
            if (e != null) {
                e.printStackTrace();
            }
        }
        IStatus status = FindbugsPlugin.createStatus(severity, message, e);
        this.getLog().log(status);
    }

    public static IStatus createStatus(int severity, String message, Throwable e) {
        return new Status(severity, PLUGIN_ID, 0, message, e);
    }

    public static IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, PLUGIN_ID, 0, message, e);
    }

    public static IPath getBugCollectionFile(IProject project) {
        IPath path = FindbugsPlugin.getDefault().getStateLocation();
        return path.append(project.getName() + ".fbwarnings.xml");
    }

    private static boolean isBugCollectionDirty(IProject project) throws CoreException {
        Object dirty = project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION_DIRTY);
        if (dirty == null) {
            return false;
        }
        return (Boolean)dirty;
    }

    public static void markBugCollectionDirty(IProject project, boolean isDirty) throws CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION_DIRTY, (Object)(isDirty ? Boolean.TRUE : Boolean.FALSE));
    }

    @CheckForNull
    public static SortedBugCollection getBugCollectionIfSet(IProject project) {
        try {
            return (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
        }
        catch (CoreException ignored) {
            FindbugsPlugin.getDefault().logException(ignored, "IO Exception reading project bugs.");
            return null;
        }
    }

    public static SortedBugCollection getBugCollection(IProject project, IProgressMonitor monitor) throws CoreException {
        return FindbugsPlugin.getBugCollection(project, monitor, true);
    }

    public static SortedBugCollection getBugCollection(IProject project, IProgressMonitor monitor, boolean useCloud) throws CoreException {
        SortedBugCollection bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
        if (bugCollection == null) {
            try {
                FindbugsPlugin.readBugCollectionAndProject(project, monitor, useCloud);
                bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not read bug collection for project");
                bugCollection = FindbugsPlugin.createDefaultEmptyBugCollection(project);
            }
            catch (DocumentException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not read bug collection for project");
                bugCollection = FindbugsPlugin.createDefaultEmptyBugCollection(project);
            }
        }
        return bugCollection;
    }

    private static void cacheBugCollectionAndProject(IProject project, SortedBugCollection bugCollection, Project fbProject) throws CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION, (Object)bugCollection);
        FindbugsPlugin.markBugCollectionDirty(project, false);
    }

    private static SortedBugCollection createDefaultEmptyBugCollection(IProject project) throws CoreException {
        SortedBugCollection bugCollection = new SortedBugCollection();
        Project fbProject = bugCollection.getProject();
        UserPreferences userPrefs = FindbugsPlugin.getUserPreferences(project);
        String cloudId = userPrefs.getCloudId();
        if (cloudId != null) {
            fbProject.setCloudId(cloudId);
        }
        FindbugsPlugin.cacheBugCollectionAndProject(project, bugCollection, fbProject);
        return bugCollection;
    }

    private static void readBugCollectionAndProject(IProject project, IProgressMonitor monitor, boolean useCloud) throws IOException, DocumentException, CoreException {
        String cloudId;
        IPath bugCollectionPath = FindbugsPlugin.getBugCollectionFile(project);
        File bugCollectionFile = bugCollectionPath.toFile();
        if (!bugCollectionFile.exists()) {
            FindbugsPlugin.getDefault().logInfo("creating new bug collection: " + bugCollectionPath.toOSString());
            FindbugsPlugin.createDefaultEmptyBugCollection(project);
            return;
        }
        UserPreferences prefs = FindbugsPlugin.getUserPreferences(project);
        SortedBugCollection bugCollection = new SortedBugCollection();
        bugCollection.getProject().setGuiCallback(new EclipseGuiCallback(project));
        bugCollection.setDoNotUseCloud(!useCloud);
        bugCollection.readXML(bugCollectionFile);
        if (useCloud && (cloudId = prefs.getCloudId()) != null) {
            bugCollection.getProject().setCloudId(cloudId);
        }
        FindbugsPlugin.cacheBugCollectionAndProject(project, bugCollection, bugCollection.getProject());
    }

    public static void storeBugCollection(IProject project, SortedBugCollection bugCollection, IProgressMonitor monitor) throws IOException, CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION, (Object)bugCollection);
        if (bugCollection != null) {
            FindbugsPlugin.writeBugCollection(project, bugCollection, monitor);
        }
    }

    public static void saveCurrentBugCollection(IProject project, IProgressMonitor monitor) throws CoreException {
        SortedBugCollection bugCollection;
        if (FindbugsPlugin.isBugCollectionDirty(project) && (bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION)) != null) {
            FindbugsPlugin.writeBugCollection(project, bugCollection, monitor);
        }
    }

    private static void writeBugCollection(IProject project, final SortedBugCollection bugCollection, IProgressMonitor monitor) throws CoreException {
        IPath bugCollectionPath = FindbugsPlugin.getBugCollectionFile(project);
        File bugCollectionFile = bugCollectionPath.toFile();
        FileOutput fileOutput = new FileOutput(){

            @Override
            public void writeFile(OutputStream os) throws IOException {
                bugCollection.writeXML(os);
            }

            @Override
            public String getTaskDescription() {
                return "creating XML FindBugs data file";
            }
        };
        IO.writeFile(bugCollectionFile, fileOutput, monitor);
        FindbugsPlugin.markBugCollectionDirty(project, false);
    }

    private static IFile getUserPreferencesFile(IProject project) {
        IFile defaultFile = project.getFile(DEFAULT_PREFS_PATH);
        IFile oldFile = project.getFile(DEPRECATED_PREFS_PATH);
        if (defaultFile.isAccessible() || !oldFile.isAccessible()) {
            return defaultFile;
        }
        return oldFile;
    }

    public static boolean isProjectSettingsEnabled(IProject project) {
        Boolean enabled;
        try {
            enabled = (Boolean)project.getSessionProperty(SESSION_PROPERTY_SETTINGS_ON);
        }
        catch (CoreException e) {
            enabled = null;
        }
        if (enabled != null) {
            return enabled;
        }
        IFile file = FindbugsPlugin.getUserPreferencesFile(project);
        boolean projectPropsEnabled = file.isAccessible();
        if (projectPropsEnabled) {
            ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), PLUGIN_ID);
            projectPropsEnabled = !store.contains("disableProjectProps") || !store.getBoolean("disableProjectProps");
        }
        FindbugsPlugin.setProjectSettingsEnabled(project, null, projectPropsEnabled);
        return projectPropsEnabled;
    }

    public static void setProjectSettingsEnabled(IProject project, @CheckForNull IPreferenceStore store, boolean enabled) {
        try {
            project.setSessionProperty(SESSION_PROPERTY_SETTINGS_ON, (Object)enabled);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Error setting FindBugs session property for project");
        }
        if (store != null) {
            store.setValue("disableProjectProps", !enabled);
        }
    }

    public static UserPreferences getCorePreferences(@CheckForNull IProject project, boolean forceRead) {
        if (project == null || !FindbugsPlugin.isProjectSettingsEnabled(project)) {
            return FindbugsPlugin.getWorkspacePreferences();
        }
        return FindbugsPlugin.getProjectPreferences(project, forceRead);
    }

    public static IPreferenceStore getPluginPreferences(@CheckForNull IProject project) {
        if (project == null || !FindbugsPlugin.isProjectSettingsEnabled(project)) {
            return new ScopedPreferenceStore((IScopeContext)new InstanceScope(), PLUGIN_ID);
        }
        return new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), PLUGIN_ID);
    }

    public static UserPreferences getProjectPreferences(IProject project, boolean forceRead) {
        try {
            UserPreferences prefs = (UserPreferences)project.getSessionProperty(SESSION_PROPERTY_USERPREFS);
            if (prefs == null || forceRead) {
                prefs = FindbugsPlugin.readUserPreferences(project);
                if (prefs == null) {
                    prefs = FindbugsPlugin.getWorkspacePreferences().clone();
                }
                project.setSessionProperty(SESSION_PROPERTY_USERPREFS, (Object)prefs);
            }
            return prefs;
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Error getting FindBugs preferences for project");
            return FindbugsPlugin.getWorkspacePreferences().clone();
        }
    }

    private static UserPreferences getWorkspacePreferences() {
        UserPreferences userPrefs = FindBugsPreferenceInitializer.createDefaultUserPreferences();
        File prefsFile = WORKSPACE_PREFS_PATH.toFile();
        if (!prefsFile.isFile()) {
            return userPrefs;
        }
        try {
            FileInputStream in = new FileInputStream(prefsFile);
            userPrefs.read(in);
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Error reading custom FindBugs preferences for workspace");
        }
        return userPrefs;
    }

    public static UserPreferences getUserPreferences(IProject project) {
        return FindbugsPlugin.getCorePreferences(project, false);
    }

    public static void saveUserPreferences(IProject project, final UserPreferences userPrefs) throws CoreException {
        FileOutput userPrefsOutput = new FileOutput(){

            @Override
            public void writeFile(OutputStream os) throws IOException {
                userPrefs.write(os);
            }

            @Override
            public String getTaskDescription() {
                return "writing user preferences";
            }
        };
        if (project != null) {
            project.setSessionProperty(SESSION_PROPERTY_USERPREFS, (Object)userPrefs);
            IFile userPrefsFile = FindbugsPlugin.getUserPreferencesFile(project);
            FindbugsPlugin.ensureReadWrite(userPrefsFile);
            IO.writeFile(userPrefsFile, userPrefsOutput, null);
            if (project.getFile(DEPRECATED_PREFS_PATH).equals(userPrefsFile)) {
                String message = "Found old style FindBugs preferences for project '" + project.getName() + "'. This preferences are not at the default location: '" + DEFAULT_PREFS_PATH + "'." + " Please move '" + DEPRECATED_PREFS_PATH + "' to '" + DEFAULT_PREFS_PATH + "'.";
                FindbugsPlugin.getDefault().logWarning(message);
            }
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                userPrefs.write(bos);
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Failed to write user preferences");
                return;
            }
            Properties props = new Properties();
            try {
                props.load(new ByteArrayInputStream(bos.toByteArray()));
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Failed to save user preferences");
                return;
            }
            IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
            FindbugsPlugin.resetStore(store, "plugin");
            FindbugsPlugin.resetStore(store, "excludebugs");
            FindbugsPlugin.resetStore(store, "excludefilter");
            FindbugsPlugin.resetStore(store, "includefilter");
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                store.putValue((String)entry.getKey(), (String)entry.getValue());
            }
            if (store instanceof IPersistentPreferenceStore) {
                IPersistentPreferenceStore store2 = (IPersistentPreferenceStore)store;
                try {
                    store2.save();
                }
                catch (IOException e) {
                    FindbugsPlugin.getDefault().logException(e, "Failed to save user preferences");
                }
            }
        }
    }

    private static void resetStore(IPreferenceStore store, String prefix) {
        String name;
        for (int start = 0; start < 99 && store.contains(name = prefix + start); ++start) {
            store.setToDefault(name);
        }
    }

    private static void ensureReadWrite(IFile file) throws CoreException {
        IStatus checkOutStatus;
        if (file.isReadOnly() && !(checkOutStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).isOK()) {
            throw new CoreException(checkOutStatus);
        }
    }

    private static UserPreferences readUserPreferences(IProject project) throws CoreException {
        IFile userPrefsFile = FindbugsPlugin.getUserPreferencesFile(project);
        if (!userPrefsFile.exists()) {
            return null;
        }
        try {
            InputStream in = userPrefsFile.getContents(true);
            UserPreferences userPrefs = FindBugsPreferenceInitializer.createDefaultUserPreferences();
            userPrefs.read(in);
            return userPrefs;
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not read user preferences for project");
            return null;
        }
    }

    public BugResolutionAssociations getBugResolutions() {
        if (!this.bugResolutionsLoaded) {
            this.bugResolutionsLoaded = true;
            try {
                this.bugResolutions = FindbugsPlugin.loadBugResolutions();
            }
            catch (Exception e) {
                FindbugsPlugin.getDefault().logException(e, "Could not read load bug resolutions");
            }
        }
        return this.bugResolutions;
    }

    private static BugResolutionAssociations loadBugResolutions() {
        BugResolutionLoader loader = new BugResolutionLoader();
        return loader.loadBugResolutions();
    }

    public static void showMarker(IMarker marker, String viewId, IWorkbenchPart source) {
        IViewPart view;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (!page.isPartVisible((IWorkbenchPart)(view = page.findView(viewId)))) {
            try {
                view = page.showView(viewId);
            }
            catch (PartInitException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not open view: " + viewId);
                return;
            }
        }
        if (view instanceof IMarkerSelectionHandler) {
            IMarkerSelectionHandler handler = (IMarkerSelectionHandler)view;
            handler.markerSelected(source, marker);
        } else if (DETAILS_VIEW_ID.equals(viewId) && view instanceof ISelectionListener) {
            ISelectionListener listener = (ISelectionListener)view;
            listener.selectionChanged(source, (ISelection)new StructuredSelection((Object)marker));
        }
    }

    public ImageDescriptor getImageDescriptor(String id) {
        ImageDescriptor imageDescriptor = this.imageDescriptors.get(id);
        if (imageDescriptor == null) {
            String pluginId = FindbugsPlugin.getDefault().getBundle().getSymbolicName();
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)(ICON_PATH + id));
            this.imageDescriptors.put(id, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Set<BugPattern> getKnownPatterns() {
        TreeSet<BugPattern> patterns = new TreeSet<BugPattern>();
        Iterator<BugPattern> patternIterator = DetectorFactoryCollection.instance().bugPatternIterator();
        while (patternIterator.hasNext()) {
            patterns.add(patternIterator.next());
        }
        return patterns;
    }

    public static Set<BugCode> getKnownPatternTypes() {
        TreeSet<BugCode> patterns = new TreeSet<BugCode>(DetectorFactoryCollection.instance().getBugCodes());
        return patterns;
    }

    public static Set<String> getFilteredIds() {
        IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
        String lastUsedFilter = store.getString("lastUsedExportFilter");
        return FindBugsConstants.decodeIds(lastUsedFilter);
    }

    public static Set<BugPattern> getFilteredPatterns() {
        Iterator<BugPattern> patternIterator = DetectorFactoryCollection.instance().bugPatternIterator();
        HashSet<BugPattern> set = new HashSet<BugPattern>();
        Set<String> patternTypes = FindbugsPlugin.getFilteredIds();
        while (patternIterator.hasNext()) {
            BugPattern next = patternIterator.next();
            String patternId = next.getType();
            if (!patternTypes.contains(patternId)) continue;
            set.add(next);
        }
        return set;
    }

    public static Set<BugCode> getFilteredPatternTypes() {
        HashSet<BugCode> set = new HashSet<BugCode>();
        Set<String> patternTypes = FindbugsPlugin.getFilteredIds();
        for (BugCode next : DetectorFactoryCollection.instance().getBugCodes()) {
            String type = next.getAbbrev();
            if (!patternTypes.contains(type)) continue;
            set.add(next);
        }
        return set;
    }

    public static void clearBugCollection(IProject project) throws CoreException {
        FindbugsPlugin.createDefaultEmptyBugCollection(project);
        FindbugsPlugin.markBugCollectionDirty(project, true);
        FindbugsPlugin.saveCurrentBugCollection(project, null);
    }

    public static void log(String msg) {
        FindbugsPlugin.log(msg, null);
    }

    public static void log(String msg, Exception e) {
        plugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, msg, (Throwable)e));
    }

    static {
        SESSION_PROPERTY_BUG_COLLECTION = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "bugcollection");
        SESSION_PROPERTY_BUG_COLLECTION_DIRTY = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "bugcollection.dirty");
        SESSION_PROPERTY_USERPREFS = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "userprefs");
        SESSION_PROPERTY_SETTINGS_ON = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "settingsOn");
    }
}

