/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.action;

import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;

public class PushAction
extends SynchronizeModelAction {
    public PushAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        return new SynchronizeModelOperation(configuration, elements){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                PushAction.this.runPushOperation();
            }
        };
    }

    public boolean isEnabled() {
        GitSynchronizeDataSet gsds = (GitSynchronizeDataSet)this.getConfiguration().getProperty("GIT_SYNCHRONIZE_DATA_SET");
        for (GitSynchronizeData gsd : gsds) {
            if (gsd.getDstRemoteName() == null) continue;
            return true;
        }
        return false;
    }

    private void runPushOperation() {
        GitSynchronizeDataSet gsds = (GitSynchronizeDataSet)this.getConfiguration().getProperty("GIT_SYNCHRONIZE_DATA_SET");
        for (GitSynchronizeData gsd : gsds) {
            RemoteConfig rc;
            String remoteName = gsd.getSrcRemoteName();
            if (remoteName == null) continue;
            Repository repo = gsd.getRepository();
            StoredConfig config = repo.getConfig();
            try {
                rc = new RemoteConfig((Config)config, remoteName);
            }
            catch (URISyntaxException e) {
                Activator.logError("Unable to create RemoteConfiguration for remote: " + remoteName, e);
                continue;
            }
            if (rc.getPushRefSpecs().isEmpty()) {
                rc.addPushRefSpec(new RefSpec("HEAD:" + gsd.getDstMerge()));
            }
            PushOperationUI push = new PushOperationUI(repo, rc, false);
            push.setCredentialsProvider(new EGitCredentialsProvider());
            push.start();
        }
    }
}

