/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.core.internal.rebase.RebaseInteractivePlan;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveView;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseInteractiveStepActionToolBarProvider {
    private ToolItem itemPick;
    private ToolItem itemSkip;
    private ToolItem itemEdit;
    private ToolItem itemSquash;
    private ToolItem itemFixup;
    private ToolItem itemReword;
    private ToolItem itemMoveUp;
    private ToolItem itemMoveDown;
    private final ToolItem[] rebaseActionItems = new ToolItem[6];
    private final RebaseInteractiveView view;
    private final ToolBar theToolbar;
    private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());

    final ToolBar getTheToolbar() {
        return this.theToolbar;
    }

    public RebaseInteractiveStepActionToolBarProvider(Composite parent, int style, RebaseInteractiveView view) {
        this.theToolbar = new ToolBar(parent, style);
        this.view = view;
        this.createToolBarItems();
        this.theToolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RebaseInteractiveStepActionToolBarProvider.this.dispose();
            }
        });
    }

    private Image getImage(ImageDescriptor descriptor) {
        return (Image)this.resources.get((DeviceResourceDescriptor)descriptor);
    }

    private void dispose() {
        this.resources.dispose();
    }

    private void createToolBarItems() {
        this.itemPick = new ToolItem(this.theToolbar, 16);
        this.itemPick.setImage(this.getImage(UIIcons.CHERRY_PICK));
        this.itemPick.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.PICK));
        this.itemPick.setText(UIText.RebaseInteractiveStepActionToolBarProvider_PickText);
        this.rebaseActionItems[0] = this.itemPick;
        this.itemSkip = new ToolItem(this.theToolbar, 16);
        this.itemSkip.setImage(this.getImage(UIIcons.REBASE_SKIP));
        this.itemSkip.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.SKIP));
        this.itemSkip.setText(UIText.RebaseInteractiveStepActionToolBarProvider_SkipText);
        this.rebaseActionItems[1] = this.itemSkip;
        this.itemEdit = new ToolItem(this.theToolbar, 16);
        this.itemEdit.setImage(this.getImage(UIIcons.EDITCONFIG));
        this.itemEdit.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.EDIT));
        this.itemEdit.setText(UIText.RebaseInteractiveStepActionToolBarProvider_EditText);
        this.rebaseActionItems[2] = this.itemEdit;
        this.itemSquash = new ToolItem(this.theToolbar, 16);
        this.itemSquash.setImage(this.getImage(UIIcons.SQUASH));
        this.itemSquash.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.SQUASH));
        this.itemSquash.setText(UIText.RebaseInteractiveStepActionToolBarProvider_SquashText);
        this.rebaseActionItems[3] = this.itemSquash;
        this.itemFixup = new ToolItem(this.theToolbar, 16);
        this.itemFixup.setImage(this.getImage(UIIcons.FIXUP));
        this.itemFixup.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.FIXUP));
        this.itemFixup.setText(UIText.RebaseInteractiveStepActionToolBarProvider_FixupText);
        this.rebaseActionItems[4] = this.itemFixup;
        this.itemReword = new ToolItem(this.theToolbar, 16);
        this.itemReword.setImage(this.getImage(UIIcons.REWORD));
        this.itemReword.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.REWORD));
        this.itemReword.setText(UIText.RebaseInteractiveStepActionToolBarProvider_RewordText);
        this.rebaseActionItems[5] = this.itemReword;
        new ToolItem(this.theToolbar, 2);
        this.itemMoveUp = new ToolItem(this.theToolbar, 0);
        this.itemMoveUp.setImage(this.getImage(UIIcons.ELCL16_PREVIOUS));
        this.itemMoveUp.setText(UIText.RebaseInteractiveStepActionToolBarProvider_MoveUpText);
        this.itemMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebaseInteractivePlan.PlanElement selectedEntry = RebaseInteractiveStepActionToolBarProvider.this.getSingleSelectedTodoLine(false);
                if (selectedEntry == null) {
                    return;
                }
                if (selectedEntry.getElementType() != RebaseInteractivePlan.ElementType.TODO) {
                    return;
                }
                RebaseInteractiveStepActionToolBarProvider.this.view.getCurrentPlan().moveTodoEntryUp(selectedEntry);
            }
        });
        this.itemMoveDown = new ToolItem(this.theToolbar, 0);
        this.itemMoveDown.setImage(this.getImage(UIIcons.ELCL16_NEXT));
        this.itemMoveDown.setText(UIText.RebaseInteractiveStepActionToolBarProvider_MoveDownText);
        this.itemMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebaseInteractivePlan.PlanElement selectedEntry = RebaseInteractiveStepActionToolBarProvider.this.getSingleSelectedTodoLine(false);
                if (selectedEntry == null) {
                    return;
                }
                if (selectedEntry.getElementType() != RebaseInteractivePlan.ElementType.TODO) {
                    return;
                }
                RebaseInteractiveStepActionToolBarProvider.this.view.getCurrentPlan().moveTodoEntryDown(selectedEntry);
            }
        });
    }

    protected RebaseInteractivePlan.PlanElement getSingleSelectedTodoLine(boolean firstOfMultipleSelection) {
        List<RebaseInteractivePlan.PlanElement> selected = this.getSelectedRebaseTodoLines();
        switch (selected.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return selected.get(0);
            }
        }
        if (firstOfMultipleSelection) {
            return selected.get(0);
        }
        return null;
    }

    protected List<RebaseInteractivePlan.PlanElement> getSelectedRebaseTodoLines() {
        IStructuredSelection selection = (IStructuredSelection)this.view.planTreeViewer.getSelection();
        ArrayList<RebaseInteractivePlan.PlanElement> planEntries = new ArrayList<RebaseInteractivePlan.PlanElement>(selection.size());
        List candidates = selection.toList();
        for (Object candidate : candidates) {
            if (!(candidate instanceof RebaseInteractivePlan.PlanElement)) continue;
            planEntries.add((RebaseInteractivePlan.PlanElement)candidate);
        }
        return planEntries;
    }

    void mapActionItemsToSelection(ISelection selection) {
        this.setMoveItemsEnabled(false);
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object obj = structured.getFirstElement();
            if (!(obj instanceof RebaseInteractivePlan.PlanElement)) {
                return;
            }
            RebaseInteractivePlan.PlanElement firstSelectedEntry = (RebaseInteractivePlan.PlanElement)obj;
            if (structured.size() > 1) {
                this.setMoveItemsEnabled(false);
                RebaseInteractivePlan.ElementAction type = firstSelectedEntry.getPlanElementAction();
                for (Object selectedObj : structured) {
                    RebaseInteractivePlan.PlanElement entry;
                    if (!(selectedObj instanceof RebaseInteractivePlan.PlanElement) || type == (entry = (RebaseInteractivePlan.PlanElement)selectedObj).getPlanElementAction()) continue;
                    this.unselectAllActionItemsExecpt(null);
                    break;
                }
                return;
            }
            this.setMoveItemsEnabled(true);
            this.unselectAllActionItemsExecpt(this.getItemFor(firstSelectedEntry.getPlanElementAction()));
        }
    }

    private ToolItem getItemFor(RebaseInteractivePlan.ElementAction type) {
        switch (type) {
            case EDIT: {
                return this.itemEdit;
            }
            case FIXUP: {
                return this.itemFixup;
            }
            case PICK: {
                return this.itemPick;
            }
            case REWORD: {
                return this.itemReword;
            }
            case SQUASH: {
                return this.itemSquash;
            }
            case SKIP: {
                return this.itemSkip;
            }
        }
        return null;
    }

    private void unselectAllActionItemsExecpt(ToolItem item) {
        int i = 0;
        while (i < this.rebaseActionItems.length) {
            ToolItem currItem = this.rebaseActionItems[i];
            if (currItem != null) {
                if (currItem == item) {
                    currItem.setSelection(true);
                } else {
                    currItem.setSelection(false);
                }
            }
            ++i;
        }
    }

    private void setMoveItemsEnabled(boolean enabled) {
        this.itemMoveDown.setEnabled(enabled);
        this.itemMoveUp.setEnabled(enabled);
    }

    private class ActionSelectionListener
    implements SelectionListener {
        private final RebaseInteractivePlan.ElementAction type;

        ActionSelectionListener(RebaseInteractivePlan.ElementAction action) {
            this.type = action;
        }

        public void widgetSelected(SelectionEvent e) {
            List<RebaseInteractivePlan.PlanElement> selected = RebaseInteractiveStepActionToolBarProvider.this.getSelectedRebaseTodoLines();
            if (selected == null || selected.isEmpty()) {
                return;
            }
            for (RebaseInteractivePlan.PlanElement element : selected) {
                element.setPlanElementAction(this.type);
            }
            RebaseInteractiveStepActionToolBarProvider.this.mapActionItemsToSelection(((RebaseInteractiveStepActionToolBarProvider)RebaseInteractiveStepActionToolBarProvider.this).view.planTreeViewer.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

