/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractRebaseHistoryCommandHandler
extends AbstractHistoryCommandHandler {
    public boolean isEnabled() {
        Repository repository = this.getRepository(this.getPage());
        if (repository == null) {
            return false;
        }
        return repository.getRepositoryState().equals((Object)RepositoryState.SAFE);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PlotCommit commit = (PlotCommit)this.getSelection(this.getPage()).getFirstElement();
        Repository repository = this.getRepository(event);
        if (repository == null) {
            return null;
        }
        String currentBranch = this.getCurrentBranch(repository);
        final Ref ref = this.getRef(commit, repository, currentBranch);
        String jobname = NLS.bind((String)UIText.RebaseCurrentRefCommand_RebasingCurrentJobName, (Object)currentBranch, (Object)ref.getName());
        AbstractRebaseCommandHandler rebaseCurrentRef = new AbstractRebaseCommandHandler(jobname, UIText.RebaseCurrentRefCommand_RebaseCanceledMessage){

            protected RebaseOperation createRebaseOperation(Repository repository2) throws ExecutionException {
                return AbstractRebaseHistoryCommandHandler.this.createRebaseOperation(repository2, ref);
            }
        };
        rebaseCurrentRef.execute(repository);
        return null;
    }

    protected abstract RebaseOperation createRebaseOperation(Repository var1, Ref var2);

    protected Ref getRef(PlotCommit commit, Repository repository, String currentBranch) {
        int count = commit.getRefCount();
        if (count == 0) {
            return new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, commit.getName(), (ObjectId)commit);
        }
        if (count == 1) {
            return commit.getRef(0);
        }
        BranchConfig branchConfig = new BranchConfig((Config)repository.getConfig(), currentBranch);
        String trackingBranch = branchConfig.getTrackingBranch();
        Ref remoteRef = null;
        int i = 0;
        while (i < count) {
            Ref ref = commit.getRef(i);
            if (trackingBranch != null && trackingBranch.equals(ref.getName())) {
                return ref;
            }
            if (ref.getName().startsWith("refs/remotes/")) {
                remoteRef = ref;
            }
            ++i;
        }
        if (remoteRef != null) {
            return remoteRef;
        }
        return commit.getRef(0);
    }

    protected String getCurrentBranch(Repository repository) throws ExecutionException {
        try {
            return repository.getBranch();
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.RebaseCurrentRefCommand_ErrorGettingCurrentBranchMessage, (Throwable)e);
        }
    }
}

