/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CommitSelectDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithPreviousActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryActionHandler.PreviousCommit previous;
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length == 1 && (previous = this.getPreviousRevision(event, resources[0])) != null) {
            IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
            try {
                CompareUtils.compare(resources, repository, "HEAD", previous.commit.getName(), true, workBenchPage);
            }
            catch (IOException e) {
                Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IResource[] selectedResources = this.getSelectedResources();
        return super.isEnabled() && selectedResources.length == 1 && this.selectionMapsToSingleRepository();
    }

    private RepositoryActionHandler.PreviousCommit getPreviousRevision(final ExecutionEvent event, IResource resource) {
        List<RepositoryActionHandler.PreviousCommit> previousList;
        try {
            previousList = this.findPreviousCommits();
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        final AtomicReference<RepositoryActionHandler.PreviousCommit> previous = new AtomicReference<RepositoryActionHandler.PreviousCommit>();
        if (previousList.size() == 0) {
            this.showNotFoundDialog(event, resource);
        } else if (previousList.size() == 1) {
            previous.set(previousList.get(0));
        } else {
            final ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
            for (RepositoryActionHandler.PreviousCommit pc : previousList) {
                commits.add(pc.commit);
            }
            HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay().syncExec(new Runnable(){

                public void run() {
                    CommitSelectDialog dlg = new CommitSelectDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), commits);
                    if (dlg.open() == 0) {
                        for (RepositoryActionHandler.PreviousCommit pc : previousList) {
                            if (!pc.commit.equals((AnyObjectId)dlg.getSelectedCommit())) continue;
                            previous.set(pc);
                            break;
                        }
                    }
                }
            });
        }
        return (RepositoryActionHandler.PreviousCommit)previous.get();
    }

    private void showNotFoundDialog(ExecutionEvent event, IResource resource) {
        final Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        final String message = MessageFormat.format(UIText.CompareWithPreviousActionHandler_MessageRevisionNotFound, resource.getName());
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openWarning((Shell)shell, (String)UIText.CompareWithPreviousActionHandler_TitleRevisionNotFound, (String)message);
            }
        });
    }
}

