/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.FileUtil;
import org.eclipse.jgit.util.FileUtils;

public class FS_Win32_Java7
extends FS_Win32 {
    private volatile Boolean supportSymlinks;

    FS_Win32_Java7(FS src) {
        super(src);
    }

    FS_Win32_Java7() {
    }

    public FS newInstance() {
        return new FS_Win32_Java7((FS)this);
    }

    public boolean supportsSymlinks() {
        if (this.supportSymlinks == null) {
            this.detectSymlinkSupport();
        }
        return Boolean.TRUE.equals(this.supportSymlinks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectSymlinkSupport() {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempsymlinktarget", "");
            File linkName = new File(tempFile.getParentFile(), "tempsymlink");
            FileUtil.createSymLink(linkName, tempFile.getPath());
            this.supportSymlinks = Boolean.TRUE;
            linkName.delete();
        }
        catch (IOException e) {
            this.supportSymlinks = Boolean.FALSE;
        }
        finally {
            if (tempFile != null) {
                try {
                    FileUtils.delete((File)tempFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public boolean isSymLink(File path) throws IOException {
        return FileUtil.isSymlink(path);
    }

    public long lastModified(File path) throws IOException {
        return FileUtil.lastModified(path);
    }

    public void setLastModified(File path, long time) throws IOException {
        FileUtil.setLastModified(path, time);
    }

    public void delete(File path) throws IOException {
        FileUtil.delete(path);
    }

    public long length(File f) throws IOException {
        return FileUtil.getLength(f);
    }

    public boolean exists(File path) {
        return FileUtil.exists(path);
    }

    public boolean isDirectory(File path) {
        return FileUtil.isDirectory(path);
    }

    public boolean isFile(File path) {
        return FileUtil.isFile(path);
    }

    public boolean isHidden(File path) throws IOException {
        return FileUtil.isHidden(path);
    }

    public void setHidden(File path, boolean hidden) throws IOException {
        FileUtil.setHidden(path, hidden);
    }

    public String readSymLink(File path) throws IOException {
        return FileUtil.readSymlink(path);
    }

    public void createSymLink(File path, String target) throws IOException {
        FileUtil.createSymLink(path, target);
    }

    public FS.Attributes getAttributes(File path) {
        return FileUtil.getFileAttributesBasic((FS)this, path);
    }
}

