/*******************************************************************************
 * Copyright (c) 2012 cnfree.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  cnfree  - initial API and implementation
 *******************************************************************************/

package org.sf.feeling.decompiler;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;

public class Startup implements IStartup
{

	// External plug-in IDs
	public static final String JDT_EDITOR_ID = "org.eclipse.jdt.ui.ClassFileEditor"; //$NON-NLS-1$

	public void earlyStartup( )
	{
		// Setup ".class" file association
		Display.getDefault( )
				.syncExec( new SetupClassFileAssociationRunnable( ) );
	}

	private static class SetupClassFileAssociationRunnable implements Runnable
	{

		public void run( )
		{
			IPreferenceStore prefs = JavaDecompilerPlugin.getDefault( )
					.getPreferenceStore( );
			if ( prefs.getBoolean( JavaDecompilerPlugin.DEFAULT_EDITOR ) )
			{
				EditorRegistry registry = (EditorRegistry) PlatformUI.getWorkbench( )
						.getEditorRegistry( );

				IFileEditorMapping[] mappings = registry.getFileEditorMappings( );

				// Search Class file editor mappings
				IFileEditorMapping classNoSource = null;
				IFileEditorMapping classPlain = null;
				for ( int i = 0; i < mappings.length; i++ )
				{
					IFileEditorMapping mapping = mappings[i];
					if ( mapping.getExtension( )
							.equals( "class without source" ) ) //$NON-NLS-1$
					{
						classNoSource = mapping;
					}
					else if ( mapping.getExtension( ).equals( "class" ) ) //$NON-NLS-1$
					{
						classPlain = mapping;
					}
				}

				IFileEditorMapping[] classMappings = new IFileEditorMapping[]{
						classNoSource, classPlain
				};
			
				for ( int i = 0; i < classMappings.length; i++ )
				{
					IFileEditorMapping mapping = classMappings[i];
					for ( int j = 0; j < mapping.getEditors( ).length; j++ )
					{
						IEditorDescriptor editor = mapping.getEditors( )[j];
						if ( editor.getId( )
								.equals( JavaDecompilerPlugin.EDITOR_ID ) )
						{
							( (FileEditorMapping) mapping ).setDefaultEditor( (EditorDescriptor) editor );
						}
					}
				}
				
				registry.setFileEditorMappings( (FileEditorMapping[]) mappings );
				registry.saveAssociations( );
			}
		}
	}

}
