/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.codemanipulation.SortMembersOperation;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class SortMemberUtil {
    public static String getContent(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            byte[] tmp = new byte[4096];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            while ((r = ((InputStream)is).read(tmp)) != -1) {
                out.write(tmp, 0, r);
            }
            byte[] bytes = out.toByteArray();
            ((InputStream)is).close();
            out.close();
            String content = new String(bytes);
            return content.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sortMember(String packageName, String className, String code) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(".decompiler" + System.currentTimeMillis());
        try {
            project.create(null);
            project.open(null);
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        if (!project.isOpen()) {
            return code;
        }
        className = className.replaceAll("(?i).class", String.valueOf(System.currentTimeMillis()) + ".java");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
            LibraryLocation[] locations = JavaRuntime.getLibraryLocations((IVMInstall)vmInstall);
            int i = 0;
            while (i < locations.length) {
                LibraryLocation element = locations[i];
                entries.add(JavaCore.newLibraryEntry((IPath)element.getSystemLibraryPath(), null, null));
                ++i;
            }
            javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), null);
            IFolder sourceFolder = project.getFolder("src");
            sourceFolder.create(false, true, null);
            IPackageFragmentRoot codeGenFolder = javaProject.getPackageFragmentRoot((IResource)sourceFolder);
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
            System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
            newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)codeGenFolder.getPath());
            javaProject.setRawClasspath(newEntries, null);
            IPackageFragment fragment = javaProject.getPackageFragmentRoot((IResource)sourceFolder).createPackageFragment(packageName, false, null);
            File locationFile = new File(sourceFolder.getFolder(packageName.replace('.', '/')).getFile(className).getLocation().toString());
            if (!locationFile.getParentFile().exists()) {
                locationFile.getParentFile().mkdirs();
            }
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(locationFile, false)));
            writer.println(code);
            writer.close();
            project.refreshLocal(2, null);
            ICompilationUnit iCompilationUnit = fragment.getCompilationUnit(className);
            iCompilationUnit.becomeWorkingCopy(null);
            new SortMembersOperation(iCompilationUnit, null, true).run(null);
            iCompilationUnit.commitWorkingCopy(true, null);
            iCompilationUnit.save(null, true);
            String content = SortMemberUtil.getContent(locationFile);
            iCompilationUnit.delete(true, null);
            if (content != null) {
                code = content;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (project != null) {
                project.delete(true, true, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }
}

