/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.fieldeditors.StringChoiceFieldEditor;
import org.sf.feeling.decompiler.i18n.Messages;
import org.sf.feeling.decompiler.util.UIUtil;

public class JavaDecompilerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private CheckFieldEditor optionLncEditor;
    private CheckFieldEditor alignEditor;
    private CheckFieldEditor eclipseFormatter;
    private CheckFieldEditor eclipseSorter;
    private Group basicGroup;
    private Group formatGroup;
    private Group debugGroup;

    public JavaDecompilerPreferencePage() {
        super(1);
        this.setPreferenceStore(JavaDecompilerPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected void createFieldEditors() {
        StringChoiceFieldEditor defaultDecompiler = new StringChoiceFieldEditor("net.sf.feeling.decompiler.type", Messages.getString("JavaDecompilerPreferencePage.Label.DefaultClassDecompiler"), this.getFieldEditorParent()){

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns);
                GridData gd = (GridData)this.getControl().getLayoutData();
                gd.widthHint = 200;
                gd.grabExcessHorizontalSpace = false;
                gd.horizontalAlignment = 1;
                this.getControl().setLayoutData((Object)gd);
            }
        };
        if (UIUtil.isWin32()) {
            defaultDecompiler.addItem("Jad", "Jad");
        }
        defaultDecompiler.addItem("JD-Core", "JD-Core");
        this.addField(defaultDecompiler);
        this.basicGroup = new Group(this.getFieldEditorParent(), 0);
        this.basicGroup.setText(Messages.getString("JavaDecompilerPreferencePage.Label.DecompilerSettings"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = defaultDecompiler.getNumberOfControls();
        this.basicGroup.setLayoutData((Object)gd);
        BooleanFieldEditor reusebuf = new BooleanFieldEditor("net.sf.feeling.decompiler.reusebuff", Messages.getString("JavaDecompilerPreferencePage.Label.ReuseCodeBuffer"), (Composite)this.basicGroup);
        this.addField((FieldEditor)reusebuf);
        BooleanFieldEditor alwaysUse = new BooleanFieldEditor("net.sf.feeling.decompiler.alwaysuse", Messages.getString("JavaDecompilerPreferencePage.Label.IgnoreExistSource"), (Composite)this.basicGroup);
        this.addField((FieldEditor)alwaysUse);
        BooleanFieldEditor showReport = new BooleanFieldEditor("jd.ide.eclipse.prefs.DisplayMetadata", Messages.getString("JavaDecompilerPreferencePage.Label.ShowDecompilerReport"), (Composite)this.basicGroup);
        this.addField((FieldEditor)showReport);
        GridLayout layout = (GridLayout)this.basicGroup.getLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.basicGroup.layout();
        this.formatGroup = new Group(this.getFieldEditorParent(), 0);
        this.formatGroup.setText(Messages.getString("JavaDecompilerPreferencePage.Label.FormatSettings"));
        gd = new GridData(768);
        gd.horizontalSpan = defaultDecompiler.getNumberOfControls();
        this.formatGroup.setLayoutData((Object)gd);
        this.eclipseFormatter = new CheckFieldEditor("net.sf.feeling.decompiler.use_eclipse_formatter", Messages.getString("JavaDecompilerPreferencePage.Label.UseEclipseFormat"), (Composite)this.formatGroup);
        this.addField((FieldEditor)this.eclipseFormatter);
        this.eclipseSorter = new CheckFieldEditor("net.sf.feeling.decompiler.use_eclipse_sorter", Messages.getString("JavaDecompilerPreferencePage.Lable.UseEclipseSorter"), (Composite)this.formatGroup);
        this.addField((FieldEditor)this.eclipseSorter);
        layout = (GridLayout)this.formatGroup.getLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.formatGroup.layout();
        this.debugGroup = new Group(this.getFieldEditorParent(), 0);
        this.debugGroup.setText(Messages.getString("JavaDecompilerPreferencePage.Label.DebugSettings"));
        gd = new GridData(768);
        gd.horizontalSpan = defaultDecompiler.getNumberOfControls();
        this.debugGroup.setLayoutData((Object)gd);
        this.optionLncEditor = new CheckFieldEditor("jd.ide.eclipse.prefs.DisplayLineNumbers", Messages.getString("JavaDecompilerPreferencePage.Label.OutputLineNumber"), (Composite)this.debugGroup);
        this.addField((FieldEditor)this.optionLncEditor);
        this.alignEditor = new CheckFieldEditor("jd.ide.eclipse.prefs.Align", Messages.getString("JavaDecompilerPreferencePage.Label.AlignCode"), (Composite)this.debugGroup);
        this.addField((FieldEditor)this.alignEditor);
        layout = (GridLayout)this.debugGroup.getLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.debugGroup.layout();
        Group startupGroup = new Group(this.getFieldEditorParent(), 0);
        startupGroup.setText(Messages.getString("JavaDecompilerPreferencePage.Label.Startup"));
        gd = new GridData(768);
        gd.horizontalSpan = defaultDecompiler.getNumberOfControls();
        startupGroup.setLayoutData((Object)gd);
        CheckFieldEditor defaultViewerEditor = new CheckFieldEditor("net.sf.feeling.decompiler.default_editor", Messages.getString("JavaDecompilerPreferencePage.Label.DefaultEditor"), (Composite)startupGroup);
        this.addField((FieldEditor)defaultViewerEditor);
        layout = (GridLayout)startupGroup.getLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        startupGroup.layout();
        this.getFieldEditorParent().layout();
    }

    public void init(IWorkbench arg0) {
    }

    protected void initialize() {
        super.initialize();
        boolean enabled = this.getPreferenceStore().getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        this.alignEditor.setEnabled(enabled, (Composite)this.debugGroup);
    }

    protected void performDefaults() {
        super.performDefaults();
        boolean enabled = Boolean.valueOf(this.optionLncEditor.getBooleanValue()).equals(Boolean.TRUE);
        this.alignEditor.setEnabled(enabled, (Composite)this.debugGroup);
    }

    public void propertyChange(PropertyChangeEvent event) {
        boolean enabled;
        if (event.getSource() == this.optionLncEditor) {
            enabled = event.getNewValue().equals(Boolean.TRUE);
            this.alignEditor.setEnabled(enabled, (Composite)this.debugGroup);
            if (enabled) {
                this.eclipseFormatter.getChangeControl((Composite)this.formatGroup).setSelection(false);
                this.eclipseSorter.getChangeControl((Composite)this.formatGroup).setSelection(false);
                this.eclipseFormatter.handleSelection((Composite)this.formatGroup);
                this.eclipseSorter.handleSelection((Composite)this.formatGroup);
            }
            if (!enabled) {
                this.alignEditor.getChangeControl((Composite)this.debugGroup).setSelection(false);
                this.alignEditor.handleSelection((Composite)this.debugGroup);
            }
        }
        if (event.getSource() == this.alignEditor && (enabled = event.getNewValue().equals(Boolean.TRUE))) {
            this.eclipseFormatter.getChangeControl((Composite)this.formatGroup).setSelection(false);
            this.eclipseSorter.getChangeControl((Composite)this.formatGroup).setSelection(false);
            this.eclipseFormatter.handleSelection((Composite)this.formatGroup);
            this.eclipseSorter.handleSelection((Composite)this.formatGroup);
        }
        if ((event.getSource() == this.eclipseFormatter || event.getSource() == this.eclipseSorter) && (enabled = event.getNewValue().equals(Boolean.TRUE))) {
            this.alignEditor.getChangeControl((Composite)this.debugGroup).setSelection(false);
            this.optionLncEditor.getChangeControl((Composite)this.debugGroup).setSelection(false);
            this.alignEditor.setEnabled(!enabled, (Composite)this.debugGroup);
            this.alignEditor.handleSelection((Composite)this.debugGroup);
            this.optionLncEditor.handleSelection((Composite)this.debugGroup);
        }
        super.propertyChange(event);
    }

    class CheckFieldEditor
    extends BooleanFieldEditor {
        public CheckFieldEditor(String name, String label, Composite parent) {
            super(name, label, parent);
        }

        protected void fireStateChanged(String property, boolean oldValue, boolean newValue) {
            this.fireValueChanged(property, oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }

        public void handleSelection(Composite parent) {
            boolean isSelected = this.getChangeControl(parent).getSelection();
            this.valueChanged(false, isSelected);
        }

        protected void valueChanged(boolean oldValue, boolean newValue) {
            this.setPresentsDefaultValue(false);
            this.fireStateChanged("field_editor_value", oldValue, newValue);
        }

        public Button getChangeControl(Composite parent) {
            return super.getChangeControl(parent);
        }
    }
}

