/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;

public abstract class DecompilerSourceMapper
extends SourceMapper {
    protected static Map originalSourceMapper = new HashMap();
    protected boolean isAttachedSource;

    public DecompilerSourceMapper(IPath sourcePath, String rootPath, Map options) {
        super(sourcePath, rootPath, options);
    }

    public char[] findSource(IType type) {
        if (!type.isBinary()) {
            return null;
        }
        BinaryType parent = (BinaryType)type.getDeclaringType();
        BinaryType declType = (BinaryType)type;
        while (parent != null) {
            declType = parent;
            parent = (BinaryType)declType.getDeclaringType();
        }
        IBinaryType info = null;
        try {
            info = (IBinaryType)declType.getElementInfo();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (info == null) {
            return null;
        }
        return this.findSource(type, info);
    }

    public void mapSource(IType type, char[] contents, boolean force) {
        if (force) {
            this.sourceRanges.remove(type);
        }
        super.mapSource(type, contents, null);
    }

    public boolean isAttachedSource() {
        return this.isAttachedSource;
    }

    protected String formatSource(String source) {
        String result = null;
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean useFormatter = prefs.getBoolean("net.sf.feeling.decompiler.use_eclipse_formatter");
        if (source != null && useFormatter) {
            CodeFormatter formatter = ToolFactory.createCodeFormatter(null);
            TextEdit textEdit = formatter.format(8, source, 0, source.length(), 0, null);
            if (textEdit != null) {
                Document document = new Document(source);
                try {
                    textEdit.apply((IDocument)document);
                }
                catch (BadLocationException e) {
                    JavaDecompilerPlugin.log(2, e, "Unable to apply text formatting.");
                }
                result = document.get();
            }
            if (result == null) {
                JavaDecompilerPlugin.log(2, null, "Could not format code, it will remain unformatted.");
                result = source;
            }
        } else {
            result = source;
        }
        return result;
    }

    protected String getArchivePath(IPackageFragmentRoot root) {
        String archivePath = null;
        try {
            IResource resource = root.getUnderlyingResource();
            archivePath = resource != null ? resource.getLocation().toOSString() : root.getPath().toOSString();
        }
        catch (JavaModelException e) {
            throw new RuntimeException("Unexpected Java model exception: " + e.toString());
        }
        return archivePath;
    }

    protected IJavaElement findElement(IJavaElement elt, int position) {
        SourceRange range = this.getSourceRange(elt);
        if (range == null || position < range.getOffset() || range.getOffset() + range.getLength() - 1 < position) {
            return null;
        }
        if (elt instanceof IParent) {
            try {
                IJavaElement[] children = ((IParent)elt).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement match = this.findElement(children[i], position);
                    if (match != null) {
                        return match;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return elt;
    }
}

