/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.sf.feeling.decompiler.editor.JavaDecompilerBufferManager;
import org.sf.feeling.decompiler.jad.JadLoader;

public class JavaDecompilerPlugin
extends AbstractUIPlugin
implements IPropertyChangeListener {
    public static final String EDITOR_ID = "net.sf.feeling.decompiler.ClassFileEditor";
    public static final String PLUGIN_ID = "net.sf.feeling.decompiler";
    public static final String TEMP_DIR = "net.sf.feeling.decompiler.tempd";
    public static final String CMD = "net.sf.feeling.decompiler.cmd";
    public static final String REUSE_BUFFER = "net.sf.feeling.decompiler.reusebuff";
    public static final String IGNORE_EXISTING = "net.sf.feeling.decompiler.alwaysuse";
    public static final String USE_ECLIPSE_FORMATTER = "net.sf.feeling.decompiler.use_eclipse_formatter";
    public static final String USE_ECLIPSE_SORTER = "net.sf.feeling.decompiler.use_eclipse_sorter";
    public static final String DECOMPILER_TYPE = "net.sf.feeling.decompiler.type";
    public static final String PREF_DISPLAY_LINE_NUMBERS = "jd.ide.eclipse.prefs.DisplayLineNumbers";
    public static final String PREF_DISPLAY_METADATA = "jd.ide.eclipse.prefs.DisplayMetadata";
    public static final String ALIGN = "jd.ide.eclipse.prefs.Align";
    public static final String DEFAULT_EDITOR = "net.sf.feeling.decompiler.default_editor";
    private static JavaDecompilerPlugin plugin;

    public static JavaDecompilerPlugin getDefault() {
        return plugin;
    }

    public static void logError(Throwable t, String message) {
        JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, t));
    }

    public static void log(int severity, Throwable t, String message) {
        JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(severity, PLUGIN_ID, 0, message, t));
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        URL base = JavaDecompilerPlugin.getDefault().getBundle().getEntry("/");
        URL url = null;
        try {
            url = new URL(base, path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ImageDescriptor actionIcon = null;
        if (url != null) {
            actionIcon = ImageDescriptor.createFromURL((URL)url);
        }
        return actionIcon;
    }

    public JavaDecompilerPlugin() {
        plugin = this;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        String jad = JadLoader.loadJad();
        if (jad != null) {
            store.setDefault(CMD, jad);
        }
        store.setDefault(TEMP_DIR, String.valueOf(System.getProperty("user.home")) + File.separator + ".net.sf.feeling.decompiler");
        store.setDefault(REUSE_BUFFER, true);
        store.setDefault(IGNORE_EXISTING, false);
        store.setDefault(USE_ECLIPSE_FORMATTER, true);
        store.setDefault(USE_ECLIPSE_SORTER, false);
        store.setDefault(PREF_DISPLAY_METADATA, false);
        store.setDefault(DECOMPILER_TYPE, "JD-Core");
        store.setDefault(DEFAULT_EDITOR, true);
        store.setDefault("-t", 4);
        store.setDefault("-radix", 10);
        store.setDefault("-lradix", 10);
        store.setDefault("-l", 0);
        store.setDefault("-pi", 0);
        store.setDefault("-pv", 0);
        store.setDefault("-ff", true);
        store.setDefault("-noctor", true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IGNORE_EXISTING) && event.getNewValue().equals(Boolean.FALSE)) {
            JavaDecompilerBufferManager.closeDecompilerBuffers(false);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        plugin = null;
    }
}

