/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.transformer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import net.sf.eclipsecs.core.transformer.CheckstyleSetting;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckstyleFileWriter {
    private final CheckstyleSetting mCheckstyleSetting;

    public CheckstyleFileWriter(CheckstyleSetting setting, String file) {
        block5: {
            this.mCheckstyleSetting = setting;
            FileOutputStream fw = null;
            try {
                try {
                    fw = new FileOutputStream(file);
                    this.writeXMLFile(fw);
                }
                catch (IOException e) {
                    CheckstyleLog.log(e);
                    IOUtils.closeQuietly((OutputStream)fw);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fw);
        }
    }

    private void writeXMLFile(OutputStream bw) throws IOException {
        bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes("UTF-8"));
        bw.write("<module name=\"Checker\">\n".getBytes("UTF-8"));
        bw.write("<property name=\"severity\" value=\"warning\"/>\n".getBytes("UTF-8"));
        this.writeModules(this.mCheckstyleSetting.getmCheckerModules(), bw);
        bw.write("<module name=\"TreeWalker\">\n".getBytes("UTF-8"));
        this.writeModules(this.mCheckstyleSetting.getmTreeWalkerModules(), bw);
        bw.write("</module>\n".getBytes("UTF-8"));
        bw.write("</module>\n".getBytes("UTF-8"));
    }

    private void writeModules(HashMap<String, HashMap<String, String>> modules, OutputStream bw) throws IOException {
        for (String module : modules.keySet()) {
            if (modules.get(module) == null) {
                bw.write(("<module name=\"" + module + "\"/>\n").getBytes("UTF-8"));
                continue;
            }
            bw.write(("<module name=\"" + module + "\">\n").getBytes("UTF-8"));
            this.writeProperty(modules.get(module), bw);
            bw.write("</module>\n".getBytes("UTF-8"));
        }
    }

    private void writeProperty(HashMap<String, String> properties, OutputStream bw) throws IOException {
        for (String prop : properties.keySet()) {
            bw.write(("<property name=\"" + prop + "\" value=\"" + properties.get(prop) + "\"/>\n").getBytes("UTF-8"));
        }
    }
}

