/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCheckConfigurationWorkingSet
implements ICheckConfigurationWorkingSet {
    private final IProjectConfiguration mProjectConfig;
    private final List<CheckConfigurationWorkingCopy> mWorkingCopies;
    private final List<CheckConfigurationWorkingCopy> mDeletedConfigurations;

    LocalCheckConfigurationWorkingSet(IProjectConfiguration projectConfig, List<ICheckConfiguration> checkConfigs) {
        this.mProjectConfig = projectConfig;
        this.mWorkingCopies = new ArrayList<CheckConfigurationWorkingCopy>();
        this.mDeletedConfigurations = new ArrayList<CheckConfigurationWorkingCopy>();
        for (ICheckConfiguration cfg : checkConfigs) {
            CheckConfigurationWorkingCopy workingCopy = new CheckConfigurationWorkingCopy(cfg, this);
            this.mWorkingCopies.add(workingCopy);
        }
    }

    @Override
    public CheckConfigurationWorkingCopy newWorkingCopy(ICheckConfiguration checkConfig) {
        return new CheckConfigurationWorkingCopy(checkConfig, this);
    }

    @Override
    public CheckConfigurationWorkingCopy newWorkingCopy(IConfigurationType configType) {
        return new CheckConfigurationWorkingCopy(configType, this, false);
    }

    @Override
    public CheckConfigurationWorkingCopy[] getWorkingCopies() {
        return this.mWorkingCopies.toArray(new CheckConfigurationWorkingCopy[this.mWorkingCopies.size()]);
    }

    @Override
    public void addCheckConfiguration(CheckConfigurationWorkingCopy checkConfig) {
        this.mWorkingCopies.add(checkConfig);
    }

    @Override
    public boolean removeCheckConfiguration(CheckConfigurationWorkingCopy checkConfig) {
        boolean inUse = this.mProjectConfig.isConfigInUse(checkConfig);
        if (!inUse) {
            this.mWorkingCopies.remove(checkConfig);
            this.mDeletedConfigurations.add(checkConfig);
        }
        return !inUse;
    }

    @Override
    public void store() throws CheckstylePluginException {
        this.notifyDeletedCheckConfigs();
    }

    @Override
    public boolean isDirty() {
        if (this.mDeletedConfigurations.size() > 0) {
            return true;
        }
        boolean dirty = false;
        for (CheckConfigurationWorkingCopy workingCopy : this.mWorkingCopies) {
            dirty = workingCopy.isDirty();
            if (dirty) break;
        }
        return dirty;
    }

    @Override
    public boolean isNameCollision(CheckConfigurationWorkingCopy configuration) {
        boolean result = false;
        for (CheckConfigurationWorkingCopy tmp : this.mWorkingCopies) {
            if (tmp == configuration || !tmp.getName().equals(configuration.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    public IProject getProject() {
        return this.mProjectConfig.getProject();
    }

    @Override
    public Collection<IProject> getAffectedProjects() {
        HashSet<IProject> projects = new HashSet<IProject>();
        CheckConfigurationWorkingCopy[] workingCopies = this.getWorkingCopies();
        int i = 0;
        while (i < workingCopies.length) {
            if (workingCopies[i].hasConfigurationChanged() && this.mProjectConfig.isConfigInUse(workingCopies[i])) {
                projects.add(this.mProjectConfig.getProject());
                break;
            }
            ++i;
        }
        return projects;
    }

    private void notifyDeletedCheckConfigs() throws CheckstylePluginException {
        for (ICheckConfiguration iCheckConfiguration : this.mDeletedConfigurations) {
            iCheckConfiguration.getType().notifyCheckConfigRemoved(iCheckConfiguration);
        }
    }
}

