/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.builder.CheckstyleBuilder;
import net.sf.eclipsecs.core.jobs.AuditorJob;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunCheckstyleOnFilesJob
extends WorkspaceJob
implements ISchedulingRule {
    private List<IFile> mFilesToCheck;

    public RunCheckstyleOnFilesJob(List<IFile> files) {
        super(Messages.RunCheckstyleOnFilesJob_title);
        this.mFilesToCheck = new ArrayList<IFile>(files);
        this.setRule(this);
    }

    public RunCheckstyleOnFilesJob(IFile file) {
        super(Messages.RunCheckstyleOnFilesJob_title);
        this.mFilesToCheck = new ArrayList<IFile>();
        this.mFilesToCheck.add(file);
        this.setRule(this);
    }

    public boolean contains(ISchedulingRule arg0) {
        return arg0 instanceof RunCheckstyleOnFilesJob;
    }

    public boolean isConflicting(ISchedulingRule arg0) {
        return arg0 instanceof RunCheckstyleOnFilesJob || arg0 instanceof AuditorJob;
    }

    public final IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            Map<IProject, List<IFile>> projectFilesMap = this.getFilesSortedToProject(this.mFilesToCheck);
            for (Map.Entry<IProject, List<IFile>> entry : projectFilesMap.entrySet()) {
                IProject project = entry.getKey();
                List<IFile> files = entry.getValue();
                IProjectConfiguration checkConfig = ProjectConfigurationFactory.getConfiguration(project);
                this.filter(files, checkConfig);
                CheckstyleBuilder builder = new CheckstyleBuilder();
                builder.handleBuildSelection(files, checkConfig, monitor, project, 10);
            }
        }
        catch (CheckstylePluginException e) {
            Status status = new Status(4, "net.sf.eclipsecs.core", 4, e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        return Status.OK_STATUS;
    }

    private Map<IProject, List<IFile>> getFilesSortedToProject(List<IFile> filesToCheck) {
        HashMap<IProject, List<IFile>> projectFilesMap = new HashMap<IProject, List<IFile>>();
        int i = 0;
        int size = filesToCheck.size();
        while (i < size) {
            IFile file = filesToCheck.get(i);
            IProject project = file.getProject();
            ArrayList<IFile> projectFiles = (ArrayList<IFile>)projectFilesMap.get(project);
            if (projectFiles == null) {
                projectFiles = new ArrayList<IFile>();
                projectFilesMap.put(project, projectFiles);
            }
            projectFiles.add(file);
            ++i;
        }
        return projectFilesMap;
    }

    private void filter(List<IFile> files, IProjectConfiguration projectConfig) {
        List<IFilter> filters = projectConfig.getFilters();
        for (IFilter filter : filters) {
            Iterator<IFile> filesIt = files.iterator();
            while (filesIt.hasNext()) {
                IFile file = filesIt.next();
                if (!filter.isEnabled() || filter.accept(file)) continue;
                filesIt.remove();
            }
        }
    }
}

