/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.savefilter;

import java.util.List;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.config.savefilter.ISaveFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeWalkerModuleSaveFilter
implements ISaveFilter {
    @Override
    public void postProcessConfiguredModules(List<Module> configuredModules) {
        boolean containsTreeWalkerModule = false;
        boolean containsTreeWalkerDependantModule = false;
        Module configuredTreeWalker = null;
        int i = 0;
        int size = configuredModules.size();
        while (i < size) {
            Module module = configuredModules.get(i);
            if ("TreeWalker".equals(module.getMetaData().getInternalName())) {
                containsTreeWalkerModule = true;
                configuredTreeWalker = module;
            }
            if ("TreeWalker".equals(module.getMetaData().getParentModule())) {
                containsTreeWalkerDependantModule = true;
            }
            if (containsTreeWalkerModule && containsTreeWalkerDependantModule) break;
            ++i;
        }
        if (!containsTreeWalkerModule && containsTreeWalkerDependantModule) {
            Module treeWalker = new Module(MetadataFactory.getRuleMetadata("TreeWalker"), false);
            configuredModules.add(0, treeWalker);
        } else if (containsTreeWalkerModule && !containsTreeWalkerDependantModule) {
            configuredModules.remove(configuredTreeWalker);
        }
    }
}

