/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.savefilter;

import java.util.List;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.config.savefilter.ISaveFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileContentsHolderSaveFilter
implements ISaveFilter {
    @Override
    public void postProcessConfiguredModules(List<Module> configuredModules) {
        boolean containsFileContentsHolderModule = false;
        boolean needsFileContentsHolderModule = false;
        Module configuredFileContentsHolder = null;
        int i = 0;
        int size = configuredModules.size();
        while (i < size) {
            Module module = configuredModules.get(i);
            String internalName = module.getMetaData().getInternalName();
            if ("FileContentsHolder".equals(internalName)) {
                containsFileContentsHolderModule = true;
                configuredFileContentsHolder = module;
            } else if ("SuppressionCommentFilter".equals(internalName)) {
                needsFileContentsHolderModule = true;
            } else if ("SuppressWithNearbyCommentFilter".equals(internalName)) {
                needsFileContentsHolderModule = true;
            }
            if (containsFileContentsHolderModule && needsFileContentsHolderModule) break;
            ++i;
        }
        if (!containsFileContentsHolderModule && needsFileContentsHolderModule) {
            Module fileContentsHolder = new Module(MetadataFactory.getRuleMetadata("FileContentsHolder"), false);
            configuredModules.add(0, fileContentsHolder);
        } else if (containsFileContentsHolderModule && !needsFileContentsHolderModule) {
            configuredModules.remove(configuredFileContentsHolder);
        }
    }
}

