/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.util.ArrayList;
import java.util.List;
import net.sf.eclipsecs.core.config.configtypes.IContextAware;
import net.sf.eclipsecs.core.config.configtypes.PropertyUtil;
import org.eclipse.core.resources.IProject;

public class MultiPropertyResolver
implements PropertyResolver,
IContextAware {
    private List<PropertyResolver> mChildResolver = new ArrayList<PropertyResolver>();

    public void addPropertyResolver(PropertyResolver resolver) {
        this.mChildResolver.add(resolver);
    }

    public void setProjectContext(IProject project) {
        int i = 0;
        int size = this.mChildResolver.size();
        while (i < size) {
            PropertyResolver aChildResolver = this.mChildResolver.get(i);
            if (aChildResolver instanceof IContextAware) {
                ((IContextAware)aChildResolver).setProjectContext(project);
            }
            ++i;
        }
    }

    public String resolve(String property) throws CheckstyleException {
        String value = null;
        int i = 0;
        int size = this.mChildResolver.size();
        while (i < size) {
            PropertyResolver aChildResolver = this.mChildResolver.get(i);
            value = aChildResolver.resolve(property);
            if (value != null) break;
            ++i;
        }
        while (PropertyUtil.hasUnresolvedProperties(value)) {
            value = PropertyUtil.replaceProperties(value, this);
        }
        return value;
    }
}

