/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.EclipseLogHandler;
import net.sf.eclipsecs.core.util.ExtensionClassLoader;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class CheckstylePlugin
extends Plugin {
    public static final String PLUGIN_ID = "net.sf.eclipsecs.core";
    private static final String ADDON_PROVIDER_EXT_PT_ID = "net.sf.eclipsecs.core.checkstyleAddonProvider";
    private static CheckstylePlugin sPlugin;
    private ClassLoader mAddonExtensionClassLoader;

    public CheckstylePlugin() {
        sPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.mAddonExtensionClassLoader = new ExtensionClassLoader(context.getBundle(), ADDON_PROVIDER_EXT_PT_ID);
        try {
            Logger checkstyleErrorLog = Logger.getLogger("com.puppycrawl.tools.checkstyle.ExceptionLog");
            checkstyleErrorLog.addHandler(new EclipseLogHandler(this));
            checkstyleErrorLog.setLevel(Level.ALL);
        }
        catch (Exception ioe) {
            CheckstyleLog.log(ioe);
        }
    }

    public static CheckstylePlugin getDefault() {
        return sPlugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Locale getPlatformLocale() {
        String nl = Platform.getNL();
        String[] parts = nl.split("_");
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        String variant = parts.length > 2 ? parts[2] : "";
        return new Locale(language, country, variant);
    }

    public ClassLoader getAddonExtensionClassLoader() {
        return this.mAddonExtensionClassLoader;
    }
}

