/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.util.table;

import java.text.Collator;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.util.table.ITableComparableProvider;
import net.sf.eclipsecs.ui.util.table.ITableSettingsProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EnhancedTableViewer
extends TableViewer {
    private static final String TAG_COLUMN_INDEX = "sortColumn";
    private static final String TAG_SORT_DIRECTION = "sortDirection";
    private static final String TAG_COLUMN_WIDTH = "colWidth";
    private static final String TAG_CURRENT_SELECTION = "selectedRow";
    private static final int DIRECTION_FORWARD = 1;
    private static final int DIRECTION_REVERSE = -1;
    private static final Collator COLLATOR = Collator.getInstance(CheckstyleUIPlugin.getPlatformLocale());
    private ITableComparableProvider mComparableProvider;
    private ITableSettingsProvider mSettingsProvider;
    private int mSortedColumnIndex;
    private int mSortDirection = 1;
    private TableListener mTableListener = new TableListener();

    public EnhancedTableViewer(Table table) {
        super(table);
    }

    public EnhancedTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    public EnhancedTableViewer(Composite parent) {
        super(parent);
    }

    public void setTableComparableProvider(ITableComparableProvider comparableProvider) {
        this.mComparableProvider = comparableProvider;
        if (this.mComparableProvider != null) {
            this.setSorter(new TableSorter());
        } else {
            this.setSorter(null);
        }
    }

    public ITableComparableProvider getTableComparableProvider() {
        return this.mComparableProvider;
    }

    public void setTableSettingsProvider(ITableSettingsProvider settingsProvider) {
        this.mSettingsProvider = settingsProvider;
    }

    public ITableSettingsProvider getTableSettingsProvider() {
        return this.mSettingsProvider;
    }

    public void installEnhancements() {
        this.getTable().removeSelectionListener((SelectionListener)this.mTableListener);
        TableColumn[] columns = this.getTable().getColumns();
        int i = 0;
        int size = columns.length;
        while (i < size) {
            columns[i].removeSelectionListener((SelectionListener)this.mTableListener);
            columns[i].removeControlListener((ControlListener)this.mTableListener);
            ++i;
        }
        this.restoreState();
        this.getTable().addSelectionListener((SelectionListener)this.mTableListener);
        i = 0;
        size = columns.length;
        while (i < size) {
            columns[i].addSelectionListener((SelectionListener)this.mTableListener);
            columns[i].addControlListener((ControlListener)this.mTableListener);
            ++i;
        }
    }

    private void saveState() {
        IDialogSettings settings;
        IDialogSettings iDialogSettings = settings = this.mSettingsProvider != null ? this.mSettingsProvider.getTableSettings() : null;
        if (settings == null) {
            return;
        }
        settings.put(TAG_COLUMN_INDEX, this.mSortedColumnIndex);
        settings.put(TAG_SORT_DIRECTION, this.mSortDirection);
        TableColumn[] columns = this.getTable().getColumns();
        int i = 0;
        int size = columns.length;
        while (i < size) {
            int width = columns[i].getWidth();
            if (width > 0) {
                settings.put(TAG_COLUMN_WIDTH + i, width);
            }
            ++i;
        }
        settings.put(TAG_CURRENT_SELECTION, this.getTable().getSelectionIndex());
    }

    private void restoreState() {
        IDialogSettings settings;
        IDialogSettings iDialogSettings = settings = this.mSettingsProvider != null ? this.mSettingsProvider.getTableSettings() : null;
        if (settings == null) {
            return;
        }
        try {
            this.mSortedColumnIndex = settings.getInt(TAG_COLUMN_INDEX);
        }
        catch (NumberFormatException numberFormatException) {
            this.mSortedColumnIndex = 0;
        }
        try {
            this.mSortDirection = settings.getInt(TAG_SORT_DIRECTION);
        }
        catch (NumberFormatException numberFormatException) {
            this.mSortDirection = 1;
        }
        TableLayout layout = new TableLayout();
        boolean allColumnsHaveStoredData = true;
        TableColumn[] columns = this.getTable().getColumns();
        int i = 0;
        int size = columns.length;
        while (i < size) {
            try {
                int width = settings.getInt(TAG_COLUMN_WIDTH + i);
                columns[i].setWidth(width);
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(width));
            }
            catch (NumberFormatException numberFormatException) {
                allColumnsHaveStoredData = false;
            }
            ++i;
        }
        if (allColumnsHaveStoredData) {
            this.getTable().setLayout((Layout)layout);
        }
        try {
            this.getTable().select(settings.getInt(TAG_CURRENT_SELECTION));
        }
        catch (NumberFormatException numberFormatException) {}
        this.resort();
    }

    private void resort() {
        this.getTable().getDisplay().asyncExec(new Runnable(){

            public void run() {
                EnhancedTableViewer.this.getControl().setRedraw(false);
                EnhancedTableViewer.this.refresh(false);
                EnhancedTableViewer.this.getControl().setRedraw(true);
            }
        });
    }

    private class TableListener
    implements SelectionListener,
    ControlListener {
        private TableListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() instanceof TableColumn) {
                TableColumn col = (TableColumn)e.getSource();
                Table table = col.getParent();
                int colIndex = table.indexOf(col);
                if (colIndex == EnhancedTableViewer.this.mSortedColumnIndex) {
                    EnhancedTableViewer enhancedTableViewer = EnhancedTableViewer.this;
                    enhancedTableViewer.mSortDirection = enhancedTableViewer.mSortDirection * -1;
                } else {
                    EnhancedTableViewer.this.mSortedColumnIndex = colIndex;
                    EnhancedTableViewer.this.mSortDirection = 1;
                }
                EnhancedTableViewer.this.resort();
                EnhancedTableViewer.this.saveState();
            }
        }

        public void controlResized(ControlEvent e) {
            if (e.getSource() instanceof TableColumn) {
                EnhancedTableViewer.this.saveState();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void controlMoved(ControlEvent e) {
        }
    }

    private class TableSorter
    extends ViewerSorter {
        private TableSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Comparable c1 = EnhancedTableViewer.this.mComparableProvider.getComparableValue(e1, EnhancedTableViewer.this.mSortedColumnIndex);
            Comparable c2 = EnhancedTableViewer.this.mComparableProvider.getComparableValue(e2, EnhancedTableViewer.this.mSortedColumnIndex);
            int compareResult = 0;
            compareResult = c1 instanceof String && c2 instanceof String ? COLLATOR.compare(c1, c2) : c1.compareTo(c2);
            return compareResult * EnhancedTableViewer.this.mSortDirection;
        }
    }
}

