/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.coding;

import java.util.List;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class RequireThisQuickfix
extends AbstractASTResolution {
    protected ASTVisitor handleGetCorrectingASTVisitor(IRegion lineInfo, final int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(SimpleName node) {
                if (RequireThisQuickfix.this.containsPosition((ASTNode)node, markerStartOffset)) {
                    RequireThisQuickfix.this.replace((ASTNode)node, (ASTNode)this.findFieldReplacement(node, (ASTNode)node, 0));
                }
                return false;
            }

            public boolean visit(MethodInvocation node) {
                if (RequireThisQuickfix.this.containsPosition((ASTNode)node, markerStartOffset)) {
                    RequireThisQuickfix.this.replace((ASTNode)node, (ASTNode)this.findMethodReplacement(node.getName(), (ASTNode)node, node, 0));
                }
                return false;
            }

            private Expression findFieldReplacement(SimpleName name, ASTNode node, int typeLevel) {
                int level = typeLevel;
                ASTNode parent = node.getParent();
                if (parent instanceof TypeDeclaration) {
                    ++level;
                    TypeDeclaration type = (TypeDeclaration)parent;
                    FieldDeclaration[] fieldDeclarationArray = type.getFields();
                    int n = fieldDeclarationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
                        List fragments = fieldDeclaration.fragments();
                        for (VariableDeclarationFragment fragment : fragments) {
                            if (!name.getFullyQualifiedName().equals(fragment.getName().getFullyQualifiedName())) continue;
                            return this.createFieldAccessReplacement(level == 1 ? null : type, name);
                        }
                        ++n2;
                    }
                }
                return this.findFieldReplacement(name, parent, level);
            }

            private FieldAccess createFieldAccessReplacement(TypeDeclaration type, SimpleName name) {
                AST ast = name.getAST();
                FieldAccess fieldAccess = ast.newFieldAccess();
                ThisExpression thisExpr = ast.newThisExpression();
                if (type != null) {
                    thisExpr.setQualifier((Name)RequireThisQuickfix.this.copy((ASTNode)type.getName()));
                }
                fieldAccess.setExpression((Expression)thisExpr);
                fieldAccess.setName((SimpleName)RequireThisQuickfix.this.copy((ASTNode)name));
                return fieldAccess;
            }

            private Expression findMethodReplacement(SimpleName name, ASTNode contextNode, MethodInvocation node, int typeLevel) {
                int level = typeLevel;
                ASTNode parent = contextNode.getParent();
                if (parent instanceof TypeDeclaration) {
                    ++level;
                    TypeDeclaration type = (TypeDeclaration)parent;
                    MethodDeclaration[] methodDeclarationArray = type.getMethods();
                    int n = methodDeclarationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
                        if (name.getFullyQualifiedName().equals(methodDeclaration.getName().getFullyQualifiedName())) {
                            return this.createMethodInvocationReplacement(level == 1 ? null : type, node);
                        }
                        ++n2;
                    }
                }
                return this.findMethodReplacement(name, parent, node, level);
            }

            private Expression createMethodInvocationReplacement(TypeDeclaration type, MethodInvocation origMethodInvocation) {
                AST ast = origMethodInvocation.getAST();
                MethodInvocation methodInvocation = (MethodInvocation)RequireThisQuickfix.this.copy((ASTNode)origMethodInvocation);
                ThisExpression thisExpr = ast.newThisExpression();
                if (type != null) {
                    thisExpr.setQualifier((Name)RequireThisQuickfix.this.copy((ASTNode)type.getName()));
                }
                methodInvocation.setExpression((Expression)thisExpr);
                return methodInvocation;
            }
        };
    }

    public String getDescription() {
        return Messages.RequireThisQuickfix_description;
    }

    public String getLabel() {
        return Messages.RequireThisQuickfix_label;
    }

    public Image getImage() {
        return CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.CORRECTION_ADD);
    }
}

