/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.coding;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class ExplicitInitializationQuickfix
extends AbstractASTResolution {
    private String mFieldName = Messages.ExplicitInitializationQuickfix_unknownFieldName;

    public boolean canFix(IMarker marker) {
        this.retrieveFieldName(marker);
        return super.canFix(marker);
    }

    private void retrieveFieldName(IMarker marker) {
        try {
            Map attributes = marker.getAttributes();
            int start = (Integer)attributes.get("charStart");
            int end = (Integer)attributes.get("charEnd");
            IFile resource = (IFile)marker.getResource();
            InputStream in = resource.getContents();
            byte[] buffer = new byte[end - start];
            in.skip(start);
            in.read(buffer, 0, buffer.length);
            in.close();
            String snippet = new String(buffer, resource.getCharset());
            this.mFieldName = snippet.substring(0, snippet.indexOf(61)).trim();
        }
        catch (CoreException e) {
            this.handleRetrieveFieldNameException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleRetrieveFieldNameException(e);
        }
        catch (IndexOutOfBoundsException e) {
            this.handleRetrieveFieldNameException(e);
        }
        catch (ClassCastException e) {
            this.handleRetrieveFieldNameException(e);
        }
        catch (NullPointerException e) {
            this.handleRetrieveFieldNameException(e);
        }
    }

    private void handleRetrieveFieldNameException(Exception e) {
        CheckstyleLog.log((Throwable)e, (String)Messages.ExplicitInitializationQuickfix_errorMessageFieldName);
    }

    protected ASTVisitor handleGetCorrectingASTVisitor(IRegion lineInfo, final int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(VariableDeclarationFragment node) {
                if (ExplicitInitializationQuickfix.this.containsPosition((ASTNode)node, markerStartOffset)) {
                    node.getInitializer().delete();
                }
                return false;
            }
        };
    }

    public String getDescription() {
        return NLS.bind((String)Messages.ExplicitInitializationQuickfix_description, (Object)this.mFieldName);
    }

    public String getLabel() {
        return NLS.bind((String)Messages.ExplicitInitializationQuickfix_label, (Object)this.mFieldName);
    }

    public Image getImage() {
        return CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.CORRECTION_REMOVE);
    }
}

