/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties.filter;

import java.util.ArrayList;
import java.util.List;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.properties.filter.IFilterEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTypesFilterEditor
implements IFilterEditor {
    private FileTypesDialog mDialog;
    private List<String> mFilterData;

    @Override
    public int openEditor(Shell parent) {
        this.mDialog = new FileTypesDialog(parent, this.mFilterData);
        int retCode = this.mDialog.open();
        if (retCode == 0) {
            this.mFilterData = this.getFilterDataFromDialog();
        }
        return retCode;
    }

    @Override
    public void setInputProject(IProject input) {
    }

    @Override
    public void setFilterData(List<String> filterData) {
        this.mFilterData = new ArrayList<String>(filterData);
    }

    @Override
    public List<String> getFilterData() {
        return this.mFilterData;
    }

    private List<String> getFilterDataFromDialog() {
        return this.mFilterData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileTypesDialog
    extends Dialog {
        private ListViewer mListViewer;
        private Button mAddButton;
        private Button mRemoveButton;
        private Text mFileTypeText;
        private List<String> mFileTypesList;

        public FileTypesDialog(Shell parentShell, List<String> fileTypes) {
            super(parentShell);
            this.mFileTypesList = fileTypes;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite main = new Composite(composite, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            main.setLayout((Layout)layout);
            GridData gd = new GridData(1808);
            main.setLayoutData((Object)gd);
            this.mFileTypeText = new Text(main, 18436);
            gd = new GridData(768);
            this.mFileTypeText.setLayoutData((Object)gd);
            this.mAddButton = new Button(main, 8);
            this.mAddButton.setText(Messages.FileTypesFilterEditor_btnAdd);
            gd = new GridData(768);
            gd.verticalAlignment = 128;
            this.mAddButton.setLayoutData((Object)gd);
            this.mAddButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String text = FileTypesDialog.this.mFileTypeText.getText();
                    if (text.trim().length() > 0) {
                        FileTypesDialog.this.mFileTypesList.add(FileTypesDialog.this.mFileTypeText.getText());
                        FileTypesDialog.this.mListViewer.refresh();
                        FileTypesDialog.this.mFileTypeText.setText("");
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.mListViewer = new ListViewer(main, 2820);
            this.mListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.mListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.mListViewer.setInput(this.mFileTypesList);
            gd = new GridData(1808);
            gd.heightHint = 100;
            gd.widthHint = 150;
            gd.grabExcessVerticalSpace = true;
            this.mListViewer.getControl().setLayoutData((Object)gd);
            this.mRemoveButton = new Button(main, 8);
            this.mRemoveButton.setText(Messages.FileTypesFilterEditor_btnRemove);
            gd = new GridData(768);
            gd.verticalAlignment = 128;
            this.mRemoveButton.setLayoutData((Object)gd);
            this.mRemoveButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)FileTypesDialog.this.mListViewer.getSelection();
                    FileTypesDialog.this.mFileTypesList.remove(selection.getFirstElement());
                    FileTypesDialog.this.mListViewer.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return main;
        }

        protected void okPressed() {
            super.okPressed();
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.FileTypesFilterEditor_title);
        }
    }
}

