/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.duplicates;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DuplicatedCode {
    private static final String DUPLICATES_MESSAGE_BUNDLE = "com.puppycrawl.tools.checkstyle.checks.duplicates.messages";
    private static final String DUPLICATE_LINE_MESSAGE = "duplicates.lines";
    private static String sMask1;
    private static String sMask2;
    private static String sMask3;
    private IFile mSourceFile;
    private int mLineNumber;
    private String mMessage;

    static {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(DUPLICATES_MESSAGE_BUNDLE);
            String localProperty = resourceBundle.getString(DUPLICATE_LINE_MESSAGE);
            sMask1 = localProperty.substring(0, localProperty.indexOf("{0}"));
            sMask2 = localProperty.substring(localProperty.indexOf("{0}") + 3, localProperty.indexOf("{1}"));
            sMask3 = localProperty.substring(localProperty.indexOf("{1}") + 3, localProperty.indexOf("{2}"));
        }
        catch (MissingResourceException x) {
            CheckstyleLog.log((Throwable)x, (String)"Unable to get the resource bundle com.puppycrawl.tools.checkstyle.checks.duplicates.messages.");
        }
    }

    public DuplicatedCode(IFile file, int line, String checkstyleMessage) {
        this.mSourceFile = file;
        this.mLineNumber = line;
        this.mMessage = checkstyleMessage;
    }

    public int getNumberOfDuplicatedLines() {
        int result;
        if (this.mMessage == null) {
            return 0;
        }
        int start = this.mMessage.indexOf(sMask1) + sMask1.length();
        int end = this.mMessage.indexOf(sMask2);
        String number = this.mMessage.substring(start, end);
        try {
            result = Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            result = 0;
        }
        return result;
    }

    public IFile getTargetFile() {
        int start = this.mMessage.indexOf(sMask2) + sMask2.length();
        int end = this.mMessage.indexOf(sMask3);
        String path = this.mMessage.substring(start, end);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
        return file;
    }

    public int getTargetFileFirstLineNumber() {
        int result;
        int start = this.mMessage.indexOf(sMask3) + sMask3.length();
        String number = this.mMessage.substring(start);
        try {
            result = Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            result = 0;
        }
        return result;
    }

    public int getSourceFileFirstLineNumber() {
        return this.mLineNumber;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public IFile getSourceFile() {
        return this.mSourceFile;
    }

    public String toString() {
        return this.mMessage;
    }
}

