/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.widgets;

import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.config.widgets.IConfigPropertyWidget;
import net.sf.eclipsecs.ui.util.SWTUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class ConfigPropertyWidgetAbstractBase
implements IConfigPropertyWidget {
    private ConfigProperty mProp;
    private Control mValueWidget;
    private Composite mParent;

    protected ConfigPropertyWidgetAbstractBase(Composite parent, ConfigProperty prop) {
        this.mParent = parent;
        this.mProp = prop;
    }

    public void initialize() {
        Label label = new Label(this.mParent, 0);
        label.setText(String.valueOf(this.mProp.getName()) + ":");
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.mValueWidget = this.getValueWidget(this.mParent);
        gd = (GridData)this.mValueWidget.getLayoutData();
        this.mValueWidget.setToolTipText(this.mProp.getMetaData().getDescription());
        Label lblPropertyInfo = new Label(this.mParent, 0);
        gd = new GridData();
        gd.verticalAlignment = 1;
        lblPropertyInfo.setLayoutData((Object)gd);
        lblPropertyInfo.setImage(CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.HELP_ICON));
        lblPropertyInfo.setToolTipText(this.mProp.getMetaData().getDescription());
        SWTUtil.addTooltipOnPressSupport((Control)lblPropertyInfo);
    }

    public void setEnabled(boolean enabled) {
        this.mValueWidget.setEnabled(enabled);
    }

    protected abstract Control getValueWidget(Composite var1);

    public abstract String getValue();

    protected String getInitValue() {
        String initValue = null;
        if (this.mProp != null) {
            initValue = this.mProp.getValue();
        }
        if (initValue == null) {
            initValue = this.mProp.getMetaData().getOverrideDefault();
        }
        if (initValue == null) {
            initValue = this.mProp.getMetaData().getDefaultValue();
        }
        if (initValue == null) {
            initValue = "";
        }
        return initValue;
    }

    public ConfigProperty getConfigProperty() {
        return this.mProp;
    }

    public void validate() throws CheckstylePluginException {
    }
}

