/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.actions;

import java.util.Collection;
import net.sf.eclipsecs.core.jobs.ConfigureDeconfigureNatureJob;
import net.sf.eclipsecs.ui.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DeactivateProjectsAction
implements IObjectActionDelegate {
    private Collection<IProject> mSelectedProjects;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            this.mSelectedProjects = sel.toList();
        }
    }

    public void run(IAction action) {
        BulkCheckstyleActivateJob job = new BulkCheckstyleActivateJob(this.mSelectedProjects);
        job.schedule();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BulkCheckstyleActivateJob
    extends WorkspaceJob {
        private Collection<IProject> mProjectsToDeactivate;

        public BulkCheckstyleActivateJob(Collection<IProject> projectsToDeactivate) {
            super(Messages.DeactivateProjectsPrintAction_msgDeactivateSelectedProjects);
            this.mProjectsToDeactivate = projectsToDeactivate;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            for (IProject configurationTarget : this.mProjectsToDeactivate) {
                if (!configurationTarget.isOpen() || !configurationTarget.hasNature("net.sf.eclipsecs.core.CheckstyleNature")) continue;
                ConfigureDeconfigureNatureJob job = new ConfigureDeconfigureNatureJob(configurationTarget, "net.sf.eclipsecs.core.CheckstyleNature");
                job.schedule();
            }
            return Status.OK_STATUS;
        }
    }
}

