/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.jdt.core.internal;

import com.chookapp.org.bracketeer.jdt.core.internal.ISourceVersionDependent;
import com.chookapp.org.bracketeer.jdt.core.internal.JavaHeuristicScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;

public final class JavaPairMatcher
extends DefaultCharacterPairMatcher
implements ISourceVersionDependent {
    private boolean fHighlightAngularBrackets = false;

    public JavaPairMatcher(char[] pairs) {
        super(pairs, "___java_partitioning");
    }

    public IRegion match(IDocument document, int offset) {
        try {
            return this.performMatch(document, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IRegion performMatch(IDocument document, int offset) throws BadLocationException {
        int peer;
        if (offset < 0 || document == null) {
            return null;
        }
        char prevChar = document.getChar(Math.max(offset - 1, 0));
        if (!(prevChar != '<' && prevChar != '>' || this.fHighlightAngularBrackets)) {
            return null;
        }
        if (prevChar == '<' && this.isLessThanOperator(document, offset - 1)) {
            return null;
        }
        IRegion region = super.match(document, offset);
        if (region == null) {
            return region;
        }
        if (prevChar == '>' && this.isLessThanOperator(document, peer = region.getOffset())) {
            return null;
        }
        return region;
    }

    private boolean isLessThanOperator(IDocument document, int offset) throws BadLocationException {
        if (offset < 0) {
            return false;
        }
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document, "___java_partitioning", TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)false));
        return !this.isTypeParameterBracket(offset, document, scanner);
    }

    private boolean isTypeParameterBracket(int offset, IDocument document, JavaHeuristicScanner scanner) {
        try {
            String previous;
            IRegion line = document.getLineInformationOfOffset(offset);
            int prevToken = scanner.previousToken(offset - 1, line.getOffset());
            int prevTokenOffset = scanner.getPosition() + 1;
            String string = previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            return prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isTypeParameterIntroducer(previous) || prevToken == -1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isTypeParameterIntroducer(String identifier) {
        return identifier.length() > 0 && (Character.isUpperCase(identifier.charAt(0)) || identifier.startsWith("final") || identifier.startsWith("public") || identifier.startsWith("public") || identifier.startsWith("protected") || identifier.startsWith("private"));
    }

    @Override
    public void setSourceVersion(String version) {
        this.fHighlightAngularBrackets = "1.5".compareTo(version) <= 0;
    }
}

