/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerFieldEditor
extends FieldEditor {
    private Composite _outer;
    private Spinner _spinner;

    public SpinnerFieldEditor(String name, String label, Composite parent) {
        super(name, label, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this._outer.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this._outer = parent;
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = numColumns;
        this._outer.setLayoutData((Object)griddata);
        Label label = this.getLabelControl(this._outer);
        label.setLayoutData((Object)new GridData());
        this._spinner = new Spinner(this._outer, 2048);
        this._spinner.setLayoutData((Object)new GridData());
        this._spinner.setBackground(Display.getCurrent().getSystemColor(25));
    }

    public Spinner getSpinner() {
        return this._spinner;
    }

    protected void doLoad() {
        int loadedint = this.getPreferenceStore().getInt(this.getPreferenceName());
        this._spinner.setSelection(loadedint);
    }

    protected void doLoadDefault() {
        int loadedint = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
        this._spinner.setSelection(loadedint);
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this._spinner.getSelection());
    }

    public int getNumberOfControls() {
        return 2;
    }
}

