/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.preferences;

public final class PreferencesConstants {
    public static final int MAX_PAIRS = 4;

    public static String preferencePath(String pluginName) {
        return String.valueOf(pluginName) + ".";
    }

    public static final class Annotations {
        private static final String AnnotationPath = "Annotation.";
        public static final String Enable = "Annotation.MissingPair.Enable";
    }

    public static final class General {
        private static final String PATH = "General.";
        public static final String HYPERLINK_MODIFIERS = "General.HyperlinkModifiers";
    }

    public static final class Highlights {
        private static final String HighlightsPath = "Highlights.";
        private static final String Default = "Default.";
        private static final String MatchingPairPrefix = "MatchingPair";
        private static final String MissingPair = "MissingPair.";
        private static final String Background = "Background.";
        private static final String Foreground = "Foreground.";
        public static final String UseDefault = "UseDefault";
        public static final String Color = "Color";
        public static final String HighlightTypeAttr = "HighlightType";
        public static final String HighlightTypeValNone = "None";
        public static final String HighlightTypeValSolid = "Solid";
        public static final String HighlightTypeValOutline = "Outline";

        public static String getAttrPath(int typeId, boolean foregound) {
            String path = HighlightsPath;
            path = typeId == 0 ? String.valueOf(path) + Default : (typeId < 5 ? String.valueOf(path) + MatchingPairPrefix + typeId + "." : String.valueOf(path) + MissingPair);
            path = foregound ? String.valueOf(path) + Foreground : String.valueOf(path) + Background;
            return path;
        }
    }

    public static final class Hints {
        public static final String DEFAULT_TYPE = "default";

        public static String preferencePath(String hintType) {
            return "Hints." + hintType + ".";
        }

        public static String preferencePath(String pluginName, String hintType) {
            return String.valueOf(PreferencesConstants.preferencePath(pluginName)) + Hints.preferencePath(hintType);
        }

        public static final class Display {
            private static final String PATH = "Display.";
            public static final String USE_DEFAULT = "Display.UseDefault";
            public static final String MAX_LENGTH = "Display.MaxLength";
            public static final String STRIP_WHITESPACE = "Display.StripWhiteSpaces";

            public static final class CommentType {
                public static final String ATTR = "Display.CommentType";
                public static final String VAL_SLASH_STAR = "slashstar";
                public static final String VAL_SLASH_SLASH = "slashslash";
            }

            public static final class Ellipsis {
                public static final String ATTR = "Display.Ellipsis";
                public static final String VAL_END = "end";
                public static final String VAL_MID = "mid";
            }
        }

        public static final class Font {
            private static final String PATH = "Font.";
            public static final String USE_DEFAULT = "Font.UseDefault";
            public static final String FG_DEFAULT = "Font.FgSysDefault";
            public static final String FG_COLOR = "Font.FgColor";
            public static final String BG_DEFAULT = "Font.BgSysDefault";
            public static final String BG_COLOR = "Font.BgColor";
            public static final String ITALIC = "Font.Italic";
        }

        public static final class Globals {
            private static final String PATH = "Hints.Globals.";
            public static final String SHOW_IN_EDITOR = "Hints.Globals.ShowInEditor";
        }

        public static final class Hover {
            private static final String PATH = "Hints.Hover.";
            public static final String ENABLE = "Hints.Hover.Enable";
            public static final String MAX_LEN = "Hints.Hover.MaxLength";
        }

        public static final class WhenToShow {
            private static final String PATH = "WhenToShow.";
            public static final String USE_DEFAULT = "WhenToShow.UseDefault";
            public static final String SHOW_IN_EDITOR = "WhenToShow.ShowInEditor";
            public static final String MIN_LINES_DISTANCE = "WhenToShow.MinLinesDistance";
        }
    }

    public static final class Hovering {
        private static final String HoveringPath = "Hovering.";
        public static final String Enable = "Hovering.Enable";
        public static final String PopupEnable = "Hovering.EnablePopup";
        public static final String PopupOnlyWithoutHint = "Hovering.PopupOnlyWithoutHint";
    }

    public static final class Surrounding {
        private static final String SurroundingPath = "Surrounding.";
        public static final String Enable = "Surrounding.Enable";
        public static final String ShowBrackets = "Surrounding.ShowBrackets";
        public static final String NumBracketsToShow = "Surrounding.NumBracketsToShow";
        public static final String MinDistanceBetweenBrackets = "Surrounding.MinDistanceBetweenBrackets";
    }
}

