/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.extensionpoint;

import com.chookapp.org.bracketeer.common.IBracketeerProcessingContainer;
import com.chookapp.org.bracketeer.common.IHintConfiguration;
import com.chookapp.org.bracketeer.common.MutableBool;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public abstract class BracketeerProcessor
implements IDocumentListener {
    protected MutableBool _cancelProcessing;
    protected IDocument _doc;
    protected IHintConfiguration _hintConf;

    protected BracketeerProcessor(IDocument doc) {
        this._doc = doc;
        this._cancelProcessing = new MutableBool(false);
    }

    public void setHintConf(IHintConfiguration conf) {
        this._hintConf = conf;
    }

    public boolean process(IBracketeerProcessingContainer container) {
        this._cancelProcessing.set(false);
        this._doc.addDocumentListener((IDocumentListener)this);
        this.processDocument(this._doc, container);
        this.postProcess(this._doc, container);
        this._doc.removeDocumentListener((IDocumentListener)this);
        return !this._cancelProcessing.get();
    }

    private void postProcess(IDocument doc, IBracketeerProcessingContainer container) {
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this._cancelProcessing.set(true);
    }

    public void documentChanged(DocumentEvent event) {
    }

    protected abstract void processDocument(IDocument var1, IBracketeerProcessingContainer var2);
}

