/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.core;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;

public class TextUtils {
    public static IRegion getWidgetRange(ISourceViewer sv, int offset, int length) {
        if (sv instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sv;
            IRegion widgetRange = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
            if (widgetRange == null) {
                return null;
            }
            try {
                IDocument doc = sv.getDocument();
                int startLine = doc.getLineOfOffset(offset);
                int endLine = doc.getLineOfOffset(offset + length);
                if (extension.modelLine2WidgetLine(startLine) == -1 || extension.modelLine2WidgetLine(endLine) == -1) {
                    return null;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            return widgetRange;
        }
        IRegion region = sv.getVisibleRegion();
        if (region.getOffset() > offset || region.getOffset() + region.getLength() < offset + length) {
            return null;
        }
        return new Region(offset -= region.getOffset(), length);
    }
}

