/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.core;

import com.chookapp.org.bracketeer.Activator;
import com.chookapp.org.bracketeer.common.IHintConfiguration;
import com.chookapp.org.bracketeer.core.IProcessorConfigurationListener;
import com.chookapp.org.bracketeer.core.Messages;
import com.chookapp.org.bracketeer.preferences.PreferencesConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class ProcessorConfiguration
implements IPropertyChangeListener {
    private PairConfiguration _pairConf = new PairConfiguration();
    private SingleBracketConfiguration _singleConf = new SingleBracketConfiguration();
    private HintConfiguration _hintConf = new HintConfiguration();
    private GeneralConfiguration _generalConf = new GeneralConfiguration();
    private String _name;
    private IPreferenceStore _prefStore;
    private List<IProcessorConfigurationListener> _listeners;
    private List<String> _hintTypes = new ArrayList<String>();

    public ProcessorConfiguration(IConfigurationElement confElement) {
        IConfigurationElement[] hints;
        this._name = confElement.getAttribute("name");
        IConfigurationElement[] iConfigurationElementArray = hints = confElement.getChildren("Hint");
        int n = hints.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement hint = iConfigurationElementArray[n2];
            this._hintTypes.add(hint.getAttribute("type"));
            ++n2;
        }
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>();
        stores.add(Activator.getDefault().getPreferenceStore());
        this._prefStore = new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
        this._prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this._listeners = new LinkedList<IProcessorConfigurationListener>();
        this.updateConfiguartion();
    }

    public String getName() {
        return this._name;
    }

    public PairConfiguration getPairConfiguration() {
        return this._pairConf;
    }

    public SingleBracketConfiguration getSingleBracketConfiguration() {
        return this._singleConf;
    }

    public HintConfiguration getHintConfiguration() {
        return this._hintConf;
    }

    public GeneralConfiguration getGeneralConfiguration() {
        return this._generalConf;
    }

    private void updateConfiguartion() {
        this.updateHighlightConf();
        this.updateHintConf();
        this.updateGeneralConf();
        for (IProcessorConfigurationListener listener : this._listeners) {
            listener.configurationUpdated();
        }
    }

    private void updateGeneralConf() {
        this._generalConf.setHyperlinkModifiers(this._prefStore.getInt("General.HyperlinkModifiers"));
    }

    private void updateHintConf() {
        String prefBase = PreferencesConstants.preferencePath(this._name);
        this._hintConf._showOnHover = this._prefStore.getBoolean(String.valueOf(prefBase) + "Hints.Hover.Enable");
        this._hintConf._hoveredMaxLength = this._prefStore.getInt(String.valueOf(prefBase) + "Hints.Hover.MaxLength");
        boolean showInEditor = this._prefStore.getBoolean(String.valueOf(prefBase) + "Hints.Globals.ShowInEditor");
        String defaultBase = String.valueOf(PreferencesConstants.preferencePath(this._name)) + PreferencesConstants.Hints.preferencePath("default");
        for (String hintType : this._hintTypes) {
            prefBase = String.valueOf(PreferencesConstants.preferencePath(this._name)) + PreferencesConstants.Hints.preferencePath(hintType);
            String[] listOfAttrs = new String[]{"WhenToShow.MinLinesDistance"};
            String baseToUse = prefBase;
            if (this._prefStore.getBoolean(String.valueOf(prefBase) + "WhenToShow.UseDefault")) {
                baseToUse = defaultBase;
            }
            String[] stringArray = listOfAttrs;
            int n = listOfAttrs.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                this._hintConf.setAttr(hintType, attr, this._prefStore.getString(String.valueOf(baseToUse) + attr));
                ++n2;
            }
            String whenToShowAttr = "WhenToShow.ShowInEditor";
            this._hintConf.setAttr(hintType, whenToShowAttr, showInEditor ? this._prefStore.getString(String.valueOf(baseToUse) + whenToShowAttr) : Boolean.FALSE.toString());
            listOfAttrs = new String[]{"Font.Italic"};
            baseToUse = prefBase;
            String typeToUse = hintType;
            if (this._prefStore.getBoolean(String.valueOf(prefBase) + "Font.UseDefault")) {
                typeToUse = "default";
                baseToUse = defaultBase;
            }
            this._hintConf.setColor(hintType, true, this.getHintColor(typeToUse, true));
            this._hintConf.setColor(hintType, false, this.getHintColor(typeToUse, false));
            String[] stringArray2 = listOfAttrs;
            int n3 = listOfAttrs.length;
            int n4 = 0;
            while (n4 < n3) {
                String attr = stringArray2[n4];
                this._hintConf.setAttr(hintType, attr, this._prefStore.getString(String.valueOf(baseToUse) + attr));
                ++n4;
            }
            listOfAttrs = new String[]{"Display.MaxLength", "Display.StripWhiteSpaces", "Display.Ellipsis", "Display.CommentType"};
            baseToUse = prefBase;
            if (this._prefStore.getBoolean(String.valueOf(prefBase) + "Display.UseDefault")) {
                baseToUse = defaultBase;
            }
            stringArray2 = listOfAttrs;
            n3 = listOfAttrs.length;
            n4 = 0;
            while (n4 < n3) {
                String attr = stringArray2[n4];
                this._hintConf.setAttr(hintType, attr, this._prefStore.getString(String.valueOf(baseToUse) + attr));
                ++n4;
            }
        }
    }

    private RGB getHintColor(String type, boolean foreground) {
        String suffix;
        String prefBase = PreferencesConstants.Hints.preferencePath(this._name, type);
        String string = suffix = foreground ? "Font.FgSysDefault" : "Font.BgSysDefault";
        if (this._prefStore.getBoolean(String.valueOf(prefBase) + suffix)) {
            return null;
        }
        suffix = foreground ? "Font.FgColor" : "Font.BgColor";
        return PreferenceConverter.getColor((IPreferenceStore)this._prefStore, (String)(String.valueOf(prefBase) + suffix));
    }

    private void updateHighlightConf() {
        RGB[] defColor = new RGB[]{null, null};
        String prefBase = PreferencesConstants.preferencePath(this._name);
        int fgIndex = 0;
        while (fgIndex < 2) {
            boolean foregound;
            boolean bl = foregound = fgIndex == 1;
            if (!this._prefStore.getBoolean(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(0, foregound) + "UseDefault")) {
                defColor[fgIndex] = PreferenceConverter.getColor((IPreferenceStore)this._prefStore, (String)(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(0, foregound) + "Color"));
            }
            int pairIdx = 0;
            while (pairIdx < 4) {
                if (this._prefStore.getBoolean(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(pairIdx + 1, foregound) + "UseDefault")) {
                    this._pairConf.setColor(foregound, pairIdx, defColor[fgIndex]);
                } else {
                    this._pairConf.setColor(foregound, pairIdx, PreferenceConverter.getColor((IPreferenceStore)this._prefStore, (String)(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(pairIdx + 1, foregound) + "Color")));
                }
                ++pairIdx;
            }
            this._pairConf.setEnableSurrounding(this._prefStore.getBoolean(String.valueOf(prefBase) + "Surrounding.Enable"));
            this._pairConf.setEnableHovering(this._prefStore.getBoolean(String.valueOf(prefBase) + "Hovering.Enable"));
            this._pairConf.setSurroundingPairsCount(this._prefStore.getInt(String.valueOf(prefBase) + "Surrounding.NumBracketsToShow"));
            this._pairConf.setSurroundingPairsToInclude(this._prefStore.getString(String.valueOf(prefBase) + "Surrounding.ShowBrackets"));
            this._pairConf.setMinDistanceBetweenBrackets(this._prefStore.getInt(String.valueOf(prefBase) + "Surrounding.MinDistanceBetweenBrackets"));
            this._pairConf.setEnablePopup(this._prefStore.getBoolean(String.valueOf(prefBase) + "Hovering.EnablePopup"));
            this._pairConf.setPopupOnlyWithoutHint(this._prefStore.getBoolean(String.valueOf(prefBase) + "Hovering.PopupOnlyWithoutHint"));
            pairIdx = 5;
            if (this._prefStore.getBoolean(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(pairIdx, foregound) + "UseDefault")) {
                this._singleConf.setColor(foregound, defColor[fgIndex]);
            } else {
                this._singleConf.setColor(foregound, PreferenceConverter.getColor((IPreferenceStore)this._prefStore, (String)(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(pairIdx, foregound) + "Color")));
            }
            ++fgIndex;
        }
        String defHighlightType = this._prefStore.getString(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(0, false) + "HighlightType");
        int pairIdx = 0;
        while (pairIdx < 4) {
            if (this._prefStore.getBoolean(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(pairIdx + 1, false) + "UseDefault")) {
                this._pairConf.setHighlightType(pairIdx, defHighlightType);
            } else {
                this._pairConf.setHighlightType(pairIdx, this._prefStore.getString(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(pairIdx + 1, false) + "HighlightType"));
            }
            ++pairIdx;
        }
        pairIdx = 5;
        if (this._prefStore.getBoolean(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(pairIdx + 1, false) + "UseDefault")) {
            this._singleConf.setHighlightType(defHighlightType);
        } else {
            this._singleConf.setHighlightType(this._prefStore.getString(String.valueOf(prefBase) + PreferencesConstants.Highlights.getAttrPath(pairIdx + 1, false) + "HighlightType"));
        }
        this._singleConf.setAnnotate(this._prefStore.getBoolean(String.valueOf(prefBase) + "Annotation.MissingPair.Enable"));
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateConfiguartion();
    }

    public void addListener(IProcessorConfigurationListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(IProcessorConfigurationListener listener) {
        if (!this._listeners.remove(listener)) {
            Activator.log(Messages.ProcessorConfiguration_ErrListenerNotFound);
        }
    }

    public class GeneralConfiguration {
        private int _hyperlinkModifiers;

        public int getHyperlinkModifiers() {
            return this._hyperlinkModifiers;
        }

        public void setHyperlinkModifiers(int modifiers) {
            this._hyperlinkModifiers = modifiers;
        }
    }

    public class HintConfiguration
    implements IHintConfiguration {
        private HashMap<String, HashMap<String, Object>> _attrMaps = new HashMap();
        private boolean _showOnHover;
        private int _hoveredMaxLength;

        @Override
        public boolean getBoolAttr(String type, String attr) {
            return Boolean.parseBoolean(this.getStringAttr(type, attr));
        }

        public int getIntAttr(String type, String attr) {
            return Integer.parseInt(this.getStringAttr(type, attr));
        }

        @Override
        public String getStringAttr(String type, String attr) {
            return (String)this.getAttr(type, attr);
        }

        public Object getAttr(String type, String attr) {
            HashMap<String, Object> attrMap = this._attrMaps.get(type);
            if (attrMap == null) {
                return null;
            }
            return attrMap.get(attr);
        }

        public void setAttr(String type, String attr, Object val) {
            HashMap<String, Object> attrMap = this._attrMaps.get(type);
            if (attrMap == null) {
                attrMap = new HashMap();
                this._attrMaps.put(type, attrMap);
            }
            attrMap.put(attr, val);
        }

        public boolean isShowInEditor(String type) {
            return this.getBoolAttr(type, "WhenToShow.ShowInEditor");
        }

        public boolean isShowOnHover() {
            return this._showOnHover;
        }

        public RGB getColor(String type, boolean foreground) {
            return (RGB)this.getAttr(type, foreground ? "Font.FgColor" : "Font.BgColor");
        }

        public void setColor(String type, boolean foreground, RGB color) {
            this.setAttr(type, foreground ? "Font.FgColor" : "Font.BgColor", color);
        }

        private String makeComment(String type, String txt) {
            String commentType = this.getStringAttr(type, "Display.CommentType");
            if (commentType.equals("slashslash")) {
                return " // " + txt;
            }
            return " /* " + txt + " */";
        }

        public String formatText(String type, String txt) {
            if (this.getBoolAttr(type, "Display.StripWhiteSpaces")) {
                txt = txt.replaceAll("[\\t ]+", "");
            }
            int maxLen = this.getIntAttr(type, "Display.MaxLength");
            return this.makeComment(type, this.performEllipsis(type, txt, maxLen));
        }

        public String formatTextHovered(String type, String txt) {
            if (this.getBoolAttr(type, "Display.StripWhiteSpaces")) {
                txt = txt.replaceAll("[\\t ]+", "");
            }
            return this.makeComment(type, this.performEllipsis(type, txt, this._hoveredMaxLength));
        }

        public boolean isItalic(String type) {
            return this.getBoolAttr(type, "Font.Italic");
        }

        public int getMinLineDistance(String type) {
            return this.getIntAttr(type, "WhenToShow.MinLinesDistance");
        }

        private String performEllipsis(String type, String txt, int maxLen) {
            String elip = this.getStringAttr(type, "Display.Ellipsis");
            if (txt.length() <= maxLen) {
                return txt;
            }
            if (elip.equals("end")) {
                txt = txt.substring(0, maxLen - 3);
                txt = String.valueOf(txt) + "...";
            } else if (elip.equals("mid")) {
                int partLen = (maxLen - 3) / 2;
                txt = String.valueOf(txt.substring(0, partLen)) + "..." + txt.substring(txt.length() - (partLen + 1));
            } else {
                throw new IllegalArgumentException(String.valueOf(Messages.ProcessorConfiguration_ErrUnkEllipsis) + elip);
            }
            return txt;
        }
    }

    public class PairConfiguration {
        private RGB[] _fgColors = new RGB[4];
        private RGB[] _bgColors = new RGB[4];
        private String[] _highlightTypes = new String[4];
        private int _surroundingPairsCount;
        private boolean _surroundingPairsEnable;
        private String _surroundingPairsToInclude;
        private boolean _hoveredPairsEnable;
        private int _minDistanceBetweenBrackets;
        private boolean _popupEnabled;
        private boolean _popupOnlyWithoutHint;

        public void setColor(boolean foregound, int pairIdx, RGB color) {
            if (foregound) {
                this._fgColors[pairIdx] = color;
            } else {
                this._bgColors[pairIdx] = color;
            }
        }

        public void setHighlightType(int pairIdx, String highlightType) {
            this._highlightTypes[pairIdx] = highlightType;
        }

        public void setEnableSurrounding(boolean enable) {
            this._surroundingPairsEnable = enable;
        }

        public void setEnableHovering(boolean enable) {
            this._hoveredPairsEnable = enable;
        }

        public void setSurroundingPairsCount(int count) {
            this._surroundingPairsCount = count;
        }

        public void setSurroundingPairsToInclude(String pairs) {
            this._surroundingPairsToInclude = pairs;
        }

        public void setMinDistanceBetweenBrackets(int distance) {
            this._minDistanceBetweenBrackets = distance;
        }

        public void setEnablePopup(boolean enable) {
            this._popupEnabled = enable;
        }

        public void setPopupOnlyWithoutHint(boolean enable) {
            this._popupOnlyWithoutHint = enable;
        }

        public RGB getColor(boolean foregound, int colorIndex) {
            if (foregound) {
                return this._fgColors[colorIndex];
            }
            return this._bgColors[colorIndex];
        }

        public String getHighlightType(int pairIdx) {
            return this._highlightTypes[pairIdx];
        }

        public boolean isSurroundingPairsEnabled() {
            return this._surroundingPairsEnable;
        }

        public int getSurroundingPairsCount() {
            return this._surroundingPairsCount;
        }

        public String getSurroundingPairsToInclude() {
            return this._surroundingPairsToInclude;
        }

        public boolean isHoveredPairsEnabled() {
            return this._hoveredPairsEnable;
        }

        public int getMinDistanceBetweenBrackets() {
            return this._minDistanceBetweenBrackets;
        }

        public boolean isPopupEnabled() {
            return this._popupEnabled;
        }

        public boolean showPopupOnlyWithoutHint() {
            return this._popupOnlyWithoutHint;
        }
    }

    public class SingleBracketConfiguration {
        private RGB _fgColor;
        private RGB _bgColor;
        private String _highlightType;
        private boolean _annotate;

        public void setColor(boolean foregound, RGB color) {
            if (foregound) {
                this._fgColor = color;
            } else {
                this._bgColor = color;
            }
        }

        public void setHighlightType(String highlightType) {
            this._highlightType = highlightType;
        }

        public void setAnnotate(boolean enable) {
            this._annotate = enable;
        }

        public RGB getColor(boolean foregound) {
            if (foregound) {
                return this._fgColor;
            }
            return this._bgColor;
        }

        public String getHighlightType() {
            return this._highlightType;
        }

        public boolean getAnnotate() {
            return this._annotate;
        }
    }
}

