/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.core;

import com.chookapp.org.bracketeer.core.PaintableBracket;
import com.chookapp.org.bracketeer.core.TextUtils;
import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.services.IDisposable;

public class Popup
implements IDisposable,
PaintListener {
    private Shell _shell;
    private SourceViewer _sourceViewer;
    private PaintableBracket _bracketToPaint = null;

    public Popup(ISourceViewer parentSv, StyledText parentSt, IDocument origDoc, PaintableBracket paintBracket) throws BadLocationException {
        this._shell = new Shell(parentSt.getShell(), 540676);
        this._shell.setLayout((Layout)new FillLayout());
        Composite inner = new Composite((Composite)this._shell, 0);
        inner.setLayout((Layout)new FillLayout());
        this._sourceViewer = new SourceViewer(inner, null, null, false, 2);
        this._sourceViewer.setEditable(false);
        StyledText textWidget = this._sourceViewer.getTextWidget();
        textWidget.setFont(parentSt.getFont());
        textWidget.setTabs(parentSt.getTabs());
        textWidget.setForeground(parentSt.getForeground());
        textWidget.setBackground(parentSt.getBackground());
        textWidget.addPaintListener((PaintListener)this);
        GC gc = new GC((Drawable)textWidget);
        int popupHight = 70;
        try {
            popupHight = gc.getFontMetrics().getHeight() * 3;
        }
        finally {
            gc.dispose();
        }
        try {
            this.updatePopupContent(this._sourceViewer, parentSv, parentSt, origDoc, paintBracket);
        }
        catch (BadLocationException e) {
            this.dispose();
            throw e;
        }
        Point txtSize = new Point(parentSt.getSize().x, popupHight);
        this._shell.setSize(txtSize);
        Point parentLocation = parentSt.getDisplay().map((Control)parentSt, null, 0, 0);
        this._shell.setLocation(parentLocation.x, parentLocation.y - txtSize.y);
        this._shell.setVisible(true);
    }

    private void updatePopupContent(SourceViewer sv, ISourceViewer parentSv, StyledText parentSt, IDocument origDoc, PaintableBracket paintBracket) throws BadLocationException {
        Document newDoc = new Document();
        sv.setInput((Object)newDoc);
        String txt = "";
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        Position origPos = paintBracket.getPosition();
        Integer[] lines = new Integer[3];
        lines[1] = origDoc.getLineOfOffset(origPos.getOffset());
        lines[0] = this.getLineBefore(origDoc, lines[1]);
        lines[2] = this.getLineAfter(origDoc, lines[1]);
        int i = 0;
        while (i < 3) {
            if (lines[i] != null) {
                StyleRange[] ranges;
                int line = lines[i];
                if (!txt.isEmpty()) {
                    txt = String.valueOf(txt) + "\r\n";
                }
                int newDocOffset = txt.length();
                IRegion region = origDoc.getLineInformation(line);
                txt = String.valueOf(txt) + origDoc.get(region.getOffset(), region.getLength());
                if (i == 1) {
                    Position newPos = new Position(origPos.getOffset() - region.getOffset() + newDocOffset, 1);
                    this._bracketToPaint = paintBracket.clone(newPos);
                }
                region = TextUtils.getWidgetRange(parentSv, region.getOffset(), region.getLength());
                StyleRange[] styleRangeArray = ranges = parentSt.getStyleRanges(region.getOffset(), region.getLength());
                int n = ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    StyleRange styleRange = styleRangeArray[n2];
                    styleRange.start = newDocOffset;
                    newDocOffset += styleRange.length;
                    styleRanges.add(styleRange);
                    ++n2;
                }
            }
            ++i;
        }
        sv.getDocument().set(txt);
        sv.setDocument((IDocument)newDoc);
        StyleRange[] stArray = new StyleRange[styleRanges.size()];
        styleRanges.toArray(stArray);
        sv.getTextWidget().setStyleRanges(stArray);
    }

    private Integer getLineBefore(IDocument origDoc, int startFromLine) throws BadLocationException {
        int line = startFromLine - 1;
        while (line >= 0) {
            IRegion region = origDoc.getLineInformation(line);
            String txt = origDoc.get(region.getOffset(), region.getLength());
            if (!txt.trim().isEmpty()) {
                return line;
            }
            --line;
        }
        return null;
    }

    private Integer getLineAfter(IDocument origDoc, int startFromLine) throws BadLocationException {
        int linesCount = origDoc.getNumberOfLines();
        int line = startFromLine + 1;
        while (line < linesCount) {
            IRegion region = origDoc.getLineInformation(line);
            String txt = origDoc.get(region.getOffset(), region.getLength());
            if (!txt.trim().isEmpty()) {
                return line;
            }
            ++line;
        }
        return null;
    }

    public void dispose() {
        this._shell.close();
        this._shell.dispose();
    }

    public void paintControl(PaintEvent event) {
        if (this._bracketToPaint == null) {
            return;
        }
        this._bracketToPaint.paint(event.gc, this._sourceViewer.getTextWidget(), this._sourceViewer.getDocument(), (IRegion)new Region(this._bracketToPaint.getPosition().getOffset(), this._bracketToPaint.getPosition().getLength()), null);
    }
}

