/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.core;

import com.chookapp.org.bracketeer.Activator;
import com.chookapp.org.bracketeer.core.BracketeerProcessorInfo;
import com.chookapp.org.bracketeer.core.BracketsHighlighter;
import com.chookapp.org.bracketeer.core.IActiveProcessorListener;
import com.chookapp.org.bracketeer.core.Messages;
import com.chookapp.org.bracketeer.core.ProcessorsRegistry;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PartListener
implements IWindowListener,
IPartListener2 {
    private static PartListener sInstance = new PartListener();
    private Collection<IWorkbenchWindow> fWindows = new HashSet<IWorkbenchWindow>();
    private HashMap<IWorkbenchPart, BracketsHighlighter> _activeMap = new HashMap();
    private ProcessorsRegistry _processorsRegistry;
    private List<IActiveProcessorListener> m_listeners = new LinkedList<IActiveProcessorListener>();

    PartListener() {
        this._processorsRegistry = new ProcessorsRegistry();
    }

    public static PartListener getInstance() {
        return sInstance;
    }

    public void install() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            Activator.log(Messages.PartListener_ErrWorkbanch);
            return;
        }
        ISourceProviderService srcService = (ISourceProviderService)workbench.getService(ISourceProviderService.class);
        ISourceProvider src = srcService.getSourceProvider("com.chookapp.org.bracketeer.pluginName");
        this.m_listeners.add((IActiveProcessorListener)src);
        workbench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] wnds = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < wnds.length) {
            IWorkbenchWindow window = wnds[i];
            this.register(window);
            ++i;
        }
    }

    public void uninstall() {
        for (IWorkbenchWindow window : this.fWindows) {
            this.unregister(window);
        }
    }

    private void register(IWorkbenchWindow wnd) {
        IWorkbenchPage page;
        IWorkbenchPage[] pages;
        wnd.getPartService().addPartListener((IPartListener2)this);
        this.fWindows.add(wnd);
        IWorkbenchPage[] iWorkbenchPageArray = pages = wnd.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] editorRefs;
            page = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
            int n3 = editorRefs.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference editorRef = iEditorReferenceArray[n4];
                this.partActivated((IWorkbenchPartReference)editorRef);
                ++n4;
            }
            ++n2;
        }
        page = wnd.getActivePage();
        if (page != null) {
            this.activated(page.getActivePartReference());
        }
    }

    private void unregister(IWorkbenchWindow wnd) {
        wnd.getPartService().removePartListener((IPartListener2)this);
        this.fWindows.remove(wnd);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.register(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.unregister(window);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.created(partRef);
        this.activated(partRef);
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        this.destroyed(partRef);
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        this.deactivated(partRef);
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.created(partRef);
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
        this.destroyed(partRef);
        this.created(partRef);
    }

    private void created(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        try {
            if (!(part instanceof IEditorPart)) {
                return;
            }
            IEditorPart editorPart = (IEditorPart)part;
            ITextViewer viewer = PartListener.callGetSourceViewer(editorPart);
            if (viewer == null) {
                return;
            }
            this.hook(editorPart, viewer);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void destroyed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        try {
            if (!(part instanceof IEditorPart)) {
                return;
            }
            this.unhook(part);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activated(IWorkbenchPartReference partRef) {
        BracketsHighlighter bracketsHighlighter;
        if (partRef == null) {
            this.deactivated(partRef);
            return;
        }
        IWorkbenchPart part = partRef.getPart(false);
        if (part == null) {
            this.deactivated(partRef);
            return;
        }
        HashMap<IWorkbenchPart, BracketsHighlighter> hashMap = this._activeMap;
        synchronized (hashMap) {
            bracketsHighlighter = this._activeMap.get(part);
        }
        if (bracketsHighlighter == null) {
            this.deactivated(partRef);
            return;
        }
        String name = bracketsHighlighter.getConfiguration().getName();
        for (IActiveProcessorListener listener : this.m_listeners) {
            listener.activeProcessorChanged(name);
        }
    }

    private void deactivated(IWorkbenchPartReference partRef) {
        for (IActiveProcessorListener listener : this.m_listeners) {
            listener.activeProcessorChanged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hook(IEditorPart part, ITextViewer textViewer) {
        IDocument doc;
        BracketsHighlighter oldBracketsHighlighter;
        if (textViewer == null) {
            return;
        }
        HashMap<IWorkbenchPart, BracketsHighlighter> hashMap = this._activeMap;
        synchronized (hashMap) {
            oldBracketsHighlighter = this._activeMap.get(part);
        }
        if (oldBracketsHighlighter != null) {
            if (oldBracketsHighlighter.getTextViewer() != textViewer) {
                Activator.log("Part viewer changed");
                this.unhook((IWorkbenchPart)part);
            } else {
                return;
            }
        }
        if ((doc = PartListener.getPartDocument(part)) == null) {
            return;
        }
        BracketeerProcessorInfo processor = null;
        try {
            processor = this._processorsRegistry.findProcessorFor(part, doc);
        }
        catch (RuntimeException e) {
            Activator.log(e);
            return;
        }
        if (processor == null) {
            return;
        }
        BracketsHighlighter bracketsHighlighter = new BracketsHighlighter();
        bracketsHighlighter.Init(processor.getProcessor(), part, doc, textViewer, processor.getConfiguration());
        HashMap<IWorkbenchPart, BracketsHighlighter> hashMap2 = this._activeMap;
        synchronized (hashMap2) {
            this._activeMap.put((IWorkbenchPart)part, bracketsHighlighter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unhook(IWorkbenchPart part) {
        HashMap<IWorkbenchPart, BracketsHighlighter> hashMap = this._activeMap;
        synchronized (hashMap) {
            BracketsHighlighter oldBracketsHighlighter = this._activeMap.get(part);
            if (oldBracketsHighlighter == null) {
                return;
            }
            oldBracketsHighlighter.dispose();
            this._activeMap.remove(part);
        }
    }

    private static IDocument getPartDocument(IEditorPart part) {
        IDocumentProvider provider;
        ITextEditor editor = (ITextEditor)part.getAdapter(ITextEditor.class);
        IDocument document = null;
        if (editor != null && (provider = editor.getDocumentProvider()) != null) {
            document = provider.getDocument((Object)editor.getEditorInput());
        }
        return document;
    }

    private static ITextViewer callGetSourceViewer(IEditorPart editor) {
        if (editor == null || !(editor instanceof AbstractTextEditor)) {
            return null;
        }
        try {
            Method method = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            method.setAccessible(true);
            return (ITextViewer)method.invoke((Object)editor, new Object[0]);
        }
        catch (Exception e) {
            Activator.log(e);
            return null;
        }
    }
}

