/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.core;

import com.chookapp.org.bracketeer.core.PaintableObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class PaintableBracket
extends PaintableObject {
    private String _highlightType;
    private RGB _outlineColor;

    public PaintableBracket(Position position, RGB foreground, RGB background, String highlightType) {
        super(position, foreground, (RGB)(highlightType.equals("Solid") ? background : null));
        this._highlightType = highlightType;
        this._outlineColor = background;
    }

    @Override
    protected void innerPaint(GC gc, StyledText st, IDocument doc, IRegion widgetRange, Rectangle widgetRect) {
        int offset = widgetRange.getOffset();
        int length = widgetRange.getLength();
        if (length != 1) {
            throw new IllegalArgumentException(String.format("length %1$d != 1", length));
        }
        Point p = st.getLocationAtOffset(offset);
        String txt = null;
        try {
            txt = doc.get(this._position.getOffset(), 1);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        gc.drawText(txt, p.x, p.y, this._background == null);
        if (this._highlightType.equals("Outline")) {
            Color oldFg = gc.getForeground();
            Color fg = null;
            if (this._outlineColor == null) {
                gc.setForeground(gc.getBackground());
            } else {
                fg = new Color((Device)Display.getDefault(), this._outlineColor);
                gc.setForeground(fg);
            }
            Point metrics = gc.textExtent(txt);
            Rectangle rect = new Rectangle(p.x, p.y, metrics.x - 1, metrics.y - 1);
            gc.drawRectangle(rect);
            gc.setForeground(oldFg);
            if (fg != null) {
                fg.dispose();
            }
        }
    }

    public PaintableBracket clone(Position newPos) {
        PaintableBracket ret = new PaintableBracket(newPos, this._foreground, this._background, this._highlightType);
        ret._outlineColor = this._outlineColor;
        return ret;
    }
}

