/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.core;

import com.chookapp.org.bracketeer.Activator;
import com.chookapp.org.bracketeer.common.BracketsPair;
import com.chookapp.org.bracketeer.common.Hint;
import com.chookapp.org.bracketeer.common.SingleBracket;
import com.chookapp.org.bracketeer.core.BracketeerProcessingContainer;
import com.chookapp.org.bracketeer.core.IProcessingContainerListener;
import com.chookapp.org.bracketeer.core.IProcessorConfigurationListener;
import com.chookapp.org.bracketeer.core.Messages;
import com.chookapp.org.bracketeer.core.PaintableBracket;
import com.chookapp.org.bracketeer.core.PaintableHint;
import com.chookapp.org.bracketeer.core.PaintableObject;
import com.chookapp.org.bracketeer.core.Popup;
import com.chookapp.org.bracketeer.core.ProcessingThread;
import com.chookapp.org.bracketeer.core.ProcessorConfiguration;
import com.chookapp.org.bracketeer.core.TextUtils;
import com.chookapp.org.bracketeer.extensionpoint.BracketeerProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class BracketsHighlighter
implements CaretListener,
Listener,
PaintListener,
IDisposable,
IPainter,
IProcessingContainerListener,
IProcessorConfigurationListener,
FocusListener {
    private ISourceViewer _sourceViewer = null;
    private StyledText _textWidget = null;
    private ProcessingThread _processingThread = null;
    private IDocument _doc = null;
    private ProcessorConfiguration _conf = null;
    private IResource _resource = null;
    private IAnnotationModel _annotationModel = null;
    private Map<Annotation, Position> _annotationMap = new HashMap<Annotation, Position>();
    private boolean _isActive = false;
    private List<PaintableBracket> _hoveredPairsToPaint = new LinkedList<PaintableBracket>();
    private List<PaintableBracket> _surroundingPairsToPaint = new LinkedList<PaintableBracket>();
    private List<PaintableBracket> _singleBracketsToPaint = new LinkedList<PaintableBracket>();
    private List<PaintableHint> _hintsToPaint = new ArrayList<PaintableHint>();
    private PaintableHint _hoveredHintToPaint = null;
    private Point m_hoverEntryPoint = null;
    private Popup _popup = null;
    private PaintableHint _mousePointingAtHint = null;
    private SingleBracket _mousePointingAtBracket = null;
    private boolean _mousePointerHand = false;
    private int _caretOffset;
    private int m_hyperlinkModifiers;

    public void dispose() {
        this.clearPopup();
        if (this._sourceViewer == null) {
            return;
        }
        this._conf.removeListener(this);
        this.deactivate(false);
        ITextViewerExtension2 extension = (ITextViewerExtension2)this._sourceViewer;
        extension.removePainter((IPainter)this);
        if (this._processingThread != null) {
            this._processingThread.getBracketContainer().removeListener(this);
            this._processingThread.dispose();
            this._processingThread = null;
        }
        this._sourceViewer = null;
        this._textWidget = null;
    }

    public void Init(BracketeerProcessor processor, IEditorPart part, IDocument doc, ITextViewer textViewer, ProcessorConfiguration conf) {
        ITextEditor editor;
        this._sourceViewer = (ISourceViewer)textViewer;
        this._textWidget = this._sourceViewer.getTextWidget();
        this._conf = conf;
        processor.setHintConf(conf.getHintConfiguration());
        this._doc = doc;
        boolean editable = this._textWidget.getEditable();
        this._resource = (IResource)part.getEditorInput().getAdapter(IResource.class);
        if (this._resource == null && editable) {
            Activator.log(Messages.BracketsHighlighter_UnableToGetResource);
        }
        if ((editor = (ITextEditor)part.getAdapter(ITextEditor.class)) == null) {
            Activator.log(Messages.BracketsHighlighter_UnableToGetEditor);
        } else {
            IDocumentProvider provider = editor.getDocumentProvider();
            this._annotationModel = provider.getAnnotationModel((Object)editor.getEditorInput());
        }
        this._processingThread = new ProcessingThread(doc, processor);
        this._processingThread.getBracketContainer().addListener(this);
        this._conf.addListener(this);
        ITextViewerExtension2 extension = (ITextViewerExtension2)textViewer;
        extension.addPainter((IPainter)this);
        this.m_hyperlinkModifiers = this._conf.getGeneralConfiguration().getHyperlinkModifiers();
    }

    public ISourceViewer getSourceViewer() {
        return this._sourceViewer;
    }

    public ProcessorConfiguration getConfiguration() {
        return this._conf;
    }

    public void caretMoved(CaretEvent event) {
        this._caretOffset = this.getCurrentCaretOffset();
        this.caretMovedTo(this._caretOffset);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 32: {
                if ((event.stateMask & SWT.MODIFIER_MASK) == this.m_hyperlinkModifiers) {
                    return;
                }
                try {
                    int caret = this.getDocCarretAdvanced(null, event.x, event.y);
                    if (!this.mouseHoverAt(this._textWidget, caret)) break;
                    this.m_hoverEntryPoint = new Point(event.x, event.y);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (Exception e) {
                    Activator.log(e);
                }
                break;
            }
            case 5: {
                if ((event.stateMask & SWT.MODIFIER_MASK) == this.m_hyperlinkModifiers && this._textWidget.isFocusControl()) {
                    this.mousePointingAt(event.x, event.y);
                    this.updateMousePointer();
                }
                if (this.m_hoverEntryPoint == null || this.getDistanceBetween(new Point(event.x, event.y), this.m_hoverEntryPoint) <= 20) break;
                this.caretMovedTo(this.getCurrentCaretOffset());
                this.m_hoverEntryPoint = null;
                break;
            }
            case 3: {
                if (this._mousePointingAtHint != null) {
                    Hint hint = this._processingThread.getBracketContainer().getHint(this._mousePointingAtHint.getPosition().getOffset());
                    if (hint == null) {
                        Activator.log(Messages.BracketsHighlighter_ErrHintNotFound);
                        break;
                    }
                    this.jumpToPosition(hint.getOriginPosition());
                }
                if (this._mousePointingAtBracket == null) break;
                List<BracketsPair> pairs = this._processingThread.getBracketContainer().getMatchingPairs(this._mousePointingAtBracket.getPosition().getOffset(), 1);
                if (pairs.size() == 0 || pairs.size() > 1) {
                    Activator.log(Messages.BracketsHighlighter_ErrPairNotFound);
                    break;
                }
                BracketsPair pair = pairs.get(0);
                Position pos = null;
                if (pair.getOpeningBracket().equals(this._mousePointingAtBracket)) {
                    pos = pair.getClosingBracket().getPosition();
                }
                if (pair.getClosingBracket().equals(this._mousePointingAtBracket)) {
                    pos = pair.getOpeningBracket().getPosition();
                }
                this.jumpToPosition(pos);
                break;
            }
            case 1: {
                if ((event.keyCode | event.stateMask) == this.m_hyperlinkModifiers) {
                    if (this.m_hoverEntryPoint != null) {
                        this.caretMovedTo(this.getCurrentCaretOffset());
                        this.m_hoverEntryPoint = null;
                    }
                    Display display = this._textWidget.getDisplay();
                    Point point = display.getCursorLocation();
                    point = display.map(null, (Control)this._textWidget, point);
                    this.mousePointingAt(point.x, point.y);
                    this.updateMousePointer();
                    break;
                }
                this.clearHyperlink();
                this.updateMousePointer();
                break;
            }
            case 2: {
                if ((event.keyCode & this.m_hyperlinkModifiers) <= 0) break;
                this.clearHyperlink();
                this.updateMousePointer();
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)(String.valueOf(Messages.BracketsHighlighter_ErrUnexpectedEvent) + event.type));
            }
        }
    }

    private int getDocCarretAdvanced(GC outerGc, int x, int y) {
        int caret;
        block13: {
            caret = -1;
            GC gc = null;
            gc = outerGc == null ? new GC((Drawable)this._textWidget) : outerGc;
            try {
                try {
                    int charWidth = gc.getFontMetrics().getAverageCharWidth();
                    caret = this._textWidget.getOffsetAtLocation(new Point(x + charWidth / 2, y));
                    caret = ((ProjectionViewer)this._sourceViewer).widgetOffset2ModelOffset(caret);
                    if (caret > 0) {
                        --caret;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    caret = -1;
                    if (outerGc == null) {
                        gc.dispose();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (outerGc == null) {
                    gc.dispose();
                }
                throw throwable;
            }
            if (outerGc == null) {
                gc.dispose();
            }
        }
        if (caret == -1) {
            try {
                caret = this._textWidget.getOffsetAtLocation(new Point(x, y));
                caret = ((ProjectionViewer)this._sourceViewer).widgetOffset2ModelOffset(caret);
                if (caret > 0) {
                    --caret;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                caret = -1;
            }
        }
        return caret;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.clearHyperlink();
        this.updateMousePointer();
    }

    /*
     * WARNING - void declaration
     */
    public void paintControl(PaintEvent event) {
        try {
            boolean bl;
            void var5_14;
            IRegion region = this.computeClippingRegion(event);
            if (region == null) {
                return;
            }
            int startOfset = region.getOffset();
            int length = region.getLength();
            for (PaintableObject paintableObject : this._singleBracketsToPaint) {
                if (!paintableObject.getPosition().overlapsWith(startOfset, length)) continue;
                paintableObject.paint(event.gc, this._textWidget, this._sourceViewer.getDocument(), this.getWidgetRange(paintableObject.getPosition().getOffset(), paintableObject.getPosition().getLength()), null);
            }
            if (this._hoveredPairsToPaint.isEmpty()) {
                List<PaintableBracket> list = this._surroundingPairsToPaint;
            } else {
                List<PaintableBracket> list = this._hoveredPairsToPaint;
            }
            for (PaintableObject paintableObject : var5_14) {
                if (!paintableObject.getPosition().overlapsWith(startOfset, length)) continue;
                paintableObject.paint(event.gc, this._textWidget, this._sourceViewer.getDocument(), this.getWidgetRange(paintableObject.getPosition().getOffset(), paintableObject.getPosition().getLength()), null);
            }
            boolean bl2 = false;
            for (PaintableHint paintObj : this._hintsToPaint) {
                if (this._hoveredHintToPaint != null && this._hoveredHintToPaint.getPosition().equals((Object)paintObj.getPosition())) {
                    paintObj = this._hoveredHintToPaint;
                    bl = true;
                }
                this.paintHint(paintObj, event);
            }
            if (!bl && this._hoveredHintToPaint != null) {
                this.paintHint(this._hoveredHintToPaint, event);
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    private void paintHint(PaintableHint paintObj, PaintEvent event) {
        IRegion widgetRange = this.getWidgetRange(paintObj.getPosition().getOffset(), paintObj.getPosition().getLength());
        Rectangle widgetRect = paintObj.getWidgetRect(event.gc, this._textWidget, this._sourceViewer.getDocument(), widgetRange);
        if (widgetRect != null && widgetRect.intersects(event.x, event.y, event.width, event.height)) {
            paintObj.paint(event.gc, this._textWidget, this._sourceViewer.getDocument(), widgetRange, widgetRect);
        }
    }

    public ITextViewer getTextViewer() {
        return this._sourceViewer;
    }

    @Override
    public void configurationUpdated() {
        this.m_hyperlinkModifiers = this._conf.getGeneralConfiguration().getHyperlinkModifiers();
        boolean updated = false;
        updated |= this.clearSurroundingPairsToPaint();
        this.rebuild(true, true, true, updated |= this.clearSingleBracketsToPaint());
    }

    @Override
    public void containerUpdated(boolean bracketsPairsTouched, boolean singleBracketsTouched, boolean hintsTouched) {
        this.rebuild(bracketsPairsTouched, singleBracketsTouched, hintsTouched, false);
    }

    public void paint(int reason) {
        if (!this._isActive) {
            if (this._sourceViewer == null) {
                Activator.log(Messages.BracketsHighlighter_UnableToPaint_SourceViewer);
                return;
            }
            this._isActive = true;
            StyledText st = this._sourceViewer.getTextWidget();
            st.addCaretListener((CaretListener)this);
            st.addListener(32, (Listener)this);
            st.addListener(5, (Listener)this);
            st.addListener(3, (Listener)this);
            st.addListener(1, (Listener)this);
            st.addListener(2, (Listener)this);
            st.addPaintListener((PaintListener)this);
            st.addFocusListener((FocusListener)this);
            this._caretOffset = this.getCurrentCaretOffset();
        }
    }

    public void deactivate(boolean redraw) {
        if (!this._isActive) {
            return;
        }
        this._isActive = false;
        if (this._sourceViewer == null) {
            return;
        }
        StyledText st = this._sourceViewer.getTextWidget();
        if (st == null) {
            return;
        }
        st.removeCaretListener((CaretListener)this);
        st.removeListener(32, (Listener)this);
        st.removeListener(5, (Listener)this);
        st.removeListener(3, (Listener)this);
        st.removeListener(1, (Listener)this);
        st.removeListener(2, (Listener)this);
        st.removePaintListener((PaintListener)this);
        st.removeFocusListener((FocusListener)this);
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }

    private void rebuild(boolean bracketsPairsTouched, boolean singleBracketsTouched, boolean hintsTouched, boolean alwaysRedraw) {
        boolean update = alwaysRedraw;
        if (bracketsPairsTouched) {
            update |= this.updateSurroundingPairsToPaint(this._caretOffset);
            update |= this.clearHoveredPairsToPaint();
        }
        if (singleBracketsTouched) {
            update |= this.updateSingleBrackets();
        }
        update |= this.updateHints();
        if (update |= this.clearHoveredHint()) {
            this._textWidget.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (BracketsHighlighter.this._textWidget != null) {
                        BracketsHighlighter.this._textWidget.redraw();
                    }
                }
            });
        }
    }

    private void updateMousePointer() {
        if (this._mousePointingAtHint != null || this._mousePointingAtBracket != null) {
            if (this._mousePointerHand) {
                return;
            }
            this._textWidget.setCursor(this._textWidget.getDisplay().getSystemCursor(21));
            this._mousePointerHand = true;
        } else {
            if (!this._mousePointerHand) {
                return;
            }
            this._textWidget.setCursor(null);
            this._mousePointerHand = false;
        }
    }

    private void clearHyperlink() {
        if (this._mousePointingAtHint != null) {
            this._mousePointingAtHint.setUnderline(false);
            this._textWidget.redraw();
            this._mousePointingAtHint = null;
        }
        if (this._mousePointingAtBracket != null) {
            this.clearHoveredPairsToPaint();
            this._textWidget.redraw();
            this._mousePointingAtBracket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mousePointingAt(int x, int y) {
        int caret = -1;
        GC gc = new GC((Drawable)this._textWidget);
        try {
            caret = this.getDocCarretAdvanced(gc, x, y);
            if (this._mousePointingAtBracket != null) {
                Position pos = this._mousePointingAtBracket.getPosition();
                if (pos != null && pos.getOffset() == caret) {
                    return;
                }
                this._mousePointingAtBracket = null;
                this.clearHoveredPairsToPaint();
                this.clearHoveredHint();
                this.clearPopup();
                this._textWidget.redraw();
            }
            if (this._mousePointingAtHint != null) {
                IRegion widgetRange = this.getWidgetRange(this._mousePointingAtHint.getPosition().getOffset(), this._mousePointingAtHint.getPosition().getLength());
                Rectangle rect = this._mousePointingAtHint.getWidgetRect(gc, this._textWidget, this._sourceViewer.getDocument(), widgetRange);
                if (rect != null && rect.intersects(x, y, 1, 1)) {
                    return;
                }
                this._mousePointingAtHint.setUnderline(false);
                this._textWidget.redraw();
                this._mousePointingAtHint = null;
            }
            for (PaintableHint paintObj : this._hintsToPaint) {
                IRegion widgetRange = this.getWidgetRange(paintObj.getPosition().getOffset(), paintObj.getPosition().getLength());
                Rectangle rect = paintObj.getWidgetRect(gc, this._textWidget, this._sourceViewer.getDocument(), widgetRange);
                if (rect == null || !rect.intersects(x, y, 1, 1)) continue;
                this._mousePointingAtHint = paintObj;
                this._mousePointingAtHint.setUnderline(true);
                this._textWidget.redraw(rect.x, rect.y, rect.width, rect.height, true);
                return;
            }
        }
        finally {
            gc.dispose();
        }
        BracketeerProcessingContainer cont = this._processingThread.getBracketContainer();
        List<BracketsPair> pairs = cont.getMatchingPairs(caret, 1);
        Assert.isTrue((pairs.size() <= 1 ? 1 : 0) != 0);
        if (pairs.size() == 0) {
            return;
        }
        BracketsPair pair = pairs.get(0);
        Position pos = pair.getOpeningBracket().getPosition();
        if (pos != null && pos.getOffset() == caret) {
            this._mousePointingAtBracket = pair.getOpeningBracket();
        }
        if ((pos = pair.getClosingBracket().getPosition()) != null && pos.getOffset() == caret) {
            this._mousePointingAtBracket = pair.getClosingBracket();
        }
        if (this._mousePointingAtBracket == null) {
            Activator.log(Messages.BracketsHighlighter_ErrBracketNotFound);
            return;
        }
        List<PaintableBracket> list = this._hoveredPairsToPaint;
        synchronized (list) {
            this.addPaintableObjectsPairs(pairs, 0, 1, this._hoveredPairsToPaint);
        }
        this._textWidget.redraw();
    }

    private void jumpToPosition(Position pos) {
        if (pos == null) {
            return;
        }
        this._sourceViewer.setSelectedRange(pos.getOffset(), 0);
        this._sourceViewer.revealRange(pos.getOffset(), 0);
    }

    private void caretMovedTo(int caretOffset) {
        boolean update = this.updateSurroundingPairsToPaint(caretOffset);
        update |= this.clearHoveredPairsToPaint();
        this.clearPopup();
        if (update |= this.clearHoveredHint()) {
            this._textWidget.redraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSurroundingPairsToPaint(int caretOffset) {
        if (!this._conf.getPairConfiguration().isSurroundingPairsEnabled()) {
            return this.clearSurroundingPairsToPaint();
        }
        BracketeerProcessingContainer cont = this._processingThread.getBracketContainer();
        List<BracketsPair> listOfPairs = cont.getPairsSurrounding(caretOffset);
        String includedPairs = this._conf.getPairConfiguration().getSurroundingPairsToInclude();
        Iterator<BracketsPair> it = listOfPairs.iterator();
        while (it.hasNext()) {
            BracketsPair pair = it.next();
            for (SingleBracket br : pair.getBrackets()) {
                if (includedPairs.indexOf(br.getChar()) != -1) continue;
                it.remove();
                break;
            }
            if (pair.getDistanceBetweenBrackets() - 1 >= this._conf.getPairConfiguration().getMinDistanceBetweenBrackets()) continue;
            it.remove();
        }
        listOfPairs = this.sortPairs(listOfPairs);
        if (this.areEqualPairs(listOfPairs = listOfPairs.subList(0, Math.min(this._conf.getPairConfiguration().getSurroundingPairsCount(), listOfPairs.size())), this._surroundingPairsToPaint)) {
            return false;
        }
        this.clearSurroundingPairsToPaint();
        List<PaintableBracket> list = this._surroundingPairsToPaint;
        synchronized (list) {
            this.addPaintableObjectsPairs(listOfPairs, 0, 1, this._surroundingPairsToPaint);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSingleBrackets() {
        BracketeerProcessingContainer cont = this._processingThread.getBracketContainer();
        List<SingleBracket> list = cont.getSingleBrackets();
        if (this.areEqualSingle(list, this._singleBracketsToPaint)) {
            return false;
        }
        this.clearSingleBracketsToPaint();
        List<PaintableBracket> list2 = this._singleBracketsToPaint;
        synchronized (list2) {
            this.addPaintableObjectsSingles(list, this._singleBracketsToPaint);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateHints() {
        BracketeerProcessingContainer cont = this._processingThread.getBracketContainer();
        ArrayList<PaintableHint> hintsToPaint = new ArrayList<PaintableHint>();
        ProcessorConfiguration.HintConfiguration conf = this._conf.getHintConfiguration();
        IDocument doc = this._doc;
        for (Hint hint : cont.getHints()) {
            int drawLine;
            int originLine;
            String type = hint.getType();
            if (!this._conf.getHintConfiguration().isShowInEditor(type)) continue;
            try {
                originLine = doc.getLineOfOffset(hint.getOriginPositionRaw().getOffset());
                drawLine = doc.getLineOfOffset(hint.getHintPositionRaw().getOffset());
            }
            catch (BadLocationException badLocationException) {
                continue;
            }
            if (drawLine - originLine < conf.getMinLineDistance(type)) continue;
            PaintableHint pHint = new PaintableHint(hint.getHintPositionRaw(), conf.getColor(type, true), conf.getColor(type, false), conf.isItalic(type), conf.formatText(type, hint.getTxt()));
            hintsToPaint.add(pHint);
        }
        if (this._hintsToPaint.equals(hintsToPaint)) {
            return false;
        }
        List<PaintableHint> list = this._hintsToPaint;
        synchronized (list) {
            this._hintsToPaint = hintsToPaint;
        }
        return true;
    }

    private List<BracketsPair> sortPairs(List<BracketsPair> listOfPairs) {
        ArrayList<BracketsPair> ret = new ArrayList<BracketsPair>(listOfPairs.size());
        for (BracketsPair pair : listOfPairs) {
            int i = 0;
            while (i < ret.size()) {
                if (((BracketsPair)ret.get((int)i)).getOpeningBracket().getPositionRaw().offset < pair.getOpeningBracket().getPositionRaw().offset) break;
                ++i;
            }
            ret.add(i, pair);
        }
        return ret;
    }

    private boolean mouseHoverAt(StyledText st, int origCaret) {
        boolean ret = this.markHoveredBrackets(origCaret);
        ret |= this.showHoveredHint(origCaret);
        return ret |= this.showPopup(origCaret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showPopup(int origCaret) {
        this.clearPopup();
        if (!this._conf.getPairConfiguration().isPopupEnabled()) {
            return false;
        }
        try {
            if (this._conf.getPairConfiguration().showPopupOnlyWithoutHint() && this._hoveredHintToPaint != null && this._hoveredHintToPaint.isOkToShow(this._doc)) {
                return false;
            }
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        BracketeerProcessingContainer cont = this._processingThread.getBracketContainer();
        List<BracketsPair> listOfPairs = cont.getMatchingPairs(origCaret, 1);
        if (listOfPairs.isEmpty()) {
            return false;
        }
        BracketsPair pair = listOfPairs.get(0);
        Position pos = pair.getClosingBracket().getPosition();
        if (pos == null || !pos.overlapsWith(origCaret, 2)) {
            return false;
        }
        if (pair.getClosingBracket().getChar() != '}') {
            return false;
        }
        pos = pair.getOpeningBracket().getPosition();
        if (pos == null) {
            return false;
        }
        if (this.getInclusiveTopIndexStartOffset() < pos.getOffset()) {
            return false;
        }
        PaintableBracket paintBracket = null;
        List<PaintableBracket> list = this._hoveredPairsToPaint;
        synchronized (list) {
            for (PaintableBracket paintableBracket : this._hoveredPairsToPaint) {
                if (!paintableBracket.getPosition().equals((Object)pos)) continue;
                paintBracket = paintableBracket;
                break;
            }
        }
        if (paintBracket == null) {
            Activator.log(Messages.BracketsHighlighter_MatchNotHighlighetd);
            return false;
        }
        try {
            this._popup = new Popup(this._sourceViewer, this._textWidget, this._doc, paintBracket);
        }
        catch (BadLocationException badLocationException) {
            this._popup = null;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean markHoveredBrackets(int origCaret) {
        if (!this._conf.getPairConfiguration().isHoveredPairsEnabled()) {
            return false;
        }
        int length = 4;
        int startPoint = origCaret - 2;
        BracketeerProcessingContainer cont = this._processingThread.getBracketContainer();
        List<BracketsPair> listOfPairs = cont.getMatchingPairs(startPoint, length);
        if ((listOfPairs = this.sortPairs(listOfPairs)).isEmpty()) {
            return false;
        }
        if (this.areEqualPairs(listOfPairs, this._hoveredPairsToPaint)) {
            return true;
        }
        this.clearHoveredPairsToPaint();
        List<PaintableBracket> list = this._hoveredPairsToPaint;
        synchronized (list) {
            this.addPaintableObjectsPairs(listOfPairs, 0, 1, this._hoveredPairsToPaint);
        }
        this._textWidget.redraw();
        return true;
    }

    private boolean showHoveredHint(int origCaret) {
        BracketeerProcessingContainer cont = this._processingThread.getBracketContainer();
        Hint hint = cont.getHint(origCaret);
        ProcessorConfiguration.HintConfiguration conf = this._conf.getHintConfiguration();
        if (!conf.isShowOnHover()) {
            hint = null;
        }
        PaintableHint hintToPaint = null;
        if (hint != null) {
            String type = hint.getType();
            hintToPaint = new PaintableHint(hint.getHintPositionRaw(), conf.getColor(type, true), conf.getColor(type, false), conf.isItalic(type), conf.formatTextHovered(type, hint.getTxt()));
        }
        boolean redraw = false;
        if (this._hoveredHintToPaint == null && hintToPaint != null) {
            redraw = true;
        } else if (this._hoveredHintToPaint != null && !this._hoveredHintToPaint.equals(hintToPaint)) {
            redraw = true;
        }
        this._hoveredHintToPaint = hintToPaint;
        if (redraw) {
            this._textWidget.redraw();
        }
        return hint != null;
    }

    private boolean areEqualPairs(List<BracketsPair> listOfPairs, List<PaintableBracket> pairsToPaint) {
        if (listOfPairs.size() * 2 != pairsToPaint.size()) {
            return false;
        }
        for (BracketsPair bracketsPair : listOfPairs) {
            for (SingleBracket bracket : bracketsPair.getBrackets()) {
                boolean found = false;
                for (PaintableObject paintableObject : pairsToPaint) {
                    if (!paintableObject.getPosition().equals((Object)bracket.getPositionRaw())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    private boolean areEqualSingle(List<SingleBracket> list, List<PaintableBracket> singlesToPaint) {
        if (list.size() != singlesToPaint.size()) {
            return false;
        }
        for (SingleBracket bracket : list) {
            boolean found = false;
            for (PaintableObject paintableObject : singlesToPaint) {
                if (!paintableObject.getPosition().equals((Object)bracket.getPositionRaw())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void addPaintableObjectsPairs(List<BracketsPair> listOfPairs, int colorCode, int colorCodeStep, List<PaintableBracket> paintableObjectsList) {
        for (BracketsPair bracketsPair : listOfPairs) {
            for (SingleBracket bracket : bracketsPair.getBrackets()) {
                Position pos = bracket.getPositionRaw();
                RGB fg = this._conf.getPairConfiguration().getColor(true, colorCode);
                RGB bg = this._conf.getPairConfiguration().getColor(false, colorCode);
                String highlightType = this._conf.getPairConfiguration().getHighlightType(colorCode);
                paintableObjectsList.add(new PaintableBracket(pos, fg, bg, highlightType));
            }
            colorCode += colorCodeStep;
        }
    }

    private void addPaintableObjectsSingles(List<SingleBracket> listOfSingles, List<PaintableBracket> paintableObjectsList) {
        HashMap<Annotation, Position> newMap = new HashMap<Annotation, Position>();
        for (SingleBracket bracket : listOfSingles) {
            Position pos = bracket.getPositionRaw();
            RGB fg = this._conf.getSingleBracketConfiguration().getColor(true);
            RGB bg = this._conf.getSingleBracketConfiguration().getColor(false);
            String highlightType = this._conf.getSingleBracketConfiguration().getHighlightType();
            paintableObjectsList.add(new PaintableBracket(pos, fg, bg, highlightType));
            if (!this._conf.getSingleBracketConfiguration().getAnnotate() || this._resource == null || this._annotationMap == null) continue;
            try {
                IMarker marker = this._resource.createMarker("com.chookapp.org.bracketeer.unmatchedBracket.marker");
                SimpleMarkerAnnotation ma = new SimpleMarkerAnnotation("com.chookapp.org.bracketeer.unmatchedBracket.annotation", marker);
                Position newPos = new Position(pos.getOffset());
                newMap.put((Annotation)ma, newPos);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        Set<Annotation> oldKeySet = this._annotationMap.keySet();
        if (!oldKeySet.isEmpty() || !newMap.isEmpty()) {
            this._annotationModel.connect(this._doc);
            if (this._annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this._annotationModel).replaceAnnotations(oldKeySet.toArray(new Annotation[oldKeySet.size()]), newMap);
            } else {
                for (Annotation annotation : oldKeySet) {
                    this._annotationModel.removeAnnotation(annotation);
                }
                for (Map.Entry mapEntry : newMap.entrySet()) {
                    this._annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this._annotationMap = newMap;
            this._annotationModel.disconnect(this._doc);
        }
    }

    private void clearPopup() {
        if (this._popup == null) {
            return;
        }
        this._popup.dispose();
        this._popup = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearHoveredPairsToPaint() {
        List<PaintableBracket> list = this._hoveredPairsToPaint;
        synchronized (list) {
            block4: {
                if (this._hoveredPairsToPaint.isEmpty()) break block4;
                this._hoveredPairsToPaint.clear();
                return true;
            }
        }
        return false;
    }

    private boolean clearHoveredHint() {
        boolean ret = this._hoveredHintToPaint != null;
        this._hoveredHintToPaint = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearSurroundingPairsToPaint() {
        List<PaintableBracket> list = this._surroundingPairsToPaint;
        synchronized (list) {
            block4: {
                if (this._surroundingPairsToPaint.isEmpty()) break block4;
                this._surroundingPairsToPaint.clear();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearSingleBracketsToPaint() {
        List<PaintableBracket> list = this._singleBracketsToPaint;
        synchronized (list) {
            block4: {
                if (this._singleBracketsToPaint.isEmpty()) break block4;
                this._singleBracketsToPaint.clear();
                return true;
            }
        }
        return false;
    }

    private IRegion computeClippingRegion(PaintEvent event) {
        int widgetEndOffset;
        int widgetOffset;
        if (event == null) {
            int vOffset = this.getInclusiveTopIndexStartOffset();
            if (vOffset == -1) {
                return null;
            }
            int vLength = this.getExclusiveBottomIndexEndOffset() - vOffset;
            return new Region(vOffset, vLength);
        }
        try {
            int widgetClippingStartOffset = this._textWidget.getOffsetAtLocation(new Point(0, event.y));
            int firstWidgetLine = this._textWidget.getLineAtOffset(widgetClippingStartOffset);
            widgetOffset = this._textWidget.getOffsetAtLine(firstWidgetLine);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                int firstVisibleLine = JFaceTextUtil.getPartialTopIndex((StyledText)this._textWidget);
                widgetOffset = this._textWidget.getOffsetAtLine(firstVisibleLine);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                widgetOffset = 0;
            }
        }
        try {
            int widgetClippingEndOffset = this._textWidget.getOffsetAtLocation(new Point(0, event.y + event.height));
            int lastWidgetLine = this._textWidget.getLineAtOffset(widgetClippingEndOffset);
            widgetEndOffset = this._textWidget.getOffsetAtLine(lastWidgetLine + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                int lastVisibleLine = JFaceTextUtil.getPartialBottomIndex((StyledText)this._textWidget);
                widgetEndOffset = lastVisibleLine == this._textWidget.getLineCount() - 1 ? this._textWidget.getCharCount() : this._textWidget.getOffsetAtLine(lastVisibleLine + 1) - 1;
            }
            catch (IllegalArgumentException illegalArgumentException3) {
                widgetEndOffset = this._textWidget.getCharCount();
            }
        }
        IRegion clippingRegion = this.getModelRange(widgetOffset, widgetEndOffset - widgetOffset);
        return clippingRegion;
    }

    private int getInclusiveTopIndexStartOffset() {
        if (this._textWidget != null && !this._textWidget.isDisposed()) {
            int top = JFaceTextUtil.getPartialTopIndex((ITextViewer)this._sourceViewer);
            try {
                IDocument document = this._sourceViewer.getDocument();
                return document.getLineOffset(top);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    private int getExclusiveBottomIndexEndOffset() {
        if (this._textWidget != null && !this._textWidget.isDisposed()) {
            int bottom = JFaceTextUtil.getPartialBottomIndex((ITextViewer)this._sourceViewer);
            try {
                IDocument document = this._sourceViewer.getDocument();
                if (bottom >= document.getNumberOfLines()) {
                    bottom = document.getNumberOfLines() - 1;
                }
                return document.getLineOffset(bottom) + document.getLineLength(bottom);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    private IRegion getModelRange(int offset, int length) {
        if (offset == Integer.MAX_VALUE) {
            return null;
        }
        if (this._sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this._sourceViewer;
            return extension.widgetRange2ModelRange((IRegion)new Region(offset, length));
        }
        IRegion region = this._sourceViewer.getVisibleRegion();
        return new Region(region.getOffset() + offset, length);
    }

    private IRegion getWidgetRange(int offset, int length) {
        return TextUtils.getWidgetRange(this._sourceViewer, offset, length);
    }

    private int getDistanceBetween(Point p1, Point p2) {
        return (int)Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }

    private int getCurrentCaretOffset() {
        int caret = this._textWidget.getCaretOffset();
        caret = ((ProjectionViewer)this._sourceViewer).widgetOffset2ModelOffset(caret);
        return --caret;
    }
}

