/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.common;

import com.chookapp.org.bracketeer.common.SingleBracket;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.Position;

public class BracketsPair {
    private List<SingleBracket> _brackets = new ArrayList<SingleBracket>();

    public BracketsPair(int openingOffset, char openingChar, int closingOffset, char closingChar) {
        this._brackets.add(new SingleBracket(openingOffset, true, openingChar));
        this._brackets.add(new SingleBracket(closingOffset, false, closingChar));
    }

    public List<SingleBracket> getBrackets() {
        return this._brackets;
    }

    public String toString() {
        return this._brackets.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BracketsPair)) {
            return false;
        }
        BracketsPair other = (BracketsPair)obj;
        return this.getBrackets().equals(other.getBrackets());
    }

    public int hashCode() {
        return this._brackets.hashCode();
    }

    public SingleBracket getOpeningBracket() {
        return this._brackets.get(0);
    }

    public SingleBracket getClosingBracket() {
        return this._brackets.get(1);
    }

    public SingleBracket getBracketAt(int offset) {
        for (SingleBracket br : this._brackets) {
            Position pos = br.getPosition();
            if (pos == null || pos.offset != offset) continue;
            return br;
        }
        return null;
    }

    public boolean hasDeletedPosition() {
        for (SingleBracket br : this._brackets) {
            if (br.getPosition() != null) continue;
            return true;
        }
        return false;
    }

    public int getDistanceBetweenBrackets() {
        return this.getClosingBracket().getPositionRaw().getOffset() - this.getOpeningBracket().getPositionRaw().getOffset();
    }
}

