/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.cdt.core.internals;

import com.chookapp.org.bracketeer.cdt.core.internals.BracketeerCharacterPairMatcher;
import com.chookapp.org.bracketeer.cdt.core.internals.CHeuristicScanner;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;

public class CPairMatcher
extends BracketeerCharacterPairMatcher {
    private static final int ANGLE_BRACKETS_SEARCH_BOUND = 200;
    private boolean fMatchAngularBrackets = true;
    private int fAnchor = -1;
    private List<Position> _inactiveCode = Collections.emptyList();

    public CPairMatcher(char[] pairs) {
        super(pairs, "___c_partitioning");
    }

    public IRegion match(IDocument document, int offset) {
        try {
            return this.performMatch(document, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public int getAnchor() {
        if (this.fAnchor < 0) {
            return super.getAnchor();
        }
        return this.fAnchor;
    }

    private IRegion performMatch(IDocument document, int offset) throws BadLocationException {
        int peer;
        IRegion region;
        if (offset < 0 || document == null) {
            return null;
        }
        char prevChar = document.getChar(Math.max(offset - 1, 0));
        if (!(prevChar != '<' && prevChar != '>' || this.fMatchAngularBrackets)) {
            return null;
        }
        if (prevChar == '<') {
            region = this.findClosingAngleBracket(document, offset - 1);
            this.fAnchor = 1;
        } else if (prevChar == '>') {
            region = this.findOpeningAngleBracket(document, offset - 1);
            this.fAnchor = 0;
        } else {
            region = super.match(document, this._inactiveCode, offset);
            this.fAnchor = -1;
        }
        if (region != null && (prevChar == '>' ? this.isLessThanOperator(document, peer = region.getOffset()) : prevChar == '<' && this.isGreaterThanOperator(document, peer = region.getOffset() + region.getLength() - 1))) {
            return null;
        }
        return region;
    }

    private IRegion findOpeningAngleBracket(IDocument document, int offset) throws BadLocationException {
        int pos;
        if (offset < 0) {
            return null;
        }
        String contentType = TextUtilities.getContentType((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)false);
        CHeuristicScanner scanner = new CHeuristicScanner(document, "___c_partitioning", contentType);
        if (this.isTemplateParameterCloseBracket(offset, document, scanner) && (pos = scanner.findOpeningPeer(offset - 1, Math.max(0, offset - 200), '<', '>')) != -1) {
            return new Region(pos, offset - pos + 1);
        }
        return null;
    }

    private IRegion findClosingAngleBracket(IDocument document, int offset) throws BadLocationException {
        int pos;
        if (offset < 0) {
            return null;
        }
        String contentType = TextUtilities.getContentType((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)false);
        CHeuristicScanner scanner = new CHeuristicScanner(document, "___c_partitioning", contentType);
        if (this.isTemplateParameterOpenBracket(offset, document, scanner) && (pos = scanner.findClosingPeer(offset + 1, Math.min(document.getLength(), offset + 200), '<', '>')) != -1) {
            return new Region(offset, pos - offset + 1);
        }
        return null;
    }

    private boolean isLessThanOperator(IDocument document, int offset) throws BadLocationException {
        if (offset < 0) {
            return false;
        }
        String contentType = TextUtilities.getContentType((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)false);
        CHeuristicScanner scanner = new CHeuristicScanner(document, "___c_partitioning", contentType);
        return !this.isTemplateParameterOpenBracket(offset, document, scanner);
    }

    private boolean isGreaterThanOperator(IDocument document, int offset) throws BadLocationException {
        if (offset < 0) {
            return false;
        }
        String contentType = TextUtilities.getContentType((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)false);
        CHeuristicScanner scanner = new CHeuristicScanner(document, "___c_partitioning", contentType);
        return !this.isTemplateParameterCloseBracket(offset, document, scanner);
    }

    private boolean isTemplateParameterOpenBracket(int offset, IDocument document, CHeuristicScanner scanner) {
        int nextToken = scanner.nextToken(offset + 1, Math.min(document.getLength(), offset + 200));
        if (nextToken == 21 || nextToken == 13) {
            return false;
        }
        int prevToken = scanner.previousToken(offset - 1, Math.max(0, offset - 200));
        return prevToken == 2000 || prevToken == 1040;
    }

    private boolean isTemplateParameterCloseBracket(int offset, IDocument document, CHeuristicScanner scanner) {
        if (offset >= document.getLength() - 1) {
            return true;
        }
        int thisToken = scanner.previousToken(offset, Math.max(0, offset - 200));
        if (thisToken == 18) {
            return true;
        }
        if (thisToken != 14) {
            return false;
        }
        int prevToken = scanner.previousToken(scanner.getPosition(), Math.max(0, offset - 200));
        if (prevToken == 14) {
            return true;
        }
        int nextToken = scanner.nextToken(offset + 1, Math.min(document.getLength(), offset + 200));
        switch (nextToken) {
            case 7: 
            case 11: 
            case 14: 
            case 1028: 
            case 1029: 
            case 1030: {
                return true;
            }
        }
        return false;
    }

    public void configure(ILanguage language) {
        this.fMatchAngularBrackets = language != null && language.getLinkageID() == 1;
    }

    public void updateInactiveCodePositions(List<Position> inactiveCode) {
        this._inactiveCode = inactiveCode;
    }
}

