/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.cdt;

import com.chookapp.org.bracketeer.common.Hint;
import com.chookapp.org.bracketeer.common.IBracketeerProcessingContainer;
import com.chookapp.org.bracketeer.common.IHintConfiguration;
import com.chookapp.org.bracketeer.common.MutableBool;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.jface.text.BadLocationException;

public class PreprocessorVisitor {
    MutableBool _cancelProcessing;
    IBracketeerProcessingContainer _container;
    IHintConfiguration _hintConf;
    Stack<CondInfo> _stack;

    public PreprocessorVisitor(IBracketeerProcessingContainer container, MutableBool cancelProcessing, IHintConfiguration hintConf) {
        this._cancelProcessing = cancelProcessing;
        this._container = container;
        this._hintConf = hintConf;
        this._stack = new Stack();
    }

    private String stripEolBackslash(char[] ch) {
        String str = new String(ch);
        return this.stripEolBackslash(str);
    }

    private String stripEolBackslash(String str) {
        return str.replaceAll("\\\\(\\s*[\r|\n])", "$1");
    }

    public void visit(IASTPreprocessorStatement[] stmts) throws BadLocationException {
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            StringBuffer str;
            int startLoc;
            int endLoc;
            IASTFileLocation location;
            CondInfo cond;
            StringBuffer str2;
            IASTPreprocessorStatement stmt = iASTPreprocessorStatementArray[n2];
            if (this._cancelProcessing.get()) break;
            if (stmt instanceof IASTPreprocessorIfStatement) {
                str2 = new StringBuffer();
                str2.append("if( ");
                str2.append(this.stripEolBackslash(((IASTPreprocessorIfStatement)stmt).getCondition()));
                str2.append(" )");
                this._stack.push(new CondInfo(str2.toString(), stmt.getFileLocation()));
            } else if (stmt instanceof IASTPreprocessorIfdefStatement) {
                str2 = new StringBuffer();
                str2.append("if_defined( ");
                str2.append(this.stripEolBackslash(((IASTPreprocessorIfdefStatement)stmt).getCondition()));
                str2.append(" )");
                this._stack.push(new CondInfo(str2.toString(), stmt.getFileLocation()));
            } else if (stmt instanceof IASTPreprocessorIfndefStatement) {
                str2 = new StringBuffer();
                str2.append("if_not_defined( ");
                str2.append(this.stripEolBackslash(((IASTPreprocessorIfndefStatement)stmt).getCondition()));
                str2.append(" )");
                this._stack.push(new CondInfo(str2.toString(), stmt.getFileLocation()));
            } else if (stmt instanceof IASTPreprocessorElifStatement) {
                cond = null;
                if (!this._stack.empty()) {
                    cond = this._stack.pop();
                }
                if (cond != null) {
                    location = stmt.getFileLocation();
                    endLoc = location.getNodeOffset() + location.getNodeLength() - 1;
                    startLoc = cond._fileLoc.getNodeOffset();
                    this._container.add(new Hint("preprocess", startLoc, endLoc, cond._cond));
                }
                str = new StringBuffer();
                str.append("if( ");
                str.append(this.stripEolBackslash(((IASTPreprocessorElifStatement)stmt).getCondition()));
                str.append(" )");
                this._stack.push(new CondInfo(str.toString(), stmt.getFileLocation()));
            } else if (stmt instanceof IASTPreprocessorElseStatement) {
                cond = null;
                if (!this._stack.empty()) {
                    cond = this._stack.pop();
                }
                str = new StringBuffer();
                str.append("else_of_");
                if (cond != null) {
                    IASTFileLocation location2 = stmt.getFileLocation();
                    int endLoc2 = location2.getNodeOffset() + location2.getNodeLength() - 1;
                    int startLoc2 = cond._fileLoc.getNodeOffset();
                    this._container.add(new Hint("preprocess", startLoc2, endLoc2, cond._cond));
                    str.append(cond._cond);
                }
                this._stack.push(new CondInfo(str.toString(), stmt.getFileLocation()));
            } else if (stmt instanceof IASTPreprocessorEndifStatement && !this._stack.empty()) {
                cond = this._stack.pop();
                location = stmt.getFileLocation();
                endLoc = location.getNodeOffset() + location.getNodeLength() - 1;
                startLoc = cond._fileLoc.getNodeOffset();
                this._container.add(new Hint("preprocess", startLoc, endLoc, cond._cond));
            }
            ++n2;
        }
    }

    class CondInfo {
        public String _cond;
        public IASTFileLocation _fileLoc;

        public CondInfo(String str, IASTFileLocation fileLocation) {
            this._cond = str;
            this._fileLoc = fileLocation;
        }
    }
}

