/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.cdt;

import com.chookapp.org.bracketeer.cdt.Activator;
import com.chookapp.org.bracketeer.common.BracketsPair;
import com.chookapp.org.bracketeer.common.Hint;
import com.chookapp.org.bracketeer.common.IBracketeerProcessingContainer;
import com.chookapp.org.bracketeer.common.IHintConfiguration;
import com.chookapp.org.bracketeer.common.MutableBool;
import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTIfStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.jface.text.BadLocationException;

public class ClosingBracketHintVisitor
extends ASTVisitor {
    MutableBool _cancelProcessing;
    IBracketeerProcessingContainer _container;
    IHintConfiguration _hintConf;
    Stack<ScopeInfo> _scopeStack;

    public ClosingBracketHintVisitor(IBracketeerProcessingContainer container, MutableBool cancelProcessing, IHintConfiguration hintConf) {
        this._cancelProcessing = cancelProcessing;
        this._container = container;
        this._hintConf = hintConf;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitNamespaces = true;
        this._scopeStack = new Stack();
    }

    public int leave(IASTStatement statement) {
        try {
            if (statement instanceof IASTSwitchStatement || statement instanceof IASTForStatement || statement instanceof IASTWhileStatement || statement instanceof IASTDoStatement) {
                ScopeInfo scope;
                if (statement instanceof IASTSwitchStatement) {
                    scope = this._scopeStack.peek();
                    if (scope._statement instanceof IASTCaseStatement || scope._statement instanceof IASTDefaultStatement) {
                        this._scopeStack.pop();
                    }
                }
                scope = this._scopeStack.pop();
                if (!scope._statement.getClass().equals(statement.getClass())) {
                    // empty if block
                }
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return super.leave(statement);
    }

    public int visit(IASTStatement statement) {
        block10: {
            try {
                if (statement instanceof IASTIfStatement) {
                    this.visitIf((IASTIfStatement)statement);
                }
                if (statement instanceof IASTSwitchStatement) {
                    this.visitSwitch((IASTSwitchStatement)statement);
                }
                if (statement instanceof IASTForStatement) {
                    this.visitFor((IASTForStatement)statement);
                }
                if (statement instanceof IASTWhileStatement) {
                    this.visitWhile((IASTWhileStatement)statement);
                }
                if (statement instanceof IASTDoStatement) {
                    this.visitDo((IASTDoStatement)statement);
                }
                if (statement instanceof IASTCaseStatement || statement instanceof IASTDefaultStatement) {
                    this.visitCase(statement);
                }
                if (statement instanceof IASTBreakStatement || statement instanceof IASTContinueStatement) {
                    this.visitBreak(statement);
                }
            }
            catch (BadLocationException badLocationException) {
                this._cancelProcessing.set(true);
            }
            catch (Exception e) {
                if (e instanceof ScopeTraceException || e instanceof EmptyStackException) break block10;
                Activator.log(e);
            }
        }
        return this.shouldContinue();
    }

    public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
        IASTName name = namespaceDefinition.getName();
        try {
            IASTFileLocation location = namespaceDefinition.getFileLocation();
            int endLoc = location.getNodeOffset() + location.getNodeLength() - 1;
            int startLoc = location.getNodeOffset();
            this._container.add(new Hint("namespace", startLoc, endLoc, "namespace " + name.toString()));
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    private void visitBreak(IASTStatement statement) throws ScopeTraceException, BadLocationException {
        String hintType;
        if (this._scopeStack.isEmpty()) {
            throw new ScopeTraceException("break without scope: " + statement);
        }
        ScopeInfo scope = this._scopeStack.peek();
        if (scope._statement instanceof IASTForStatement) {
            hintType = "break-for";
        } else if (scope._statement instanceof IASTWhileStatement) {
            hintType = "break-while";
        } else if (scope._statement instanceof IASTDoStatement) {
            hintType = "break-do";
        } else if (scope._statement instanceof IASTCaseStatement || scope._statement instanceof IASTDefaultStatement) {
            hintType = "break-case";
        } else {
            throw new ScopeTraceException("Unexpect scope (" + scope._statement + ") on break/continue:" + statement);
        }
        int endLoc = statement.getFileLocation().getNodeOffset() + statement.getFileLocation().getNodeLength() - 1;
        this._container.add(new Hint(hintType, scope._offset, endLoc, scope._str));
    }

    private void visitCase(IASTStatement statement) throws ScopeTraceException {
        ScopeInfo scope = this._scopeStack.peek();
        if (!(scope._statement instanceof IASTSwitchStatement)) {
            if (!(scope._statement instanceof IASTCaseStatement) && !(scope._statement instanceof IASTDefaultStatement)) {
                throw new ScopeTraceException("Lost track of stack (in case), found:" + scope._statement);
            }
            this._scopeStack.pop();
            scope = this._scopeStack.peek();
        }
        if (!(scope._statement instanceof IASTSwitchStatement)) {
            throw new ScopeTraceException("Lost track of stack (in case2), found:" + scope._statement);
        }
        String hint = "";
        if (statement instanceof IASTCaseStatement) {
            IASTExpression cond = ((IASTCaseStatement)statement).getExpression();
            if (cond != null) {
                hint = cond.getRawSignature();
            }
            hint = "case: " + hint;
        } else {
            hint = "default";
        }
        int startLoc = statement.getFileLocation().getNodeOffset();
        this._scopeStack.push(new ScopeInfo(String.valueOf(scope._str) + " - " + hint, startLoc, statement));
    }

    private void visitDo(IASTDoStatement statement) {
        IASTExpression cond = statement.getCondition();
        String hint = "";
        if (cond != null) {
            hint = cond.getRawSignature();
        }
        hint = "do_while( " + hint + " )";
        int startLoc = statement.getFileLocation().getNodeOffset();
        this._scopeStack.push(new ScopeInfo(hint, startLoc, (IASTStatement)statement));
    }

    private void visitIf(IASTIfStatement statement) throws BadLocationException {
        int startLoc;
        IASTFileLocation location;
        String hint = "";
        if (statement.getConditionExpression() != null) {
            hint = statement.getConditionExpression().getRawSignature();
        } else if (statement instanceof ICPPASTIfStatement && ((ICPPASTIfStatement)statement).getConditionDeclaration() != null) {
            hint = ((ICPPASTIfStatement)statement).getConditionDeclaration().getRawSignature();
        }
        IASTStatement thenClause = statement.getThenClause();
        IASTStatement elseClause = statement.getElseClause();
        boolean showIfHint = elseClause == null;
        int endLoc = -1;
        if (!showIfHint) {
            if (elseClause.getFileLocation().getStartingLineNumber() != thenClause.getFileLocation().getEndingLineNumber()) {
                showIfHint = true;
            }
            if (!showIfHint && !(elseClause instanceof IASTIfStatement)) {
                endLoc = elseClause.getFileLocation().getNodeOffset();
                showIfHint = true;
            }
        }
        if (showIfHint && !(thenClause instanceof IASTCompoundStatement)) {
            showIfHint = false;
        }
        if (showIfHint) {
            location = thenClause.getFileLocation();
            if (endLoc == -1) {
                endLoc = location.getNodeOffset() + location.getNodeLength() - 1;
            }
            startLoc = statement.getFileLocation().getNodeOffset();
            this._container.add(new Hint("if", startLoc, endLoc, "if( " + hint + " )"));
        }
        if (elseClause != null && !(elseClause instanceof IASTIfStatement) && elseClause instanceof IASTCompoundStatement) {
            location = elseClause.getFileLocation();
            endLoc = location.getNodeOffset() + location.getNodeLength() - 1;
            startLoc = location.getNodeOffset();
            this._container.add(new Hint("if", startLoc, endLoc, "else_of_if( " + hint + " )"));
        }
    }

    private void visitSwitch(IASTSwitchStatement statement) throws BadLocationException {
        String hint = statement.getControllerExpression().getRawSignature();
        IASTFileLocation location = statement.getBody().getFileLocation();
        int endLoc = location.getNodeOffset() + location.getNodeLength() - 1;
        int startLoc = statement.getFileLocation().getNodeOffset();
        hint = "switch( " + hint + " )";
        this._container.add(new Hint("switch", startLoc, endLoc, hint));
        this._scopeStack.push(new ScopeInfo(hint, startLoc, (IASTStatement)statement));
    }

    private void visitFor(IASTForStatement statement) throws BadLocationException {
        IASTExpression cond = statement.getConditionExpression();
        String hint = "";
        if (cond != null) {
            hint = cond.getRawSignature();
        }
        hint = "for( " + hint + " )";
        int startLoc = statement.getFileLocation().getNodeOffset();
        this._scopeStack.push(new ScopeInfo(hint, startLoc, (IASTStatement)statement));
        IASTStatement body = statement.getBody();
        if (body instanceof IASTCompoundStatement) {
            IASTFileLocation location = body.getFileLocation();
            int endLoc = location.getNodeOffset() + location.getNodeLength() - 1;
            this._container.add(new Hint("for", startLoc, endLoc, hint));
        }
    }

    private void visitWhile(IASTWhileStatement statement) throws BadLocationException {
        IASTExpression cond = statement.getCondition();
        String hint = "";
        if (cond != null) {
            hint = cond.getRawSignature();
        }
        hint = "while( " + hint + " )";
        int startLoc = statement.getFileLocation().getNodeOffset();
        this._scopeStack.push(new ScopeInfo(hint, startLoc, (IASTStatement)statement));
        IASTStatement body = statement.getBody();
        if (body instanceof IASTCompoundStatement) {
            IASTFileLocation location = body.getFileLocation();
            int endLoc = location.getNodeOffset() + location.getNodeLength() - 1;
            this._container.add(new Hint("while", startLoc, endLoc, hint));
        }
    }

    public int visit(IASTDeclaration declaration) {
        try {
            if (declaration instanceof IASTFunctionDefinition) {
                this.visitFunc((IASTFunctionDefinition)declaration);
            }
            if (declaration instanceof IASTSimpleDeclaration) {
                this.visitType((IASTSimpleDeclaration)declaration);
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
        return this.shouldContinue();
    }

    private void visitFunc(IASTFunctionDefinition declaration) throws BadLocationException {
        IASTStatement body = declaration.getBody();
        if (!(body instanceof IASTCompoundStatement)) {
            return;
        }
        this._scopeStack.clear();
        IASTFileLocation location = body.getFileLocation();
        int endLoc = location.getNodeOffset() + location.getNodeLength() - 1;
        IASTFunctionDeclarator declerator = declaration.getDeclarator();
        int startLoc = declerator.getFileLocation().getNodeOffset();
        StringBuffer hint = new StringBuffer();
        hint.append(declerator.getName().getRawSignature());
        hint.append("( ");
        IASTNode[] decChildren = declerator.getChildren();
        boolean firstParam = true;
        int i = 0;
        while (i < decChildren.length) {
            IASTNode node = decChildren[i];
            if (node instanceof IASTParameterDeclaration) {
                IASTParameterDeclaration param = (IASTParameterDeclaration)node;
                if (firstParam) {
                    firstParam = false;
                } else {
                    hint.append(", ");
                }
                hint.append(param.getDeclarator().getName());
            }
            ++i;
        }
        hint.append(" )");
        this._container.add(new Hint("function", startLoc, endLoc, hint.toString()));
    }

    private void visitType(IASTSimpleDeclaration declaration) throws BadLocationException {
        IASTDeclSpecifier spec = declaration.getDeclSpecifier();
        if (spec instanceof IASTCompositeTypeSpecifier) {
            String hint = ((IASTCompositeTypeSpecifier)spec).getName().getRawSignature();
            if (hint.isEmpty()) {
                return;
            }
            IASTFileLocation location = declaration.getFileLocation();
            int endLoc = location.getNodeOffset() + location.getNodeLength() - 1;
            int startLoc = location.getNodeOffset();
            this._container.add(new Hint("type", startLoc, endLoc, hint));
        }
        if (spec instanceof ICPPASTNamedTypeSpecifier) {
            IASTName name = ((ICPPASTNamedTypeSpecifier)spec).getName();
            this.addBrackets(name);
        }
    }

    private void addBrackets(IASTName name) throws BadLocationException {
        if (name instanceof ICPPASTTemplateId) {
            IASTNode[] args = ((ICPPASTTemplateId)name).getTemplateArguments();
            this.addBrackets(args);
        } else if (name instanceof ICPPASTQualifiedName) {
            IASTName[] names;
            IASTName[] iASTNameArray = names = ((ICPPASTQualifiedName)name).getNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName n3 = iASTNameArray[n2];
                this.addBrackets(n3);
                ++n2;
            }
        }
    }

    private void addBrackets(IASTNode[] args) throws BadLocationException {
        if (args == null || args.length == 0) {
            return;
        }
        int startLoc = args[0].getFileLocation().getNodeOffset() - 1;
        IASTFileLocation endFileLoc = args[args.length - 1].getFileLocation();
        int endLoc = endFileLoc.getNodeOffset() + endFileLoc.getNodeLength();
        this._container.add(new BracketsPair(startLoc, '<', endLoc, '>'));
    }

    private int shouldContinue() {
        if (this._cancelProcessing.get()) {
            return 2;
        }
        return 3;
    }

    class ScopeInfo {
        public String _str;
        public int _offset;
        public IASTStatement _statement;

        public ScopeInfo(String str, int offset, IASTStatement statement) {
            this._str = str;
            this._offset = offset;
            this._statement = statement;
        }
    }

    public class ScopeTraceException
    extends Exception {
        private static final long serialVersionUID = 6297837237586982280L;

        public ScopeTraceException(String message) {
            super(message);
        }
    }
}

