/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.cdt;

import com.chookapp.org.bracketeer.cdt.Activator;
import com.chookapp.org.bracketeer.cdt.ClosingBracketHintVisitor;
import com.chookapp.org.bracketeer.cdt.Messages;
import com.chookapp.org.bracketeer.cdt.PreprocessorVisitor;
import com.chookapp.org.bracketeer.cdt.core.internals.CPairMatcher;
import com.chookapp.org.bracketeer.common.BracketsPair;
import com.chookapp.org.bracketeer.common.IBracketeerProcessingContainer;
import com.chookapp.org.bracketeer.common.SingleBracket;
import com.chookapp.org.bracketeer.common.Utils;
import com.chookapp.org.bracketeer.extensionpoint.BracketeerProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.text.ICPartitions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class BracketeerCdtProcessor
extends BracketeerProcessor {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected static final String LONELY_BRACKETS = "()[]{}";
    private CPairMatcher _matcher;
    private ICElement _celem;
    private IDocument _doc;
    private IASTTranslationUnit _ast;

    public BracketeerCdtProcessor(IEditorPart part, IDocument doc) {
        super(doc);
        this._celem = CDTUITools.getEditorInputCElement((IEditorInput)part.getEditorInput());
        this._matcher = new CPairMatcher(BRACKETS);
        this._doc = doc;
    }

    private BracketsPair getMatchingPair(int offset) throws BadLocationException {
        IRegion region = this._matcher.match(this._doc, offset);
        if (region == null) {
            return null;
        }
        if (region.getLength() < 1) {
            throw new RuntimeException(Messages.BracketeerCdtProcessor_ErrLength);
        }
        boolean isAnchorOpening = 1 == this._matcher.getAnchor();
        int targetOffset = isAnchorOpening ? region.getOffset() + region.getLength() : region.getOffset() + 1;
        --offset;
        --targetOffset;
        if (isAnchorOpening) {
            return new BracketsPair(offset, this._doc.getChar(offset), targetOffset, this._doc.getChar(targetOffset));
        }
        return new BracketsPair(targetOffset, this._doc.getChar(targetOffset), offset, this._doc.getChar(offset));
    }

    private SingleBracket getLonelyBracket(int offset, List<Position> inactiveCode) throws BadLocationException {
        int charOffset = offset - 1;
        char prevChar = this._doc.getChar(Math.max(charOffset, 0));
        if (LONELY_BRACKETS.indexOf(prevChar) == -1) {
            return null;
        }
        String partition = TextUtilities.getContentType((IDocument)this._doc, (String)"___c_partitioning", (int)charOffset, (boolean)false);
        String[] stringArray = ICPartitions.ALL_CPARTITIONS;
        int n = ICPartitions.ALL_CPARTITIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String partName = stringArray[n2];
            if (partName.equals(partition)) {
                return null;
            }
            for (Position pos : inactiveCode) {
                if (!pos.includes(offset)) continue;
                return null;
            }
            ++n2;
        }
        return new SingleBracket(charOffset, Utils.isOpenningBracket((char)prevChar), prevChar);
    }

    protected void processDocument(IDocument doc, IBracketeerProcessingContainer container) {
        try {
            this._doc = doc;
            this.updateAst();
            this.processBrackets(container);
            this.processAst(container);
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
    }

    private void processBrackets(IBracketeerProcessingContainer container) throws BadLocationException {
        List<Position> inactiveCode = this.collectInactiveCodePositions(this._ast);
        this._matcher.updateInactiveCodePositions(inactiveCode);
        int i = 1;
        while (i < this._doc.getLength() + 1) {
            if (this._cancelProcessing.get()) break;
            BracketsPair pair = this.getMatchingPair(i);
            if (pair != null) {
                container.add(pair);
            } else {
                SingleBracket single = this.getLonelyBracket(i, inactiveCode);
                if (single != null) {
                    container.add(single);
                }
            }
            ++i;
        }
    }

    private void processAst(IBracketeerProcessingContainer container) throws BadLocationException {
        if (this._ast == null) {
            return;
        }
        ClosingBracketHintVisitor visitor = new ClosingBracketHintVisitor(container, this._cancelProcessing, this._hintConf);
        this._ast.accept((ASTVisitor)visitor);
        IASTPreprocessorStatement[] stmts = this._ast.getAllPreprocessorStatements();
        PreprocessorVisitor preVisotor = new PreprocessorVisitor(container, this._cancelProcessing, this._hintConf);
        preVisotor.visit(stmts);
    }

    private void updateAst() {
        try {
            IASTTranslationUnit ast;
            this._ast = null;
            if (this._celem == null) {
                return;
            }
            ITranslationUnit tu = (ITranslationUnit)this._celem;
            this._ast = ast = tu.getAST(null, 230);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private List<Position> collectInactiveCodePositions(IASTTranslationUnit translationUnit) {
        IASTPreprocessorStatement[] preprocStmts;
        if (translationUnit == null) {
            return Collections.emptyList();
        }
        String fileName = translationUnit.getFilePath();
        if (fileName == null) {
            return Collections.emptyList();
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        int inactiveCodeStart = -1;
        boolean inInactiveCode = false;
        Stack<Boolean> inactiveCodeStack = new Stack<Boolean>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocStmts = translationUnit.getAllPreprocessorStatements();
        int n = preprocStmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            IASTFileLocation floc = statement.getFileLocation();
            if (floc != null && fileName.equals(floc.getFileName())) {
                int inactiveCodeEnd;
                if (statement instanceof IASTPreprocessorIfStatement) {
                    IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                    IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifdefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                    IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifndefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorElseStatement) {
                    IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                    if (!elseStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    } else if (elseStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = floc.getNodeOffset();
                        positions.add(this.createInactiveCodePosition(inactiveCodeStart, inactiveCodeEnd, false));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorElifStatement) {
                    IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                    if (!elifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    } else if (elifStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = floc.getNodeOffset();
                        positions.add(this.createInactiveCodePosition(inactiveCodeStart, inactiveCodeEnd, false));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorEndifStatement) {
                    try {
                        boolean wasInInactiveCode = (Boolean)inactiveCodeStack.pop();
                        if (inInactiveCode && !wasInInactiveCode) {
                            inactiveCodeEnd = floc.getNodeOffset() + floc.getNodeLength();
                            positions.add(this.createInactiveCodePosition(inactiveCodeStart, inactiveCodeEnd, true));
                        }
                        inInactiveCode = wasInInactiveCode;
                    }
                    catch (EmptyStackException emptyStackException) {}
                }
            }
            ++n2;
        }
        if (inInactiveCode) {
            int inactiveCodeEnd = this._doc.getLength();
            positions.add(this.createInactiveCodePosition(inactiveCodeStart, inactiveCodeEnd, true));
        }
        return positions;
    }

    private Position createInactiveCodePosition(int startOffset, int endOffset, boolean inclusive) {
        IDocument document = this._doc;
        try {
            if (document != null) {
                int start = document.getLineOfOffset(startOffset);
                int end = document.getLineOfOffset(endOffset);
                startOffset = document.getLineOffset(start);
                if (!inclusive) {
                    endOffset = document.getLineOffset(end);
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return new Position(startOffset, endOffset - startOffset);
    }
}

