/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.overviewrulerbackground.core;

import com.chookapp.org.overviewrulerbackground.Activator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EditorEvents
implements IWindowListener,
IPartListener2 {
    private static EditorEvents sInstance = new EditorEvents();
    private Collection<IWorkbenchWindow> fWindows = new HashSet<IWorkbenchWindow>();

    public static EditorEvents getInstance() {
        return sInstance;
    }

    public void install() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            Activator.log("can't find workbanch");
            return;
        }
        workbench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] wnds = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < wnds.length) {
            IWorkbenchWindow window = wnds[i];
            this.register(window);
            ++i;
        }
    }

    public void uninstall() {
        for (IWorkbenchWindow window : this.fWindows) {
            this.unregister(window);
        }
    }

    private void register(IWorkbenchWindow wnd) {
        IWorkbenchPage page;
        IWorkbenchPage[] pages;
        wnd.getPartService().addPartListener((IPartListener2)this);
        this.fWindows.add(wnd);
        IWorkbenchPage[] iWorkbenchPageArray = pages = wnd.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] editorRefs;
            page = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
            int n3 = editorRefs.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference editorRef = iEditorReferenceArray[n4];
                this.partActivated((IWorkbenchPartReference)editorRef);
                ++n4;
            }
            ++n2;
        }
        page = wnd.getActivePage();
        if (page != null) {
            this.activated(page.getActivePartReference());
        }
    }

    private void unregister(IWorkbenchWindow wnd) {
        wnd.getPartService().removePartListener((IPartListener2)this);
        this.fWindows.remove(wnd);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.register(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.unregister(window);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.activated(partRef);
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.activated(partRef);
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private void activated(IWorkbenchPartReference partRef) {
        try {
            if (partRef == null) {
                return;
            }
            if (Activator.getDefault().getPreferenceStore().getBoolean("systemDef")) {
                return;
            }
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)"color");
            IEditorPart editorPart = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editorPart == null) {
                return;
            }
            SourceViewer sv = (SourceViewer)this.callGetSourceViewer((AbstractTextEditor)editorPart);
            OverviewRuler ruler = (OverviewRuler)this.getOverviewRuler(sv);
            ruler.getControl().setBackground(new Color((Device)Display.getDefault(), rgb));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private ITextViewer callGetSourceViewer(AbstractTextEditor editor) throws Exception {
        try {
            Method method = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            method.setAccessible(true);
            return (ITextViewer)method.invoke((Object)editor, new Object[0]);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private IOverviewRuler getOverviewRuler(SourceViewer viewer) {
        try {
            Field f = SourceViewer.class.getDeclaredField("fOverviewRuler");
            f.setAccessible(true);
            return (IOverviewRuler)f.get(viewer);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

