from mercurial.node import hex
from mercurial import bookmarks


def _collectdraftcommits(node):
    queue = [node]
    drafts = set()
    while queue:
        node = queue.pop(0)
        id = hex(node.node())
        if node.phase() == 0 or node in drafts:
            continue

        drafts.add(id)
        queue = sorted(queue + [p for p in node.parents() if p.phase() != 0], key=lambda node: -node.rev())
    return drafts


def sgbranches(ui, repo):
    ctx = repo[None]
    parents = [p for p in ctx.parents() if p.rev() >= 0]
    ui.write('heads\t', len(parents), '\n')
    for p in parents:
        ui.write(hex(p.node()), '\n')
    ui.write('currentbranch\t', ctx.branch(), '\n')

    determinedraftcount = len(ui.configitems("paths")) > 0
    activebranches = set([repo[n].branch() for n in repo.heads()])
    branchmap = dict(repo.branchmap())
    for branch in activebranches:
        if not branch in branchmap:
            branchmap[branch] = list()

    ui.write('branches\t', len(branchmap), '\n')
    for ref, heads in branchmap.iteritems():
        alldraftcommits = set()
        tuples = list()
        for h in reversed(heads):
            head = repo[h]
            draftcommits = _collectdraftcommits(head) if determinedraftcount else list()
            tuples.append((head, len(draftcommits)))
            alldraftcommits = alldraftcommits.union(draftcommits)

        ui.write(ref, '\t', len(heads), '\t', len(alldraftcommits), '\n')
        for tuple in tuples:
            head = tuple[0]
            draftcommits = tuple[1]
            isopen = not head.closesbranch()
            isactive = ref in activebranches and isopen
            ui.write(head.rev(), '\t', hex(head.node()), '\t', 'open' if isopen else 'closed', '\t', 'active' if isactive else 'inactive', '\t',
                draftcommits, '\n')

    taginfos = list()
    for ref, n in reversed(repo.tagslist()):
        rev = repo.changelog.rev(n)
        if rev >= 0:
            taginfos.append((ref, repo.changelog.rev(n), hex(n), repo.tagtype(ref)))

    ui.write('tags\t', len(taginfos), '\n')
    for ref, rev, sha, type in reversed(taginfos):
        ui.write(ref, '\t', rev, '\t', sha, '\t', type, '\n')

    marks = bookmarks.bmstore(repo)
    try:
        curMark = bookmarks.readactive(repo)
    except AttributeError:
        curMark = bookmarks.readcurrent(repo)

    ui.write('activebookmark\t', curMark if curMark is not None else '', '\n')
    ui.write('bookmarks\t', len(marks), '\n')
    for bmark, n in sorted(marks.iteritems()):
        h = repo[n]
        draftcommits = len(_collectdraftcommits(h)) if determinedraftcount else 0
        ui.write(bmark, '\t', repo.changelog.rev(n), '\t', hex(h.node()), '\t', draftcommits, '\n')


cmdtable = {
    'sgbranches': (sgbranches, [])
}
