/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem currentFocusItem;
    ToolItem[] tabItemList;
    ImageList imageList;
    boolean hasChildFocus;
    static Callback menuItemSelectedFunc = new Callback(ToolBar.class, "MenuItemSelectedProc", 2);

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int orientation = (style & 0x200) != 0 ? 1 : 0;
        OS.gtk_orientable_set_orientation(this.handle, orientation);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_toolbar_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 0x800000) != 0) {
            byte[] swt_toolbar_flat = Converter.wcsToMbcs(null, "swt-toolbar-flat", true);
            OS.gtk_widget_set_name(this.handle, swt_toolbar_flat);
        }
        if (OS.GTK3) {
            long context = OS.gtk_widget_get_style_context(this.handle);
            OS.gtk_style_context_invalidate(context);
        }
        OS.gtk_toolbar_set_icon_size(this.handle, OS.GTK3 ? 2 : 3);
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    int applyThemeBackground() {
        return -1;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        OS.gtk_toolbar_set_show_arrow(this.handle, false);
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if ((this.style & 0x40) != 0) {
            OS.gtk_toolbar_set_show_arrow(this.handle, true);
        }
        return size;
    }

    Widget computeTabGroup() {
        int index;
        ToolItem[] items = this._getItems();
        if (this.tabItemList == null) {
            int i;
            for (i = 0; i < items.length && items[i].control == null; ++i) {
            }
            if (i == items.length) {
                return super.computeTabGroup();
            }
        }
        if ((index = this.indexOf(this.currentFocusItem)) == -1) {
            index = items.length - 1;
        }
        while (index >= 0) {
            ToolItem item = items[index];
            if (item.isTabGroup()) {
                return item;
            }
            --index;
        }
        return super.computeTabGroup();
    }

    Widget[] computeTabList() {
        ToolItem[] items = this._getItems();
        if (this.tabItemList == null) {
            int i;
            for (i = 0; i < items.length && items[i].control == null; ++i) {
            }
            if (i == items.length) {
                return super.computeTabList();
            }
        }
        Widget[] result = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return result;
        }
        ToolItem[] list = this.tabList != null ? this._getTabItemList() : items;
        for (int i = 0; i < list.length; ++i) {
            ToolItem child = list[i];
            Widget[] childList = child.computeTabList();
            if (childList.length == 0) continue;
            Widget[] newResult = new Widget[result.length + childList.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(childList, 0, newResult, result.length, childList.length);
            result = newResult;
        }
        if (result.length == 0) {
            result = new Widget[]{this};
        }
        return result;
    }

    long eventHandle() {
        return this.fixedHandle;
    }

    long enterExitHandle() {
        return this.handle;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        ToolItem[] items = this.getItems();
        if (this.toolTipText == null) {
            for (int i = 0; i < items.length; ++i) {
                ToolItem item = items[i];
                if (item.toolTipText == null) continue;
                item.setToolTipText(oldShell, null);
                item.setToolTipText(newShell, item.toolTipText);
            }
        }
    }

    boolean forceFocus(long focusHandle) {
        int dir = 0;
        if ((this.style & 0x8000000) != 0) {
            dir = 1;
        }
        long childHandle = this.handle;
        if (this.currentFocusItem != null) {
            childHandle = this.currentFocusItem.handle;
        }
        if (OS.gtk_widget_child_focus(childHandle, dir)) {
            return true;
        }
        return super.forceFocus(focusHandle);
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (0 > index || index >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[index];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getBounds().contains(point)) continue;
            return items[i];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        long list = OS.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return 0;
        }
        int itemCount = OS.g_list_length(list);
        OS.g_list_free(list);
        return itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        long list = OS.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return new ToolItem[0];
        }
        int count = OS.g_list_length(list);
        ToolItem[] items = new ToolItem[count];
        long originalList = list;
        int index = 0;
        for (int i = 0; i < count; ++i) {
            long data = OS.g_list_data(list);
            Widget widget = this.display.getWidget(data);
            if (widget != null) {
                items[index++] = (ToolItem)widget;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        if (index != items.length) {
            ToolItem[] newItems = new ToolItem[index];
            System.arraycopy(items, 0, newItems, 0, index);
            items = newItems;
        }
        return items;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int count = 0;
        for (int i = 0; i < this.tabItemList.length; ++i) {
            if (this.tabItemList[i].isDisposed()) continue;
            ++count;
        }
        if (count == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] newList = new ToolItem[count];
        int index = 0;
        for (int i = 0; i < this.tabItemList.length; ++i) {
            if (this.tabItemList[i].isDisposed()) continue;
            newList[index++] = this.tabItemList[i];
        }
        this.tabItemList = newList;
        return this.tabItemList;
    }

    long gtk_key_press_event(long widget, long eventPtr) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long result = super.gtk_key_press_event(widget, eventPtr);
        return result;
    }

    long gtk_focus(long widget, long directionType) {
        return 0L;
    }

    boolean hasFocus() {
        if (this.hasChildFocus) {
            return true;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (item != items[i]) continue;
            return i;
        }
        return -1;
    }

    static long MenuItemSelectedProc(long widget, long user_data) {
        Display display = Display.getCurrent();
        ToolItem item = (ToolItem)display.getWidget(user_data);
        if (item != null) {
            return item.getParent().menuItemSelected(widget, item);
        }
        return 0L;
    }

    long menuItemSelected(long widget, ToolItem item) {
        Event event = new Event();
        switch (item.style) {
            case 4: {
                event.detail = 4;
                GtkAllocation allocation = new GtkAllocation();
                OS.gtk_widget_get_allocation(widget, allocation);
                event.x = allocation.x;
                if ((this.style & 0x8000000) != 0) {
                    event.x = this.getClientWidth() - allocation.width - event.x;
                }
                event.y = allocation.y + allocation.height;
                break;
            }
            case 16: {
                if ((this.style & 0x400000) != 0) break;
                item.selectRadio();
                break;
            }
            case 32: {
                boolean currentSelection = item.getSelection();
                item.setSelection(!currentSelection);
            }
        }
        item.sendSelectionEvent(13, event, false);
        return 0L;
    }

    boolean mnemonicHit(char key) {
        ToolItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            long labelHandle = items[i].labelHandle;
            if (labelHandle == 0L || !this.mnemonicHit(labelHandle, key)) continue;
            return true;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        ToolItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            long labelHandle = items[i].labelHandle;
            if (labelHandle == 0L || !this.mnemonicMatch(labelHandle, key)) continue;
            return true;
        }
        return false;
    }

    void relayout() {
        ToolItem[] items = this.getItems();
        boolean hasText = false;
        boolean hasImage = false;
        for (int i = 0; i < items.length; ++i) {
            ToolItem item = items[i];
            if (item == null) continue;
            item.resizeControl();
            hasText |= item.text != null && item.text.length() > 0;
            hasImage |= item.image != null;
        }
        int type = 0;
        if (hasText && hasImage) {
            type = (this.style & 0x20000) != 0 ? 3 : 2;
        } else if (hasText) {
            type = 1;
        } else if (hasImage) {
            type = 0;
        }
        OS.gtk_toolbar_set_style(this.handle, type);
    }

    void releaseChildren(boolean destroy) {
        ToolItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            ToolItem item = items[i];
            if (item == null || item.isDisposed()) continue;
            item.release(false);
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            ToolItem item = items[i];
            if (item.control != control) continue;
            item.setControl(null);
        }
    }

    void reskinChildren(int flags) {
        ToolItem[] items = this._getItems();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                ToolItem item = items[i];
                if (item == null) continue;
                item.reskin(flags);
            }
        }
        super.reskinChildren(flags);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        OS.gtk_toolbar_set_show_arrow(this.handle, false);
        int result = super.setBounds(x, y, width, height, move, resize);
        if ((result & 0x100) != 0) {
            this.relayout();
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_toolbar_set_show_arrow(this.handle, true);
        }
        return result;
    }

    void setFontDescription(long font) {
        super.setFontDescription(font);
        ToolItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].setFontDescription(font);
        }
        this.relayout();
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        ToolItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].setForegroundColor(color);
        }
    }

    void setOrientation(boolean create) {
        super.setOrientation(create);
        ToolItem[] items = this._getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].setOrientation(create);
        }
    }

    void setTabItemList(ToolItem[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            for (int i = 0; i < tabList.length; ++i) {
                ToolItem item = tabList[i];
                if (item == null) {
                    this.error(5);
                }
                if (item.isDisposed()) {
                    this.error(5);
                }
                if (item.parent == this) continue;
                this.error(32);
            }
            ToolItem[] newList = new ToolItem[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabItemList = tabList;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        Shell shell = this._getShell();
        ToolItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            String newString = string != null ? null : items[i].toolTipText;
            shell.setToolTipText(items[i].handle, newString);
        }
    }

    static {
        if (menuItemSelectedFunc.getAddress() == 0L) {
            SWT.error(3);
        }
    }
}

