/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah32.IteratingRLW32;

public class IntIteratorOverIteratingRLW32
implements IntIterator {
    IteratingRLW32 parent;
    private int position;
    private int runningLength;
    private int word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasnext;

    public IntIteratorOverIteratingRLW32(IteratingRLW32 p) {
        this.parent = p;
        this.position = 0;
        this.setupForCurrentRunningLengthWord();
        this.hasnext = this.moveToNext();
    }

    private final boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (this.parent.next()) {
                this.setupForCurrentRunningLengthWord();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasnext;
    }

    @Override
    public final int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position++;
        } else {
            System.out.println("this.literalPosition=" + this.literalPosition);
            int T = this.word & -this.word;
            answer = this.literalPosition + Integer.bitCount(T - 1);
            this.word ^= T;
        }
        this.hasnext = this.moveToNext();
        return answer;
    }

    private final void setupForCurrentRunningLengthWord() {
        this.runningLength = 64 * this.parent.getRunningLength() + this.position;
        if (!this.parent.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = 0;
        this.wordLength = this.parent.getNumberOfLiteralWords();
    }

    private final boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private final boolean literalHasNext() {
        while (this.word == 0 && this.wordPosition < this.wordLength) {
            this.word = this.parent.getLiteralWordAt(this.wordPosition++);
            this.literalPosition = this.position;
            this.position += 64;
        }
        return this.word != 0;
    }
}

