/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLogRunner;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNLog {
    public static final String DELETE_CHANGELIST = "delete-changelist";
    public static final String DELETE_ENTRY = "delete-entry";
    public static final String MODIFY_ENTRY = "modify-entry";
    public static final String MODIFY_WC_PROPERTY = "modify-wcprop";
    public static final String DELETE_LOCK = "delete-lock";
    public static final String MOVE = "mv";
    public static final String APPEND = "append";
    public static final String DELETE = "rm";
    public static final String READONLY = "readonly";
    public static final String COPY_AND_TRANSLATE = "cp-and-translate";
    public static final String COPY_AND_DETRANSLATE = "cp-and-detranslate";
    public static final String COPY = "cp";
    public static final String MERGE = "merge";
    public static final String MAYBE_READONLY = "maybe-readonly";
    public static final String MAYBE_EXECUTABLE = "maybe-executable";
    public static final String SET_TIMESTAMP = "set-timestamp";
    public static final String COMMIT = "committed";
    public static final String UPGRADE_FORMAT = "upgrade-format";
    public static final String ADD_TREE_CONFLICT = "add-tree-conflict";
    public static final String NAME_ATTR = "name";
    public static final String DATA_ATTR = "data";
    public static final String PROPERTY_NAME_ATTR = "propname";
    public static final String PROPERTY_VALUE_ATTR = "propval";
    public static final String DEST_ATTR = "dest";
    public static final String TIMESTAMP_ATTR = "timestamp";
    public static final String REVISION_ATTR = "revision";
    public static final String FORMAT_ATTR = "format";
    public static final String FORCE_ATTR = "force";
    public static final String ATTR1 = "arg1";
    public static final String ATTR2 = "arg2";
    public static final String ATTR3 = "arg3";
    public static final String ATTR4 = "arg4";
    public static final String ATTR5 = "arg5";
    public static final String ATTR6 = "arg6";
    public static final String WC_TIMESTAMP = "working";
    public static final String WC_WORKING_SIZE = "working";
    protected Collection myCache;
    protected SVNAdminArea myAdminArea;

    public abstract void save() throws SVNException;

    public abstract String toString();

    public abstract void delete() throws SVNException;

    public abstract boolean exists();

    protected SVNLog(SVNAdminArea adminArea) {
        this.myAdminArea = adminArea;
    }

    public void addCommand(String name, SVNProperties attributes, boolean save) throws SVNException {
        if (this.myCache == null) {
            this.myCache = new ArrayList();
        }
        attributes = new SVNProperties(attributes);
        attributes.put("", name);
        this.myCache.add(attributes);
        if (save) {
            this.save();
        }
    }

    public void deleteCommandsByName(String name, boolean save) throws SVNException {
        if (this.myCache == null) {
            return;
        }
        Iterator iterator = this.myCache.iterator();
        while (iterator.hasNext()) {
            SVNProperties attributes;
            String commandName;
            Object command = iterator.next();
            if (!(command instanceof SVNProperties) || !name.equals(commandName = (attributes = (SVNProperties)command).getStringValue(""))) continue;
            iterator.remove();
        }
        if (save) {
            this.save();
        }
    }

    public void deleteLastCommand(boolean save) throws SVNException {
        if (this.myCache == null) {
            return;
        }
        int size = this.myCache.size();
        int commandIdex = 0;
        Iterator iterator = this.myCache.iterator();
        while (iterator.hasNext()) {
            if (commandIdex == size - 1) {
                iterator.remove();
            }
            ++commandIdex;
        }
        if (save) {
            this.save();
        }
    }

    public void deleteCommandsByNameAndAttributes(String name, SVNProperties attributes, boolean save) throws SVNException {
        if (this.myCache == null) {
            return;
        }
        Iterator iterator = this.myCache.iterator();
        while (iterator.hasNext()) {
            SVNProperties commandAttributes;
            String commandName;
            Object command = iterator.next();
            if (!(command instanceof SVNProperties) || !name.equals(commandName = (commandAttributes = (SVNProperties)command).getStringValue(""))) continue;
            SVNProperties commandAttributesWithoutName = new SVNProperties(commandAttributes);
            commandAttributesWithoutName.remove("");
            if (!commandAttributesWithoutName.equals(attributes)) continue;
            iterator.remove();
        }
        if (save) {
            this.save();
        }
    }

    public SVNStatusType logChangedEntryProperties(String name, SVNProperties modifiedEntryProps) throws SVNException {
        SVNStatusType status = SVNStatusType.LOCK_UNCHANGED;
        if (modifiedEntryProps != null) {
            SVNProperties command = new SVNProperties();
            command.put(NAME_ATTR, name);
            for (String propName : modifiedEntryProps.nameSet()) {
                String longPropName;
                SVNPropertyValue propValue = modifiedEntryProps.getSVNPropertyValue(propName);
                String string = longPropName = !propName.startsWith("svn:entry:") ? "svn:entry:" + propName : propName;
                if ("svn:entry:lock-token".equals(longPropName)) {
                    SVNProperties deleteLockCommand = new SVNProperties();
                    deleteLockCommand.put(NAME_ATTR, name);
                    this.addCommand(DELETE_LOCK, deleteLockCommand, false);
                    status = SVNStatusType.LOCK_UNLOCKED;
                    continue;
                }
                if (propValue == null) continue;
                command.put(propName, propValue);
            }
            this.addCommand(MODIFY_ENTRY, command, false);
            command.clear();
        }
        return status;
    }

    public void logChangedWCProperties(String name, SVNProperties modifiedWCProps) throws SVNException {
        if (modifiedWCProps != null) {
            SVNProperties command = new SVNProperties();
            command.put(NAME_ATTR, name);
            for (String propName : modifiedWCProps.nameSet()) {
                SVNPropertyValue propValue = modifiedWCProps.getSVNPropertyValue(propName);
                command.put(PROPERTY_NAME_ATTR, propName);
                if (propValue != null) {
                    command.put(PROPERTY_VALUE_ATTR, propValue);
                } else {
                    command.remove(PROPERTY_VALUE_ATTR);
                }
                this.addCommand(MODIFY_WC_PROPERTY, command, false);
            }
        }
    }

    public void logTweakEntry(String name, String newURL, long newRevision) throws SVNException {
        SVNProperties attributes = new SVNProperties();
        attributes.put(SVNProperty.shortPropertyName("svn:entry:kind"), "file");
        attributes.put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(newRevision));
        attributes.put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.FALSE.toString());
        attributes.put(SVNProperty.shortPropertyName("svn:entry:absent"), Boolean.FALSE.toString());
        attributes.put(SVNProperty.shortPropertyName("svn:entry:working-size"), Long.toString(-1L));
        attributes.put(SVNProperty.shortPropertyName("svn:entry:text-time"), SVNDate.NULL.format());
        if (newURL != null) {
            attributes.put(SVNProperty.shortPropertyName("svn:entry:url"), newURL);
        }
        this.logChangedEntryProperties(name, attributes);
    }

    public void logRemoveRevertFile(String name, SVNAdminArea adminArea, boolean isProp) throws SVNException {
        String revertPath = null;
        revertPath = isProp ? SVNAdminUtil.getPropRevertPath(name, SVNNodeKind.FILE, false) : SVNAdminUtil.getTextRevertPath(name, false);
        File revertFile = adminArea.getFile(revertPath);
        if (revertFile.isFile()) {
            SVNProperties command = new SVNProperties();
            command.put(NAME_ATTR, revertPath);
            this.addCommand(DELETE, command, false);
            command.clear();
        }
    }

    public void run(SVNLogRunner runner) throws SVNException {
        Collection commands = this.readCommands();
        if (commands == null || commands.isEmpty()) {
            return;
        }
        try {
            int count = 0;
            Iterator cmds = commands.iterator();
            while (cmds.hasNext()) {
                SVNProperties command = (SVNProperties)cmds.next();
                String name = command.getStringValue("");
                String attrName = command.getStringValue(NAME_ATTR);
                if (attrName == null && !UPGRADE_FORMAT.equals(name)) {
                    SVNErrorCode code = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                    SVNErrorMessage err = SVNErrorMessage.create(code, "Log entry missing ''name'' attribute (entry ''{0}'' for directory ''{1}'')", name, this.myAdminArea.getRoot());
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if (runner != null) {
                    runner.runCommand(this.myAdminArea, name, command, ++count);
                }
                cmds.remove();
            }
        }
        catch (SVNException e) {
            this.myCache = null;
            for (SVNProperties command : commands) {
                SVNPropertyValue name = command.remove("");
                this.addCommand(name.getString(), command, false);
            }
            this.save();
            throw e;
        }
    }

    protected abstract Collection readCommands() throws SVNException;
}

