/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.parboiled.Action;
import org.parboiled.Rule;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.AnyMatcher;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.CharIgnoreCaseMatcher;
import org.parboiled.matchers.CharMatcher;
import org.parboiled.matchers.CharRangeMatcher;
import org.parboiled.matchers.CustomMatcher;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.FirstOfStringsMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.MemoMismatchesMatcher;
import org.parboiled.matchers.NothingMatcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.OptionalMatcher;
import org.parboiled.matchers.ProxyMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.StringMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.matchers.VarFramingMatcher;
import org.parboiled.matchers.ZeroOrMoreMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserStatistics
implements MatcherVisitor<ParserStatistics> {
    private final Matcher root;
    private int totalRules;
    private final Set<AnyMatcher> anyMatchers = new HashSet<AnyMatcher>();
    private final Set<CharIgnoreCaseMatcher> charIgnoreCaseMatchers = new HashSet<CharIgnoreCaseMatcher>();
    private final Set<CharMatcher> charMatchers = new HashSet<CharMatcher>();
    private final Set<CustomMatcher> customMatchers = new HashSet<CustomMatcher>();
    private final Set<CharRangeMatcher> charRangeMatchers = new HashSet<CharRangeMatcher>();
    private final Set<AnyOfMatcher> anyOfMatchers = new HashSet<AnyOfMatcher>();
    private final Set<EmptyMatcher> emptyMatchers = new HashSet<EmptyMatcher>();
    private final Set<FirstOfMatcher> firstOfMatchers = new HashSet<FirstOfMatcher>();
    private final Set<FirstOfStringsMatcher> firstOfStringMatchers = new HashSet<FirstOfStringsMatcher>();
    private final Set<NothingMatcher> nothingMatchers = new HashSet<NothingMatcher>();
    private final Set<OneOrMoreMatcher> oneOrMoreMatchers = new HashSet<OneOrMoreMatcher>();
    private final Set<OptionalMatcher> optionalMatchers = new HashSet<OptionalMatcher>();
    private final Set<SequenceMatcher> sequenceMatchers = new HashSet<SequenceMatcher>();
    private final Set<StringMatcher> stringMatchers = new HashSet<StringMatcher>();
    private final Set<TestMatcher> testMatchers = new HashSet<TestMatcher>();
    private final Set<TestNotMatcher> testNotMatchers = new HashSet<TestNotMatcher>();
    private final Set<ZeroOrMoreMatcher> zeroOrMoreMatchers = new HashSet<ZeroOrMoreMatcher>();
    private final Set<Action> actions = new HashSet<Action>();
    private final Set<Class<?>> actionClasses = new HashSet();
    private final Set<ProxyMatcher> proxyMatchers = new HashSet<ProxyMatcher>();
    private final Set<VarFramingMatcher> varFramingMatchers = new HashSet<VarFramingMatcher>();
    private final Set<MemoMismatchesMatcher> memoMismatchesMatchers = new HashSet<MemoMismatchesMatcher>();

    public static ParserStatistics generateFor(Rule rule) {
        Preconditions.checkArgNotNull((Object)rule, (String)"rule");
        Matcher matcher = (Matcher)rule;
        return (ParserStatistics)matcher.accept((MatcherVisitor)new ParserStatistics(matcher));
    }

    private ParserStatistics(Matcher matcher) {
        this.root = matcher;
        this.countSpecials(matcher);
    }

    public Rule getRootRule() {
        return this.root;
    }

    public int getTotalRules() {
        return this.totalRules;
    }

    public Set<AnyMatcher> getAnyMatchers() {
        return this.anyMatchers;
    }

    public Set<CharIgnoreCaseMatcher> getCharIgnoreCaseMatchers() {
        return this.charIgnoreCaseMatchers;
    }

    public Set<CharMatcher> getCharMatchers() {
        return this.charMatchers;
    }

    public Set<CustomMatcher> getCustomMatchers() {
        return this.customMatchers;
    }

    public Set<CharRangeMatcher> getCharRangeMatchers() {
        return this.charRangeMatchers;
    }

    public Set<AnyOfMatcher> getAnyOfMatchers() {
        return this.anyOfMatchers;
    }

    public Set<EmptyMatcher> getEmptyMatchers() {
        return this.emptyMatchers;
    }

    public Set<FirstOfMatcher> getFirstOfMatchers() {
        return this.firstOfMatchers;
    }

    public Set<FirstOfStringsMatcher> getFirstOfStringMatchers() {
        return this.firstOfStringMatchers;
    }

    public Set<MemoMismatchesMatcher> getMemoMismatchesMatchers() {
        return this.memoMismatchesMatchers;
    }

    public Set<NothingMatcher> getNothingMatchers() {
        return this.nothingMatchers;
    }

    public Set<OneOrMoreMatcher> getOneOrMoreMatchers() {
        return this.oneOrMoreMatchers;
    }

    public Set<OptionalMatcher> getOptionalMatchers() {
        return this.optionalMatchers;
    }

    public Set<SequenceMatcher> getSequenceMatchers() {
        return this.sequenceMatchers;
    }

    public Set<StringMatcher> getStringMatchers() {
        return this.stringMatchers;
    }

    public Set<TestMatcher> getTestMatchers() {
        return this.testMatchers;
    }

    public Set<TestNotMatcher> getTestNotMatchers() {
        return this.testNotMatchers;
    }

    public Set<ZeroOrMoreMatcher> getZeroOrMoreMatchers() {
        return this.zeroOrMoreMatchers;
    }

    public Set<Action> getActions() {
        return this.actions;
    }

    public Set<Class<?>> getActionClasses() {
        return this.actionClasses;
    }

    public Set<ProxyMatcher> getProxyMatchers() {
        return this.proxyMatchers;
    }

    public Set<VarFramingMatcher> getVarFramingMatchers() {
        return this.varFramingMatchers;
    }

    public ParserStatistics visit(ActionMatcher actionMatcher) {
        if (!this.actions.contains(actionMatcher.action)) {
            ++this.totalRules;
            this.actions.add(actionMatcher.action);
            this.actionClasses.add(actionMatcher.action.getClass());
        }
        return this;
    }

    public ParserStatistics visit(AnyMatcher anyMatcher) {
        return this.visit(anyMatcher, this.anyMatchers);
    }

    public ParserStatistics visit(CharIgnoreCaseMatcher charIgnoreCaseMatcher) {
        return this.visit(charIgnoreCaseMatcher, this.charIgnoreCaseMatchers);
    }

    public ParserStatistics visit(CharMatcher charMatcher) {
        return this.visit(charMatcher, this.charMatchers);
    }

    public ParserStatistics visit(CustomMatcher customMatcher) {
        return this.visit(customMatcher, this.customMatchers);
    }

    public ParserStatistics visit(CharRangeMatcher charRangeMatcher) {
        return this.visit(charRangeMatcher, this.charRangeMatchers);
    }

    public ParserStatistics visit(AnyOfMatcher anyOfMatcher) {
        return this.visit(anyOfMatcher, this.anyOfMatchers);
    }

    public ParserStatistics visit(EmptyMatcher emptyMatcher) {
        return this.visit(emptyMatcher, this.emptyMatchers);
    }

    public ParserStatistics visit(FirstOfMatcher firstOfMatcher) {
        return firstOfMatcher instanceof FirstOfStringsMatcher ? this.visit((FirstOfStringsMatcher)firstOfMatcher, this.firstOfStringMatchers) : this.visit(firstOfMatcher, this.firstOfMatchers);
    }

    public ParserStatistics visit(NothingMatcher nothingMatcher) {
        return this.visit(nothingMatcher, this.nothingMatchers);
    }

    public ParserStatistics visit(OneOrMoreMatcher oneOrMoreMatcher) {
        return this.visit(oneOrMoreMatcher, this.oneOrMoreMatchers);
    }

    public ParserStatistics visit(OptionalMatcher optionalMatcher) {
        return this.visit(optionalMatcher, this.optionalMatchers);
    }

    public ParserStatistics visit(SequenceMatcher sequenceMatcher) {
        return sequenceMatcher instanceof StringMatcher ? this.visit((StringMatcher)sequenceMatcher, this.stringMatchers) : this.visit(sequenceMatcher, this.sequenceMatchers);
    }

    public ParserStatistics visit(TestMatcher testMatcher) {
        return this.visit(testMatcher, this.testMatchers);
    }

    public ParserStatistics visit(TestNotMatcher testNotMatcher) {
        return this.visit(testNotMatcher, this.testNotMatchers);
    }

    public ParserStatistics visit(ZeroOrMoreMatcher zeroOrMoreMatcher) {
        return this.visit(zeroOrMoreMatcher, this.zeroOrMoreMatchers);
    }

    private <M extends Matcher> ParserStatistics visit(M m, Set<M> set) {
        if (!set.contains(m)) {
            ++this.totalRules;
            set.add(m);
            for (Matcher matcher : m.getChildren()) {
                this.countSpecials(matcher);
                matcher.accept((MatcherVisitor)this);
            }
        }
        return this;
    }

    private void countSpecials(Matcher matcher) {
        if (matcher instanceof ProxyMatcher) {
            this.proxyMatchers.add((ProxyMatcher)matcher);
        } else if (matcher instanceof VarFramingMatcher) {
            this.varFramingMatchers.add((VarFramingMatcher)matcher);
        } else if (matcher instanceof MemoMismatchesMatcher) {
            this.memoMismatchesMatchers.add((MemoMismatchesMatcher)matcher);
        }
    }

    public String toString() {
        return "Parser statistics for rule '" + this.root + "':\n" + "    Total rules       : " + this.totalRules + '\n' + "        Actions       : " + this.actions.size() + '\n' + "        Any           : " + this.anyMatchers.size() + '\n' + "        CharIgnoreCase: " + this.charIgnoreCaseMatchers.size() + '\n' + "        Char          : " + this.charMatchers.size() + '\n' + "        Custom        : " + this.customMatchers.size() + '\n' + "        CharRange     : " + this.charRangeMatchers.size() + '\n' + "        AnyOf         : " + this.anyOfMatchers.size() + '\n' + "        Empty         : " + this.emptyMatchers.size() + '\n' + "        FirstOf       : " + this.firstOfMatchers.size() + '\n' + "        FirstOfStrings: " + this.firstOfStringMatchers.size() + '\n' + "        Nothing       : " + this.nothingMatchers.size() + '\n' + "        OneOrMore     : " + this.oneOrMoreMatchers.size() + '\n' + "        Optional      : " + this.optionalMatchers.size() + '\n' + "        Sequence      : " + this.sequenceMatchers.size() + '\n' + "        String        : " + this.stringMatchers.size() + '\n' + "        Test          : " + this.testMatchers.size() + '\n' + "        TestNot       : " + this.testNotMatchers.size() + '\n' + "        ZeroOrMore    : " + this.zeroOrMoreMatchers.size() + '\n' + '\n' + "    Action Classes    : " + this.actionClasses.size() + '\n' + "    ProxyMatchers     : " + this.proxyMatchers.size() + '\n' + "    VarFramingMatchers: " + this.varFramingMatchers.size() + '\n' + "MemoMismatchesMatchers: " + this.memoMismatchesMatchers.size() + '\n';
    }

    public String printActionClassInstances() {
        StringBuilder stringBuilder = new StringBuilder("Action classes and their instances for rule '").append(this.root).append("':\n");
        for (String string : this.printActionClassLines()) {
            stringBuilder.append("    ").append(string).append('\n');
        }
        return stringBuilder.toString();
    }

    private List<String> printActionClassLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (Class<?> clazz : this.actionClasses) {
            String string = clazz.getSimpleName();
            if (StringUtils.isEmpty((String)string)) {
                ++n;
                continue;
            }
            arrayList.add(string + " : " + StringUtils.join(this.printActionClassInstances(clazz), (String)", "));
        }
        Collections.sort(arrayList);
        if (n > 0) {
            arrayList.add("and " + n + " anonymous instance(s)");
        }
        return arrayList;
    }

    private List<String> printActionClassInstances(Class<?> clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Action action : this.actions) {
            if (!action.getClass().equals(clazz)) continue;
            arrayList.add(action.toString());
        }
        Collections.sort(arrayList);
        return arrayList;
    }
}

